/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.model;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.model.DocumentUploadType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ParametersAreNonnullByDefault
public enum DocumentType {
    ORIGINAL/* Unavailable Anonymous Inner Class!! */,
    PDF/* Unavailable Anonymous Inner Class!! */,
    HTML/* Unavailable Anonymous Inner Class!! */;

    private final DocumentUploadType _uploadType;
    private final String _converterName;

    private DocumentType(DocumentUploadType uploadType, String converterName) {
        this._uploadType = uploadType;
        this._converterName = converterName;
    }

    @Nonnull
    public abstract <T> T apply(DocumentTypeVisitor<T> var1);

    @Nonnull
    public abstract String toFilename(DocumentId var1);

    @Nonnull
    public abstract ImmutableSet<DocumentType> produces();

    @Nonnull
    public DocumentUploadType uploadType() {
        return this._uploadType;
    }

    @Nonnull
    public String getConverterNameForVersionOneZeroX() {
        return this._converterName;
    }
}

