/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import java.util.List;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\u0012\u0004\u0012\u00020\u00020\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH'J\u0016\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageAttachmentRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "Ljava/util/UUID;", "Lorg/springframework/data/jpa/repository/JpaSpecificationExecutor;", "deleteByChatIdIn", "", "chatIds", "", "deleteByChatIds", "chat-service"})
public interface ChatMessageAttachmentRepository
extends JpaRepository<DbChatMessageAttachment, UUID>,
JpaSpecificationExecutor<DbChatMessageAttachment> {
    @Query(value="\n            DELETE\n            FROM DbChatMessageAttachment a\n            WHERE a.chatMessage.chatId IN :chatIds\n        ")
    @Modifying
    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteByChatIds(chatIds)", imports={}))
    public void deleteByChatIdIn(@NotNull Iterable<UUID> var1);

    @Transactional
    default public void deleteByChatIds(@NotNull Iterable<UUID> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        for (List ids : CollectionsKt.chunked(chatIds, (int)1000)) {
            this.deleteByChatIdIn((Iterable)ids);
        }
    }
}

