/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.mobile.service.InternalNotificationService;
import de.justsoftware.chat.model.ProfileId;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/chat/mobile/service/InternalNotificationService;", "", "internalNotificationBaseUrl", "", "webClientBuilder", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient$Builder;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "getUnreadSocialNotificationCounts", "", "Lde/justsoftware/chat/model/ProfileId;", "", "profileIds", "", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nInternalNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalNotificationService.kt\nde/justsoftware/chat/mobile/service/InternalNotificationService\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,41:1\n137#2:42\n9#3:43\n8#3,3:44\n*S KotlinDebug\n*F\n+ 1 InternalNotificationService.kt\nde/justsoftware/chat/mobile/service/InternalNotificationService\n*L\n31#1:42\n38#1:43\n38#1:44,3\n*E\n"})
public class InternalNotificationService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private static final Logger LOG;

    public InternalNotificationService(@Value(value="${just.notification.internal}") @NotNull String internalNotificationBaseUrl, @NotNull WebClient.Builder webClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)internalNotificationBaseUrl, (String)"internalNotificationBaseUrl");
        Intrinsics.checkNotNullParameter((Object)webClientBuilder, (String)"webClientBuilder");
        String[] stringArray = new String[]{"application/json"};
        WebClient webClient = webClientBuilder.baseUrl(internalNotificationBaseUrl).defaultHeader("Accept", stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        this.webClient = webClient;
    }

    @NotNull
    public Map<ProfileId, Integer> getUnreadSocialNotificationCounts(@NotNull Set<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        if (profileIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        String[] stringArray = new String[]{"application/json"};
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/notification/open", new Object[0])).bodyValue(profileIds).header("Content-Type", stringArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        Map map = (Map)mono.doOnError(arg_0 -> InternalNotificationService.getUnreadSocialNotificationCounts$lambda$1(InternalNotificationService::getUnreadSocialNotificationCounts$lambda$0, arg_0)).onErrorReturn((Object)MapsKt.emptyMap()).block();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private static final Unit getUnreadSocialNotificationCounts$lambda$0(Throwable e) {
        LOG.error("Error while retrieving unread social notification counts", e);
        return Unit.INSTANCE;
    }

    private static final void getUnreadSocialNotificationCounts$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

