/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatMessageService$validatedMessageForDelete$;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.DriveService;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatMessageAttachment;
import de.justsoftware.chat.business.model.ChatMessageReaction;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.PersonMention;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.drive.DriveAttachment;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageDeletedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.UserMessageUpdatedEvent;
import de.justsoftware.chat.exception.ChatMessageAlreadyExistsException;
import de.justsoftware.chat.exception.CitationDoesNotExistException;
import de.justsoftware.chat.exception.CitationOfNonUserMessageException;
import de.justsoftware.chat.exception.CrossChatCitationException;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ChatMessagePayload;
import de.justsoftware.chat.model.LimitOffset;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ReactionId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.ChatMessageReactionRepository;
import de.justsoftware.chat.persistence.ChatMessageRepository;
import de.justsoftware.chat.persistence.ChatMessageSpecifications;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.PersonMentionRepository;
import de.justsoftware.chat.persistence.RemovedMessageReactionForSyncRepository;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import de.justsoftware.chat.persistence.model.DbChatMessageReaction;
import de.justsoftware.chat.persistence.model.DbProfileIdProjection;
import de.justsoftware.chat.persistence.model.DbReactionId;
import de.justsoftware.chat.persistence.model.DbRemovedMessageReactionForSync;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.OptionalUtilsKt;
import de.justsoftware.chat.util.PagingUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import jakarta.persistence.EntityManager;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 {2\u00020\u0001:\u0001{Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ*\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\b\u0002\u0010\"\u001a\u00020#H\u0017J.\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0 2\u0006\u0010)\u001a\u00020*H\u0017J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020*H\u0017J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d002\u0006\u00101\u001a\u00020-H\u0017J\u0010\u00102\u001a\u00020\u001d2\u0006\u00101\u001a\u00020-H\u0017J\"\u00103\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001d042\f\u00105\u001a\b\u0012\u0004\u0012\u00020-06H\u0017J\u001a\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020-0908H\u0017J4\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001d0<2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010CH\u0017JD\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0<2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020A2\u0006\u0010E\u001a\u00020F2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010G\u001a\u00020#H\u0017JB\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001d0<2\u0006\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020?2\u0006\u0010=\u001a\u00020:2\b\u0010B\u001a\u0004\u0018\u00010C2\u0010\b\u0002\u0010I\u001a\n\u0012\u0004\u0012\u00020K\u0018\u00010JH\u0012J.\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001d0<2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020:0N2\b\u0010O\u001a\u0004\u0018\u00010F2\u0006\u0010>\u001a\u00020?H\u0016J$\u0010P\u001a\b\u0012\u0004\u0012\u00020*062\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0R2\u0006\u0010T\u001a\u00020FH\u0016J(\u0010U\u001a\u00020V2\u0006\u0010,\u001a\u00020-2\u0006\u0010=\u001a\u00020:2\u0006\u0010.\u001a\u00020*2\u0006\u0010W\u001a\u00020&H\u0017J \u0010X\u001a\u00020Y2\u0006\u0010,\u001a\u00020-2\u0006\u0010=\u001a\u00020:2\u0006\u0010.\u001a\u00020*H\u0017J\u0010\u0010Z\u001a\u00020Y2\u0006\u0010,\u001a\u00020-H\u0017J(\u0010[\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0 042\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020-0RH\u0016J$\u0010]\u001a\b\u0012\u0004\u0012\u00020V0 2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0R2\u0006\u0010O\u001a\u00020FH\u0016J$\u0010^\u001a\b\u0012\u0004\u0012\u00020_062\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0R2\u0006\u0010O\u001a\u00020FH\u0016J\u0010\u0010`\u001a\u00020Y2\u0006\u0010a\u001a\u00020bH\u0017J\u0010\u0010c\u001a\u00020Y2\u0006\u0010d\u001a\u00020eH\u0017J\u0010\u0010f\u001a\u00020Y2\u0006\u0010g\u001a\u00020hH\u0017J\u0010\u0010i\u001a\u00020Y2\u0006\u0010g\u001a\u00020hH\u0012J\u0010\u0010j\u001a\u00020Y2\u0006\u0010g\u001a\u00020hH\u0012J\u0010\u0010k\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0012J\u001e\u0010l\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020m2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0012J\f\u0010n\u001a\u00020Y*\u00020hH\u0012J+\u0010o\u001a\u0002Hp\"\b\b\u0000\u0010p*\u00020\u001d*\u0002Hp2\u000e\b\u0002\u0010q\u001a\b\u0012\u0004\u0012\u00020r0 H\u0012\u00a2\u0006\u0002\u0010sJ\u0014\u0010t\u001a\u00020m*\u00020m2\u0006\u0010)\u001a\u00020*H\u0012J\u001a\u0010u\u001a\u00020Y*\u00020m2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020r0 H\u0016J\f\u0010v\u001a\u00020Y*\u00020mH\u0016J\f\u0010w\u001a\u00020Y*\u00020mH\u0016J%\u0010x\u001a\n y*\u0004\u0018\u00010m0m2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020*H\u0012\u00a2\u0006\u0002\u0010zR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lde/justsoftware/chat/business/ChatMessageService;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "chatMessageRepository", "Lde/justsoftware/chat/persistence/ChatMessageRepository;", "personMentionRepository", "Lde/justsoftware/chat/persistence/PersonMentionRepository;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "chatMessageReactionRepository", "Lde/justsoftware/chat/persistence/ChatMessageReactionRepository;", "removedMessageReactionForSyncRepository", "Lde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository;", "entityManager", "Ljakarta/persistence/EntityManager;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "driveService", "Lde/justsoftware/chat/business/DriveService;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatReadDateService;Lde/justsoftware/chat/persistence/ChatMessageRepository;Lde/justsoftware/chat/persistence/PersonMentionRepository;Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/persistence/ChatMessageReactionRepository;Lde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository;Ljakarta/persistence/EntityManager;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/business/DriveService;Lde/justsoftware/chat/util/TransactionUtils;Ljava/time/Clock;)V", "create", "Lde/justsoftware/chat/business/model/ChatMessage;", "chatMessage", "files", "", "Lorg/springframework/web/multipart/MultipartFile;", "shouldMarkChatAsRead", "", "edit", "newMessageText", "", "newPersonMentions", "Lde/justsoftware/chat/business/model/PersonMention;", "editor", "Lde/justsoftware/chat/model/ProfileId;", "delete", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "profileId", "findById", "Ljava/util/Optional;", "id", "getById", "findByIds", "", "ids", "", "streamAllUserMessageIds", "Ljava/util/stream/Stream;", "Lkotlin/Pair;", "Lde/justsoftware/chat/model/ChatId;", "getMessages", "Lorg/springframework/data/domain/Page;", "chatId", "limit", "", "loadDirection", "Lde/justsoftware/chat/business/LoadDirection;", "attachmentFilter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "getMessagesStartingAtTimestamp", "offsetTimestamp", "Ljava/time/Instant;", "includeOffsetMessage", "getMessagesWithSpecification", "additionalSpecification", "Lorg/springframework/data/jpa/domain/Specification;", "Lde/justsoftware/chat/persistence/model/DbChatMessage;", "getRecentMessages", "chatIds", "", "updatedSince", "findUpdatedAuthorsAndReactors", "participantIds", "", "Lde/justsoftware/chat/model/ParticipantId;", "since", "react", "Lde/justsoftware/chat/business/model/ChatMessageReaction;", "reaction", "deleteReaction", "", "deleteReactions", "getReactions", "messageIds", "getUpdatedReactions", "getDeletedReactionIds", "Lde/justsoftware/chat/model/ReactionId;", "onChatInfoChangedEvent", "chatUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "onChatCreatedEvent", "chatCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "onChatParticipantsChangedEvent", "chatParticipantsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "sendSystemMessageForRemovedParticipants", "sendSystemMessageForAddedParticipants", "createWithoutAttachments", "createWithAttachments", "Lde/justsoftware/chat/business/model/UserMessage;", "handleDeletedParticipants", "validatedForCreate", "T", "attachments", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "(Lde/justsoftware/chat/business/model/ChatMessage;Ljava/util/List;)Lde/justsoftware/chat/business/model/ChatMessage;", "validatedForEdit", "validate", "validateCitation", "checkNoDuplicateMentions", "validatedMessageForDelete", "kotlin.jvm.PlatformType", "(Lde/justsoftware/chat/model/ChatMessageId;Lde/justsoftware/chat/model/ProfileId;)Lde/justsoftware/chat/business/model/UserMessage;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageService.kt\nde/justsoftware/chat/business/ChatMessageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 OptionalUtils.kt\nde/justsoftware/chat/util/OptionalUtilsKt\n*L\n1#1,691:1\n1557#2:692\n1628#2,3:693\n1557#2:697\n1628#2,3:698\n1557#2:701\n1628#2,3:702\n1187#2,2:705\n1261#2,4:707\n1557#2:711\n1628#2,3:712\n1557#2:715\n1628#2,3:716\n1628#2,3:720\n1628#2,3:724\n1557#2:727\n1628#2,3:728\n1279#2,2:731\n1293#2,2:733\n1557#2:735\n1628#2,3:736\n1296#2:739\n1557#2:740\n1628#2,3:741\n1557#2:744\n1628#2,3:745\n1557#2:748\n1628#2,3:749\n1628#2,3:753\n817#2,2:757\n1557#2:759\n1628#2,3:760\n1557#2:764\n1628#2,3:765\n1#3:696\n7#4:719\n7#4:723\n7#4:752\n22#4:756\n5#5:763\n*S KotlinDebug\n*F\n+ 1 ChatMessageService.kt\nde/justsoftware/chat/business/ChatMessageService\n*L\n153#1:692\n153#1:693,3\n205#1:697\n205#1:698,3\n228#1:701\n228#1:702,3\n229#1:705,2\n229#1:707,4\n284#1:711\n284#1:712,3\n292#1:715\n292#1:716,3\n294#1:720,3\n296#1:724,3\n362#1:727\n362#1:728,3\n363#1:731,2\n363#1:733,2\n364#1:735\n364#1:736,3\n363#1:739\n373#1:740\n373#1:741,3\n375#1:744\n375#1:745,3\n382#1:748\n382#1:749,3\n384#1:753,3\n461#1:757,2\n499#1:759\n499#1:760,3\n529#1:764\n529#1:765,3\n294#1:719\n296#1:723\n384#1:752\n461#1:756\n649#1:763\n*E\n"})
public class ChatMessageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    @NotNull
    private final ChatMessageRepository chatMessageRepository;
    @NotNull
    private final PersonMentionRepository personMentionRepository;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final ChatMessageReactionRepository chatMessageReactionRepository;
    @NotNull
    private final RemovedMessageReactionForSyncRepository removedMessageReactionForSyncRepository;
    @NotNull
    private final EntityManager entityManager;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Set<String> IMAGE_FORMATS;
    public static final long EDIT_CHAT_MESSAGE_MAXIMUM_TIME_IN_SECONDS = 300L;
    private static final int MAX_MESSAGE_LENGTH = 10000;

    public ChatMessageService(@NotNull ChatService chatService, @NotNull ChatReadDateService chatReadDateService, @NotNull ChatMessageRepository chatMessageRepository, @NotNull PersonMentionRepository personMentionRepository, @NotNull ChatRepository chatRepository, @NotNull ChatMessageReactionRepository chatMessageReactionRepository, @NotNull RemovedMessageReactionForSyncRepository removedMessageReactionForSyncRepository, @NotNull EntityManager entityManager, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull DriveService driveService, @NotNull TransactionUtils transactionUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        Intrinsics.checkNotNullParameter((Object)chatMessageRepository, (String)"chatMessageRepository");
        Intrinsics.checkNotNullParameter((Object)personMentionRepository, (String)"personMentionRepository");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)chatMessageReactionRepository, (String)"chatMessageReactionRepository");
        Intrinsics.checkNotNullParameter((Object)removedMessageReactionForSyncRepository, (String)"removedMessageReactionForSyncRepository");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatService = chatService;
        this.chatReadDateService = chatReadDateService;
        this.chatMessageRepository = chatMessageRepository;
        this.personMentionRepository = personMentionRepository;
        this.chatRepository = chatRepository;
        this.chatMessageReactionRepository = chatMessageReactionRepository;
        this.removedMessageReactionForSyncRepository = removedMessageReactionForSyncRepository;
        this.entityManager = entityManager;
        this.applicationEventPublisher = applicationEventPublisher;
        this.driveService = driveService;
        this.transactionUtils = transactionUtils;
        this.clock = clock;
    }

    @Transactional
    @NotNull
    public ChatMessage create(@NotNull ChatMessage chatMessage, @NotNull List<? extends MultipartFile> files, boolean shouldMarkChatAsRead) throws ValidationException {
        ChatMessage chatMessage2;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ChatMessage chatMessage3 = chatMessage;
        if (chatMessage3 instanceof UserMessage) {
            chatMessage2 = files.isEmpty() ? this.createWithoutAttachments(chatMessage) : this.createWithAttachments((UserMessage)chatMessage, files);
        } else if (chatMessage3 instanceof SystemMessage) {
            chatMessage2 = this.createWithoutAttachments(chatMessage);
        } else {
            throw new ValidationException("Cannot create non-user-non-system message", null, 2, null);
        }
        ChatMessage savedChatMessage = chatMessage2;
        boolean bl = false;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        ChatMessage updatedChatMessage = Companion.access$copy((Companion)Companion, (ChatMessage)savedChatMessage, (Instant)instant);
        this.chatMessageRepository.updateUpdatedAt(updatedChatMessage.getId().getValue(), updatedChatMessage.getUpdatedAt());
        this.chatService.updateOnNewMessage(updatedChatMessage);
        if (shouldMarkChatAsRead) {
            this.chatReadDateService.markAsRead(chatMessage.getChatId(), chatMessage.getAuthor(), savedChatMessage.getCreatedAt());
        }
        this.transactionUtils.afterCommit(() -> ChatMessageService.create$lambda$1$lambda$0(this, updatedChatMessage));
        return updatedChatMessage;
    }

    public static /* synthetic */ ChatMessage create$default(ChatMessageService chatMessageService, ChatMessage chatMessage, List list, boolean bl, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return chatMessageService.create(chatMessage, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ChatMessage edit(@NotNull ChatMessage chatMessage, @NotNull String newMessageText, @NotNull List<PersonMention> newPersonMentions, @NotNull ProfileId editor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)newMessageText, (String)"newMessageText");
        Intrinsics.checkNotNullParameter(newPersonMentions, (String)"newPersonMentions");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!(chatMessage instanceof UserMessage)) {
            throw new ValidationException("Cannot edit message " + chatMessage.getId() + " - is not a user message", null, 2, null);
        }
        Instant editedAt = this.clock.instant();
        UserMessage userMessage = (UserMessage)chatMessage;
        Intrinsics.checkNotNull((Object)editedAt);
        UserMessage editedChatMessage = UserMessage.Companion.withEditedMessage(userMessage, newMessageText, newPersonMentions, editedAt);
        Iterable $this$map$iv = editedChatMessage.getPersonMentions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersonMention personMention = (PersonMention)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PersonMention.Companion.toDbPersonMention((PersonMention)it, (ChatMessage)editedChatMessage));
        }
        List dbPersonMentions = (List)destination$iv$iv;
        DbChatMessage dbUpdatedChatMessage = (DbChatMessage)this.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)((ChatMessage)this.validatedForEdit(editedChatMessage, editor2)), null, (List)dbPersonMentions, (int)1, null));
        this.chatRepository.updateSyncDateByChatIds(SetsKt.setOf((Object)dbUpdatedChatMessage.getChatId()), editedAt);
        this.entityManager.flush();
        this.entityManager.refresh((Object)dbUpdatedChatMessage);
        Intrinsics.checkNotNull((Object)dbUpdatedChatMessage);
        ChatMessage updatedChatMessage = DbChatMessage.Companion.toChatMessage(dbUpdatedChatMessage);
        if (!(updatedChatMessage instanceof UserMessage)) {
            boolean bl = false;
            String string = "Repo returned non-user message after edit";
            throw new IllegalArgumentException(string.toString());
        }
        this.transactionUtils.afterCommit(() -> ChatMessageService.edit$lambda$4(this, updatedChatMessage));
        return updatedChatMessage;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ChatMessage delete(@NotNull ChatMessageId chatMessageId, @NotNull ProfileId profileId) throws ValidationException {
        ChatMessage chatMessage;
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        UserMessage chatMessage2 = this.validatedMessageForDelete(chatMessageId, profileId);
        Intrinsics.checkNotNull((Object)chatMessage2);
        Object object = this.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)((ChatMessage)UserMessage.Companion.toDeletedMessage(chatMessage2)), null, null, (int)3, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        ChatMessage savedChatMessage = chatMessage = DbChatMessage.Companion.toChatMessage((DbChatMessage)object);
        boolean bl = false;
        Set set = SetsKt.setOf((Object)savedChatMessage.getChatId().getValue());
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        this.chatRepository.updateSyncDateByChatIds(set, instant);
        this.transactionUtils.afterCommit(() -> ChatMessageService.delete$lambda$7$lambda$5(this, savedChatMessage));
        if (!((Collection)chatMessage2.getAttachments()).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = chatMessage2.getAttachments();
            DriveService driveService = this.driveService;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChatMessageAttachment chatMessageAttachment = (ChatMessageAttachment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getDocumentId());
            }
            driveService.deleteFiles((List)destination$iv$iv, chatMessage2.getAuthor());
        }
        if (!((Collection)chatMessage2.getPersonMentions()).isEmpty()) {
            this.personMentionRepository.deleteByChatMessageId(chatMessageId.getValue());
        }
        this.deleteReactions(chatMessageId);
        return chatMessage;
    }

    @Transactional
    @NotNull
    public Optional<ChatMessage> findById(@NotNull ChatMessageId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Optional<ChatMessage> optional = this.chatMessageRepository.findById((Object)id.getValue()).map(arg_0 -> ChatMessageService.findById$lambda$9(ChatMessageService::findById$lambda$8, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @Transactional
    @NotNull
    public ChatMessage getById(@NotNull ChatMessageId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object t = this.findById(id).orElseThrow(() -> ChatMessageService.getById$lambda$10(id));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (ChatMessage)t;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ChatMessageId, ChatMessage> findByIds(@NotNull Set<ChatMessageId> ids) {
        void $this$associateTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable iterable = ids;
        ChatMessageRepository chatMessageRepository = this.chatMessageRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (ChatMessageId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$findByIds$stub_for_inlining = false;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        List list = chatMessageRepository.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            DbChatMessage dbChatMessage = (DbChatMessage)element$iv$iv;
            boolean bl = false;
            ChatMessageId chatMessageId = new ChatMessageId(dbChatMessage.getId());
            Intrinsics.checkNotNull((Object)dbChatMessage);
            Pair pair = TuplesKt.to((Object)chatMessageId, (Object)DbChatMessage.Companion.toChatMessage(dbChatMessage));
            object.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Transactional
    @NotNull
    public Stream<Pair<ChatId, ChatMessageId>> streamAllUserMessageIds() {
        Stream<Pair<ChatId, ChatMessageId>> stream = this.chatMessageRepository.streamAllUserMessageIds().map(arg_0 -> ChatMessageService.streamAllUserMessageIds$lambda$13(ChatMessageService::streamAllUserMessageIds$lambda$12, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
        return stream;
    }

    @Transactional
    @NotNull
    public Page<ChatMessage> getMessages(@NotNull ChatId chatId, int limit, @NotNull LoadDirection loadDirection, @Nullable AttachmentFilter attachmentFilter) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        return ChatMessageService.getMessagesWithSpecification$default((ChatMessageService)this, (LoadDirection)loadDirection, (int)limit, (ChatId)chatId, (AttachmentFilter)attachmentFilter, null, (int)16, null);
    }

    public static /* synthetic */ Page getMessages$default(ChatMessageService chatMessageService, ChatId chatId, int n, LoadDirection loadDirection, AttachmentFilter attachmentFilter, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 4) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 8) != 0) {
            attachmentFilter = null;
        }
        return chatMessageService.getMessages(chatId, n, loadDirection, attachmentFilter);
    }

    @Transactional
    @NotNull
    public Page<ChatMessage> getMessagesStartingAtTimestamp(@NotNull ChatId chatId, int limit, @NotNull LoadDirection loadDirection, @NotNull Instant offsetTimestamp, @Nullable AttachmentFilter attachmentFilter, boolean includeOffsetMessage) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        Intrinsics.checkNotNullParameter((Object)offsetTimestamp, (String)"offsetTimestamp");
        Specification offsetTimestampSpec = loadDirection == LoadDirection.OLDER ? (includeOffsetMessage ? ChatMessageSpecifications.INSTANCE.createdBeforeOrAt(offsetTimestamp) : ChatMessageSpecifications.INSTANCE.createdBefore(offsetTimestamp)) : (includeOffsetMessage ? ChatMessageSpecifications.INSTANCE.createdAfterOrAt(offsetTimestamp) : ChatMessageSpecifications.INSTANCE.createdAfter(offsetTimestamp));
        return this.getMessagesWithSpecification(loadDirection, limit, chatId, attachmentFilter, offsetTimestampSpec);
    }

    public static /* synthetic */ Page getMessagesStartingAtTimestamp$default(ChatMessageService chatMessageService, ChatId chatId, int n, LoadDirection loadDirection, Instant instant, AttachmentFilter attachmentFilter, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessagesStartingAtTimestamp");
        }
        if ((n2 & 4) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 0x10) != 0) {
            attachmentFilter = null;
        }
        return chatMessageService.getMessagesStartingAtTimestamp(chatId, n, loadDirection, instant, attachmentFilter, bl);
    }

    private Page<ChatMessage> getMessagesWithSpecification(LoadDirection loadDirection, int limit, ChatId chatId, AttachmentFilter attachmentFilter, Specification<DbChatMessage> additionalSpecification) {
        Pageable pageable;
        if (loadDirection == LoadDirection.OLDER) {
            var7_6 = new String[]{"createdAt"};
            pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortDesc((String[])var7_6));
        } else {
            var7_6 = new String[]{"createdAt"};
            pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortAsc((String[])var7_6));
        }
        Pageable pageable2 = pageable;
        Specification specification = ChatMessageSpecifications.INSTANCE.withChatId(chatId.getValue()).and(additionalSpecification).and(ChatMessageSpecifications.INSTANCE.withAttachments(attachmentFilter));
        Page page = this.chatMessageRepository.findAll(specification, pageable2).map(arg_0 -> ChatMessageService.getMessagesWithSpecification$lambda$15(ChatMessageService::getMessagesWithSpecification$lambda$14, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"map(...)");
        return page;
    }

    static /* synthetic */ Page getMessagesWithSpecification$default(ChatMessageService chatMessageService, LoadDirection loadDirection, int n, ChatId chatId, AttachmentFilter attachmentFilter, Specification specification, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessagesWithSpecification");
        }
        if ((n2 & 0x10) != 0) {
            specification = null;
        }
        return chatMessageService.getMessagesWithSpecification(loadDirection, n, chatId, attachmentFilter, specification);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatMessage> getRecentMessages(@NotNull Collection<ChatId> chatIds, @Nullable Instant updatedSince, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        if (!(chatIds.size() <= 1000)) {
            boolean $i$a$-require-ChatMessageService$getRecentMessages$22 = false;
            String $i$a$-require-ChatMessageService$getRecentMessages$22 = "Got " + chatIds.size() + " chat IDs, but only 1000 are allowed in a WHERE-IN-clause";
            throw new IllegalArgumentException($i$a$-require-ChatMessageService$getRecentMessages$22.toString());
        }
        Iterable $i$a$-require-ChatMessageService$getRecentMessages$22 = chatIds;
        ChatMessageSpecifications chatMessageSpecifications = ChatMessageSpecifications.INSTANCE;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$getRecentMessages$stub_for_inlining$17 = false;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Specification specification = chatMessageSpecifications.withChatIdIn((Collection)((List)destination$iv$iv)).and(ChatMessageSpecifications.INSTANCE.updatedAfter(updatedSince));
        String[] stringArray = new String[]{"createdAt"};
        Pageable pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortDesc((String[])stringArray));
        Page page = this.chatMessageRepository.findAll(specification, pageable).map(arg_0 -> ChatMessageService.getRecentMessages$lambda$19(ChatMessageService::getRecentMessages$lambda$18, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"map(...)");
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> findUpdatedAuthorsAndReactors(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant since) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapToSet$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable<? extends ParticipantId> $this$map$iv = participantIds;
        boolean $i$f$map22 = false;
        Iterable<? extends ParticipantId> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$f$findUpdatedAuthorsAndReactors$stub_for_inlining$20 = false;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        List canonicalParticipantIds = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.chatMessageRepository.findUpdatedAuthorsByParticipantIds((Iterable)canonicalParticipantIds, since);
        boolean $i$f$mapToSet22 = false;
        destination$iv$iv = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String $i$f$findUpdatedAuthorsAndReactors$stub_for_inlining$20 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(ProfileId.Companion.fromCanonicalId((String)it));
        }
        Set updatedAuthors = (Set)destination$iv$iv2;
        Iterable $i$f$mapToSet22 = this.chatMessageRepository.findUpdatedReactorsByParticipantIds((Iterable)canonicalParticipantIds, since);
        boolean $i$f$mapToSet = false;
        destination$iv$iv2 = $this$mapToSet$iv;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            collection.add(ProfileId.Companion.fromCanonicalId((String)it));
        }
        Set updatedReactors = (Set)destination$iv$iv3;
        return CollectionsKt.union((Iterable)updatedAuthors, (Iterable)updatedReactors);
    }

    @Transactional
    @NotNull
    public ChatMessageReaction react(@NotNull ChatMessageId chatMessageId, @NotNull ChatId chatId, @NotNull ProfileId profileId, @NotNull String reaction) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        UserMessage message = Companion.access$validatedForReaction((Companion)Companion, (ChatMessage)this.getById(chatMessageId), (ChatId)chatId);
        DbChatMessageReaction dbReaction = (DbChatMessageReaction)this.chatMessageReactionRepository.save((Object)new DbChatMessageReaction(chatMessageId.getValue(), profileId.toCanonicalId(), reaction));
        this.removedMessageReactionForSyncRepository.deleteById((Object)new DbReactionId(chatMessageId.getValue(), profileId.toCanonicalId()));
        this.transactionUtils.afterCommit(() -> ChatMessageService.react$lambda$23(this, message, chatId));
        Intrinsics.checkNotNull((Object)dbReaction);
        return DbChatMessageReaction.Companion.toChatMessageReaction(dbReaction);
    }

    @Transactional
    public void deleteReaction(@NotNull ChatMessageId chatMessageId, @NotNull ChatId chatId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        UserMessage message = Companion.access$validatedForReaction((Companion)Companion, (ChatMessage)this.getById(chatMessageId), (ChatId)chatId);
        this.chatMessageReactionRepository.deleteById((Object)new DbReactionId(chatMessageId.getValue(), profileId.toCanonicalId()));
        this.removedMessageReactionForSyncRepository.save((Object)new DbRemovedMessageReactionForSync(chatMessageId.getValue(), profileId.toCanonicalId()));
        this.transactionUtils.afterCommit(() -> ChatMessageService.deleteReaction$lambda$24(this, message, chatId));
    }

    @Transactional
    public void deleteReactions(@NotNull ChatMessageId chatMessageId) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        List reactionProfileIds = this.chatMessageReactionRepository.findProfileIdsByMessageId(chatMessageId.getValue());
        this.chatMessageReactionRepository.deleteByMessageIds((Iterable)CollectionsKt.listOf((Object)chatMessageId.getValue()));
        for (DbProfileIdProjection profileIdProjection : reactionProfileIds) {
            this.removedMessageReactionForSyncRepository.save((Object)new DbRemovedMessageReactionForSync(chatMessageId.getValue(), profileIdProjection.getProfileId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatMessageId, List<ChatMessageReaction>> getReactions(@NotNull Iterable<ChatMessageId> messageIds) {
        ChatMessageId it;
        boolean bl;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        Iterable<ChatMessageId> iterable = messageIds;
        Object object2 = this.chatMessageReactionRepository;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            ChatMessageId chatMessageId = (ChatMessageId)t;
            object = destination$iv$iv;
            bl = false;
            object.add(it.getValue());
        }
        Map reactions2 = object2.findByMessageIds((Iterable)((List)destination$iv$iv));
        Iterable<ChatMessageId> $this$associateWith$iv = messageIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, (int)10)), (int)16));
        Iterable<ChatMessageId> $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object object3 : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void messageId;
            it = (ChatMessageId)object3;
            object = object3;
            object2 = result$iv;
            bl = false;
            Iterable $this$map$iv2 = reactions2.getOrDefault(messageId.getValue(), CollectionsKt.emptyList());
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                DbChatMessageReaction dbChatMessageReaction = (DbChatMessageReaction)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(DbChatMessageReaction.Companion.toChatMessageReaction((DbChatMessageReaction)it2));
            }
            List list = (List)destination$iv$iv2;
            object2.put(object, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChatMessageReaction> getUpdatedReactions(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant updatedSince) {
        DbChatMessageReaction p0;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatMessageReactionRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$getUpdatedReactions$stub_for_inlining$28 = false;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        $this$map$iv = object.findByUpdatedAtGreaterThanAndParticipantIds((Iterable)((List)destination$iv$iv), updatedSince);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatMessageReaction)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbChatMessageReaction.Companion.toChatMessageReaction((DbChatMessageReaction)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ReactionId> getDeletedReactionIds(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant updatedSince) {
        DbReactionId p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.removedMessageReactionForSyncRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$getDeletedReactionIds$stub_for_inlining$30 = false;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findByUpdatedAtGreaterThanAndParticipantIds((Iterable)((List)destination$iv$iv), updatedSince);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbReactionId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ReactionId.Companion.toReactionId((DbReactionId)it));
        }
        return (Set)destination$iv$iv;
    }

    @EventListener
    public void onChatInfoChangedEvent(@NotNull ChatUpdatedEvent chatUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatUpdatedEvent, (String)"chatUpdatedEvent");
        ChatUpdatedEvent $this$onChatInfoChangedEvent_u24lambda_u2432 = chatUpdatedEvent;
        boolean bl = false;
        if (!($this$onChatInfoChangedEvent_u24lambda_u2432.getNewChat() instanceof MultiUserChat) || !($this$onChatInfoChangedEvent_u24lambda_u2432.getOldChat() instanceof MultiUserChat)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getOldChat()).getTitle(), (Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getNewChat()).getTitle())) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = ((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getOldChat()).getId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.ChatTitleChanged(((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getOldChat()).getTitle(), ((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getNewChat()).getTitle());
            ProfileId profileId = $this$onChatInfoChangedEvent_u24lambda_u2432.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (boolean)false, (int)6, null);
        }
        if (!Intrinsics.areEqual((Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getOldChat()).getIconId(), (Object)((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getNewChat()).getIconId())) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = ((MultiUserChat)$this$onChatInfoChangedEvent_u24lambda_u2432.getOldChat()).getId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)ChatMessagePayload.ChatIconChanged.INSTANCE;
            ProfileId profileId = $this$onChatInfoChangedEvent_u24lambda_u2432.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant3 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant3)), null, (boolean)false, (int)6, null);
        }
    }

    @EventListener
    public void onChatCreatedEvent(@NotNull ChatCreatedEvent chatCreatedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatCreatedEvent, (String)"chatCreatedEvent");
        ChatCreatedEvent $this$onChatCreatedEvent_u24lambda_u2433 = chatCreatedEvent;
        boolean bl = false;
        if ($this$onChatCreatedEvent_u24lambda_u2433.getChat() instanceof MultiUserChat) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$onChatCreatedEvent_u24lambda_u2433.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.ChatCreated(((MultiUserChat)$this$onChatCreatedEvent_u24lambda_u2433.getChat()).getTitle());
            ProfileId profileId = $this$onChatCreatedEvent_u24lambda_u2433.getCreator();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (boolean)false, (int)6, null);
        }
    }

    @EventListener
    public void onChatParticipantsChangedEvent(@NotNull ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatParticipantsChangedEvent, (String)"chatParticipantsChangedEvent");
        ChatParticipantsChangedEvent $this$onChatParticipantsChangedEvent_u24lambda_u2434 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$onChatParticipantsChangedEvent_u24lambda_u2434.getWithSystemMessage()) {
            if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u2434.getParticipantsRemoved()).isEmpty()) {
                this.sendSystemMessageForRemovedParticipants(chatParticipantsChangedEvent);
            }
            if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u2434.getParticipantsAdded()).isEmpty()) {
                this.sendSystemMessageForAddedParticipants(chatParticipantsChangedEvent);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendSystemMessageForRemovedParticipants(ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        ChatParticipantsChangedEvent $this$sendSystemMessageForRemovedParticipants_u24lambda_u2435 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$sendSystemMessageForRemovedParticipants_u24lambda_u2435.getUpdater() == null) {
            this.handleDeletedParticipants($this$sendSystemMessageForRemovedParticipants_u24lambda_u2435);
        } else {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstanceToSet$iv = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2435.getParticipantsRemoved();
            boolean $i$f$filterIsInstanceToSet = false;
            Iterable iterable = $this$filterIsInstanceToSet$iv;
            Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProfileId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set removedProfileIdsStayingInUserGroups = SetsKt.minus((Set)((Set)destination$iv$iv), (Iterable)$this$sendSystemMessageForRemovedParticipants_u24lambda_u2435.getEffectiveProfileIdsRemoved());
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2435.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.RemovedFromChat($this$sendSystemMessageForRemovedParticipants_u24lambda_u2435.getParticipantsRemoved(), removedProfileIdsStayingInUserGroups);
            ProfileId profileId = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2435.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (boolean)false, (int)6, null);
        }
    }

    private void sendSystemMessageForAddedParticipants(ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        ChatParticipantsChangedEvent $this$sendSystemMessageForAddedParticipants_u24lambda_u2436 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$sendSystemMessageForAddedParticipants_u24lambda_u2436.getUpdater() != null && !$this$sendSystemMessageForAddedParticipants_u24lambda_u2436.isNewChat()) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$sendSystemMessageForAddedParticipants_u24lambda_u2436.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.AddedToChat($this$sendSystemMessageForAddedParticipants_u24lambda_u2436.getParticipantsAdded());
            ProfileId profileId = $this$sendSystemMessageForAddedParticipants_u24lambda_u2436.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (boolean)false, (int)6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ChatMessage createWithoutAttachments(ChatMessage chatMessage) throws ValidationException {
        List list;
        if (chatMessage instanceof UserMessage) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((UserMessage)chatMessage).getPersonMentions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PersonMention personMention = (PersonMention)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PersonMention.Companion.toDbPersonMention((PersonMention)it, chatMessage));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List dbPersonMentions = list;
        Object object = this.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)ChatMessageService.validatedForCreate$default((ChatMessageService)this, (ChatMessage)chatMessage, null, (int)1, null), null, (List)dbPersonMentions, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return DbChatMessage.Companion.toChatMessage((DbChatMessage)object);
    }

    private ChatMessage createWithAttachments(UserMessage chatMessage, List<? extends MultipartFile> files) throws ValidationException {
        if (chatMessage.getMessage() != null) {
            throw new ValidationException("Message text must be null", null, 2, null);
        }
        if (files.size() > 1) {
            throw new ValidationException("Only one attachment may be uploaded at a time", null, 2, null);
        }
        return (ChatMessage)this.driveService.uploadFiles(files, chatMessage.getChatId().toPermissionItemId(), chatMessage.getAuthor(), arg_0 -> ChatMessageService.createWithAttachments$lambda$39(this, chatMessage, arg_0));
    }

    private void handleDeletedParticipants(ChatParticipantsChangedEvent $this$handleDeletedParticipants) {
        if ($this$handleDeletedParticipants.getParticipantsRemoved().size() == 1) {
            ParticipantId removedParticipant = (ParticipantId)CollectionsKt.first((Iterable)$this$handleDeletedParticipants.getParticipantsRemoved());
            if (removedParticipant instanceof ProfileId) {
                ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
                ChatId chatId = $this$handleDeletedParticipants.getChatId();
                ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.PersonDeleted((ProfileId)removedParticipant);
                ProfileId profileId = ProfileId.Companion.getDELETED_USER();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
                v6 = ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (boolean)false, (int)6, null);
            } else if (removedParticipant instanceof UserGroupId) {
                ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
                ChatId chatId = $this$handleDeletedParticipants.getChatId();
                ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.UserGroupDeleted((UserGroupId)removedParticipant);
                ProfileId profileId = ProfileId.Companion.getDELETED_USER();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                Instant instant3 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now(...)");
                v6 = ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant3)), null, (boolean)false, (int)6, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private <T extends ChatMessage> T validatedForCreate(T $this$validatedForCreate, List<DbChatMessageAttachment> attachments) throws ValidationException {
        T t;
        T $this$validatedForCreate_u24lambda_u2440 = t = $this$validatedForCreate;
        boolean bl = false;
        if ($this$validatedForCreate_u24lambda_u2440 instanceof UserMessage) {
            this.validate((UserMessage)$this$validatedForCreate_u24lambda_u2440, attachments);
        }
        if (this.chatMessageRepository.existsById((Object)$this$validatedForCreate_u24lambda_u2440.getId().getValue())) {
            throw new ChatMessageAlreadyExistsException($this$validatedForCreate_u24lambda_u2440.getId(), "Chat message with id " + $this$validatedForCreate_u24lambda_u2440.getId() + " already exists.");
        }
        return t;
    }

    static /* synthetic */ ChatMessage validatedForCreate$default(ChatMessageService chatMessageService, ChatMessage chatMessage, List list, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validatedForCreate");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return chatMessageService.validatedForCreate(chatMessage, list);
    }

    private UserMessage validatedForEdit(UserMessage $this$validatedForEdit, ProfileId editor2) throws ValidationException {
        UserMessage userMessage;
        UserMessage $this$validatedForEdit_u24lambda_u2441 = userMessage = $this$validatedForEdit;
        boolean bl = false;
        if (!((Collection)$this$validatedForEdit_u24lambda_u2441.getAttachments()).isEmpty()) {
            throw new ValidationException("Cannot edit message " + $this$validatedForEdit_u24lambda_u2441.getId() + " - has " + $this$validatedForEdit_u24lambda_u2441.getAttachments().size() + " attachments", null, 2, null);
        }
        if (!Intrinsics.areEqual((Object)$this$validatedForEdit_u24lambda_u2441.getAuthor(), (Object)editor2)) {
            throw new NotAllowedException(editor2 + " is not the original author of the message " + $this$validatedForEdit_u24lambda_u2441.getId());
        }
        if ($this$validatedForEdit_u24lambda_u2441.getCreatedAt().plusSeconds(300L).isBefore($this$validatedForEdit_u24lambda_u2441.getEditedAt())) {
            throw new ValidationException("Message " + $this$validatedForEdit_u24lambda_u2441.getId() + " is older than the maximum edit timeframe of 300 seconds", "EDIT_MESSAGE_TIMEFRAME_ELAPSED");
        }
        this.validate($this$validatedForEdit_u24lambda_u2441, CollectionsKt.emptyList());
        return userMessage;
    }

    public void validate(@NotNull UserMessage $this$validate, @NotNull List<DbChatMessageAttachment> attachments) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        CharSequence charSequence = $this$validate.getMessage();
        if ((charSequence == null || charSequence.length() == 0) && attachments.isEmpty()) {
            throw new ValidationException("User message with neither text nor attachments is not allowed.", null, 2, null);
        }
        if ($this$validate.getMessage() != null && StringsKt.replace$default((String)$this$validate.getMessage(), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null).length() > 10000) {
            throw new ValidationException("User message to large. Only 10000 characters allowed.", "TEXT_MESSAGE_TOO_LARGE");
        }
        this.checkNoDuplicateMentions($this$validate);
        this.validateCitation($this$validate);
    }

    public void validateCitation(@NotNull UserMessage $this$validateCitation) {
        Intrinsics.checkNotNullParameter((Object)$this$validateCitation, (String)"<this>");
        if ($this$validateCitation.getCitedMessageId() == null) {
            return;
        }
        DbChatMessage citedMessage = (DbChatMessage)this.chatMessageRepository.findById((Object)$this$validateCitation.getCitedMessageId().getValue()).orElseThrow(ChatMessageService::validateCitation$lambda$42);
        if (!Intrinsics.areEqual((Object)citedMessage.getChatId(), (Object)$this$validateCitation.getChatId().getValue())) {
            throw new CrossChatCitationException("Message from a different chat cannot be cited.");
        }
        Intrinsics.checkNotNull((Object)citedMessage);
        if (!(DbChatMessage.Companion.toChatMessage(citedMessage) instanceof UserMessage)) {
            throw new CitationOfNonUserMessageException("Can only cite user messages.");
        }
    }

    public void checkNoDuplicateMentions(@NotNull UserMessage $this$checkNoDuplicateMentions) {
        Intrinsics.checkNotNullParameter((Object)$this$checkNoDuplicateMentions, (String)"<this>");
        Set profileIdSet = new LinkedHashSet();
        for (PersonMention mention : $this$checkNoDuplicateMentions.getPersonMentions()) {
            if (profileIdSet.contains(mention.getProfileId())) {
                throw new ValidationException("Mention Metadata should contain each profile only once. " + mention.getProfileId() + " was present multiple times.", null, 2, null);
            }
            profileIdSet.add(mention.getProfileId());
        }
    }

    private UserMessage validatedMessageForDelete(ChatMessageId chatMessageId, ProfileId profileId) throws ValidationException {
        Optional $this$filterIsInstance$iv = this.findById(chatMessageId);
        boolean $i$f$filterIsInstance = false;
        Function1 function1 = (Function1)validatedMessageForDelete$$inlined$filterIsInstance$1.INSTANCE;
        Optional optional = $this$filterIsInstance$iv.map((Function)new OptionalUtilsKt.sam.i.java_util_function_Function.0(function1));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return (UserMessage)optional.filter(arg_0 -> ChatMessageService.validatedMessageForDelete$lambda$44(arg_0 -> ChatMessageService.validatedMessageForDelete$lambda$43(profileId, arg_0), arg_0)).orElseThrow(() -> ChatMessageService.validatedMessageForDelete$lambda$45(chatMessageId));
    }

    private static final Unit create$lambda$1$lambda$0(ChatMessageService this$0, ChatMessage $updatedChatMessage) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatMessageCreatedEvent((Object)this$0, $updatedChatMessage));
        return Unit.INSTANCE;
    }

    private static final Unit edit$lambda$4(ChatMessageService this$0, ChatMessage $updatedChatMessage) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserMessageUpdatedEvent((Object)this$0, (UserMessage)$updatedChatMessage, ((UserMessage)$updatedChatMessage).getChatId()));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$7$lambda$5(ChatMessageService this$0, ChatMessage $savedChatMessage) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatMessageDeletedEvent((Object)this$0, this$0.chatService.getById($savedChatMessage.getChatId()), $savedChatMessage.getId()));
        return Unit.INSTANCE;
    }

    private static final ChatMessage findById$lambda$8(DbChatMessage it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChatMessage.Companion.toChatMessage(it);
    }

    private static final ChatMessage findById$lambda$9(Function1 $tmp0, Object p0) {
        return (ChatMessage)$tmp0.invoke(p0);
    }

    private static final NotFoundException getById$lambda$10(ChatMessageId $id) {
        return new NotFoundException("Chat message with id " + $id + " does not exist.");
    }

    private static final Pair streamAllUserMessageIds$lambda$12(Pair it) {
        return new Pair((Object)new ChatId((UUID)it.getFirst()), (Object)new ChatMessageId((UUID)it.getSecond()));
    }

    private static final Pair streamAllUserMessageIds$lambda$13(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final ChatMessage getMessagesWithSpecification$lambda$14(DbChatMessage it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChatMessage.Companion.toChatMessage(it);
    }

    private static final ChatMessage getMessagesWithSpecification$lambda$15(Function1 $tmp0, Object p0) {
        return (ChatMessage)$tmp0.invoke(p0);
    }

    private static final ChatMessage getRecentMessages$lambda$18(DbChatMessage it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChatMessage.Companion.toChatMessage(it);
    }

    private static final ChatMessage getRecentMessages$lambda$19(Function1 $tmp0, Object p0) {
        return (ChatMessage)$tmp0.invoke(p0);
    }

    private static final Unit react$lambda$23(ChatMessageService this$0, UserMessage $message, ChatId $chatId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserMessageUpdatedEvent((Object)this$0, $message, $chatId));
        return Unit.INSTANCE;
    }

    private static final Unit deleteReaction$lambda$24(ChatMessageService this$0, UserMessage $message, ChatId $chatId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserMessageUpdatedEvent((Object)this$0, $message, $chatId));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ChatMessage createWithAttachments$lambda$39(ChatMessageService this$0, UserMessage $chatMessage, List driveAttachments) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)driveAttachments, (String)"driveAttachments");
        Iterable $this$map$iv = driveAttachments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DriveAttachment driveAttachment = (DriveAttachment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DriveAttachment.Companion.toDbChatMessageAttachment((DriveAttachment)it, (ChatMessage)$chatMessage));
        }
        List attachments = (List)destination$iv$iv;
        Object object = this$0.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)this$0.validatedForCreate((ChatMessage)$chatMessage, attachments), (List)attachments, null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return DbChatMessage.Companion.toChatMessage((DbChatMessage)object);
    }

    private static final CitationDoesNotExistException validateCitation$lambda$42() {
        return new CitationDoesNotExistException("Non-existent message cannot be cited.");
    }

    private static final boolean validatedMessageForDelete$lambda$43(ProfileId $profileId, UserMessage it) {
        return Intrinsics.areEqual((Object)it.getAuthor(), (Object)$profileId);
    }

    private static final boolean validatedMessageForDelete$lambda$44(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ValidationException validatedMessageForDelete$lambda$45(ChatMessageId $chatMessageId) {
        return new ValidationException("ChatMessage with id " + $chatMessageId + " could not be deleted", null, 2, null);
    }

    public static final /* synthetic */ Set access$getIMAGE_FORMATS$cp() {
        return IMAGE_FORMATS;
    }

    static {
        Object[] objectArray = new String[]{"image/bmp", "image/gif", "image/jpeg", "image/png", "image/x-png", "image/tiff", "image/webp", "image/svg+xml"};
        IMAGE_FORMATS = SetsKt.setOf((Object[])objectArray);
    }
}

