/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import de.justsoftware.authorization.totp.TOTPAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/authorization/totp/TOTPAuthenticationSuccessHandler;", "Lorg/springframework/security/web/authentication/AuthenticationSuccessHandler;", "systemDomainPrefix", "", "<init>", "(Ljava/lang/String;)V", "onAuthenticationSuccess", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "authentication", "Lorg/springframework/security/core/Authentication;", "just-authorization-server"})
public class TOTPAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @NotNull
    private final String systemDomainPrefix;

    public TOTPAuthenticationSuccessHandler(@Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        this.systemDomainPrefix = systemDomainPrefix;
    }

    public void onAuthenticationSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        if (authentication instanceof TOTPAuthentication && !((TOTPAuthentication)authentication).getAuthenticated()) {
            SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler("/totp/login");
            successHandler.setAlwaysUseDefaultTargetUrl(true);
            successHandler.onAuthenticationSuccess(request, response, authentication);
        } else {
            SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
            handler.setDefaultTargetUrl(this.systemDomainPrefix);
            handler.onAuthenticationSuccess(request, response, authentication);
        }
    }
}

