/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.client.OauthTokenService;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/authorization/oauth2/TokenCleanupScheduler;", "", "oauthTokenService", "Lde/justsoftware/authorization/oauth2/client/OauthTokenService;", "oauthTokensExpiredSince", "Ljava/time/Duration;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "rememberMeTokenExpiredSince", "<init>", "(Lde/justsoftware/authorization/oauth2/client/OauthTokenService;Ljava/time/Duration;Lde/justsoftware/authorization/token/RememberMeTokenRepository;Ljava/time/Duration;)V", "deleteExpiredOauthTokens", "", "deleteExpiredRememberMeTokens", "just-authorization-server"})
public final class TokenCleanupScheduler {
    @NotNull
    private final OauthTokenService oauthTokenService;
    @NotNull
    private final Duration oauthTokensExpiredSince;
    @NotNull
    private final RememberMeTokenRepository rememberMeTokenRepository;
    @NotNull
    private final Duration rememberMeTokenExpiredSince;

    public TokenCleanupScheduler(@NotNull OauthTokenService oauthTokenService, @NotNull Duration oauthTokensExpiredSince, @NotNull RememberMeTokenRepository rememberMeTokenRepository, @NotNull Duration rememberMeTokenExpiredSince) {
        Intrinsics.checkNotNullParameter((Object)oauthTokenService, (String)"oauthTokenService");
        Intrinsics.checkNotNullParameter((Object)oauthTokensExpiredSince, (String)"oauthTokensExpiredSince");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenExpiredSince, (String)"rememberMeTokenExpiredSince");
        this.oauthTokenService = oauthTokenService;
        this.oauthTokensExpiredSince = oauthTokensExpiredSince;
        this.rememberMeTokenRepository = rememberMeTokenRepository;
        this.rememberMeTokenExpiredSince = rememberMeTokenExpiredSince;
    }

    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.DAYS)
    public final void deleteExpiredOauthTokens() {
        this.oauthTokenService.deleteExpiredTokens(this.oauthTokensExpiredSince);
    }

    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.DAYS)
    public final void deleteExpiredRememberMeTokens() {
        this.rememberMeTokenRepository.deleteExpiredTokens(this.rememberMeTokenExpiredSince);
    }
}

