/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.web.model.WebAppConfig;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.config.ServerConfigService;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.domain.tenant.TenantService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/application/web/ConfigApplicationService;", "", "serverConfigService", "Lde/justsoftware/admin/config/ServerConfigService;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "<init>", "(Lde/justsoftware/admin/config/ServerConfigService;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;Lde/justsoftware/admin/domain/tenant/TenantService;)V", "getConfig", "Lde/justsoftware/admin/application/web/model/WebAppConfig;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "admin-service"})
public class ConfigApplicationService {
    @NotNull
    private final ServerConfigService serverConfigService;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final TenantService tenantService;

    public ConfigApplicationService(@NotNull ServerConfigService serverConfigService, @NotNull SuperopertyConnector superopertyConnector, @NotNull TenantService tenantService) {
        Intrinsics.checkNotNullParameter((Object)serverConfigService, (String)"serverConfigService");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        this.serverConfigService = serverConfigService;
        this.superopertyConnector = superopertyConnector;
        this.tenantService = tenantService;
    }

    @NotNull
    public WebAppConfig getConfig(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        boolean mayCreateTenant = authContext.isSuperAdmin() && (this.serverConfigService.isMultiTenantCreationEnabled() || this.tenantService.getTenants().isEmpty());
        return new WebAppConfig(null, this.serverConfigService.isEnterprise(), this.serverConfigService.isEnterprise(), this.serverConfigService.isEnterprise(), this.serverConfigService.isEnterprise() && this.superopertyConnector.isImportPersonsEnabled(), authContext.isSuperAdmin(), authContext.isTenantManager() || authContext.isSuperAdmin(), authContext.isTenantManager() || authContext.isSuperAdmin(), authContext.isSuperAdmin(), mayCreateTenant, this.superopertyConnector.isIdpConfigurationEnabled(), this.superopertyConnector.isScimEnabled(), this.superopertyConnector.isPublicApiMenuEnabled(), 1, null);
    }
}

