/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.persistence.model.DbNotification;
import de.justsoftware.notificationservice.serializer.InstantSerializer;
import java.time.Instant;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Notification {
    private final UUID _id;
    private final UUID _tenantId;
    private final String _appId;
    private final String _title;
    private final String _text;
    private final String _secondaryText;
    private final Instant _timestamp;
    private final String _targetId;
    private final String _payload;
    private final NotificationType _type;
    private final boolean _marked;

    @JsonCreator
    public Notification(@JsonProperty(value="id") UUID id, @JsonProperty(value="tenantId") UUID tenantId, @JsonProperty(value="appId") String appId, @JsonProperty(value="title") String title, @JsonProperty(value="text") String text, @Nullable @JsonProperty(value="secondaryText") String secondaryText, @JsonProperty(value="timestamp") @JsonSerialize(using=InstantSerializer.class) Instant timestamp, @Nullable @JsonProperty(value="targetId") String targetId, @Nullable @JsonProperty(value="payload") String payload, @JsonProperty(value="type") NotificationType type, @JsonProperty(value="marked") boolean marked) {
        this._id = id;
        this._tenantId = tenantId;
        this._appId = appId;
        this._title = title;
        this._text = text;
        this._secondaryText = secondaryText;
        this._timestamp = timestamp;
        this._targetId = targetId;
        this._payload = payload;
        this._type = type;
        this._marked = marked;
    }

    @Nonnull
    public UUID getId() {
        return this._id;
    }

    @Nonnull
    public UUID getTenantId() {
        return this._tenantId;
    }

    @Nonnull
    public String getAppId() {
        return this._appId;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getText() {
        return this._text;
    }

    @CheckForNull
    public String getSecondaryText() {
        return this._secondaryText;
    }

    @Nonnull
    @JsonSerialize(using=InstantSerializer.class)
    public Instant getTimestamp() {
        return this._timestamp;
    }

    @CheckForNull
    public String getTargetId() {
        return this._targetId;
    }

    @CheckForNull
    public String getPayload() {
        return this._payload;
    }

    @Nonnull
    public NotificationType getType() {
        return this._type;
    }

    public boolean isMarked() {
        return this._marked;
    }

    @Nonnull
    public static Notification fromDBNotification(Locale locale, DbNotification dbNotification, boolean marked) {
        UUID id = dbNotification.getId();
        if (id == null) {
            throw new IllegalArgumentException("Unpersisted notification can not be converted into a business notification model");
        }
        String title = (String)MoreObjects.firstNonNull((Object)((String)dbNotification.getLocalizedTitle().get(locale)), (Object)dbNotification.getDefaultTitle());
        String text = (String)MoreObjects.firstNonNull((Object)((String)dbNotification.getLocalizedText().get(locale)), (Object)dbNotification.getDefaultText());
        String localizedSecondaryText = (String)dbNotification.getLocalizedSecondaryText().get(locale);
        return new Notification(id, dbNotification.getTenantId(), dbNotification.getAppId(), title, text, localizedSecondaryText != null ? localizedSecondaryText : dbNotification.getDefaultSecondaryText(), dbNotification.getTimestamp(), dbNotification.getTargetId(), dbNotification.getPayload(), dbNotification.getType(), marked);
    }
}

