/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.util;

import de.justsoftware.notificationservice.mobile.model.MobilePushNotification;
import de.justsoftware.notificationservice.mobile.util.MobilePushEncryption;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.hpke.HPKE;
import org.bouncycastle.crypto.hpke.HPKEContextWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"mobilePushEncryption", "Lde/justsoftware/notificationservice/mobile/util/MobilePushEncryption;", "getMobilePushEncryption", "()Lde/justsoftware/notificationservice/mobile/util/MobilePushEncryption;", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "notification-service"})
public final class MobilePushEncryptionKt {
    @NotNull
    private static final MobilePushEncryption mobilePushEncryption = MobilePushEncryptionKt::mobilePushEncryption$lambda$0;
    private static final Logger LOG = LoggerFactory.getLogger((String)"de.justsoftware.notificationservice.mobile.util.MobilePushEncryption");

    @NotNull
    public static final MobilePushEncryption getMobilePushEncryption() {
        return mobilePushEncryption;
    }

    private static final MobilePushNotification.EncryptedContent mobilePushEncryption$lambda$0(String title, String body, String publicKey, ProfileId profileId) {
        MobilePushNotification.EncryptedContent encryptedContent;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        try {
            byte[] publicKeyRaw = Base64.decode((String)publicKey);
            X25519PublicKeyParameters publicKeyParam = new X25519PublicKeyParameters(publicKeyRaw);
            String string = profileId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] info = byArray;
            HPKE hpke = new HPKE(0, 32, 1, 3);
            HPKEContextWithEncapsulation context = hpke.setupBaseS((AsymmetricKeyParameter)publicKeyParam, info);
            byte[] byArray2 = new byte[]{};
            String string3 = title;
            byte[] byArray3 = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            byte[] titleEncrypted = context.seal(byArray2, byArray3);
            byte[] byArray4 = new byte[]{};
            String string4 = body;
            byte[] byArray5 = string4.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getBytes(...)");
            byte[] bodyEncrypted = context.seal(byArray4, byArray5);
            String string5 = Base64.toBase64String((byte[])titleEncrypted);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toBase64String(...)");
            String string6 = Base64.toBase64String((byte[])bodyEncrypted);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toBase64String(...)");
            String string7 = Base64.toBase64String((byte[])context.getEncapsulation());
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toBase64String(...)");
            encryptedContent = new MobilePushNotification.EncryptedContent(string5, string6, string7);
        }
        catch (RuntimeException e) {
            LOG.error("Error encrypting mobile push message", (Throwable)e);
            encryptedContent = null;
        }
        return encryptedContent;
    }
}

