/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.business.InternalChatService;
import de.justsoftware.notificationservice.mobile.model.MobilePlatform;
import de.justsoftware.notificationservice.mobile.model.MobilePushNotification;
import de.justsoftware.notificationservice.mobile.model.MobilePushToken;
import de.justsoftware.notificationservice.mobile.service.MobilePushNotificationSendService;
import de.justsoftware.notificationservice.mobile.service.MobilePushNotificationService;
import de.justsoftware.notificationservice.mobile.service.MobilePushTokenService;
import de.justsoftware.notificationservice.mobile.util.MobilePushEncryption;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.util.CollectionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 32\u00020\u0001:\u000223BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0012J\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001b0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0012J\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020$0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0012J@\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u001e2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001b0 2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020$0 H\u0012J\u0010\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001eH\u0012J\u0014\u0010+\u001a\u00020!*\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0012J\u0014\u0010.\u001a\u00020!*\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0012J\u0010\u0010/\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0012J\f\u00100\u001a\u000201*\u00020\u0016H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationService;", "", "mobilePushTokenService", "Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;", "internalChatService", "Lde/justsoftware/notificationservice/business/InternalChatService;", "deliveryStatusRepository", "Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "apnsPushSendService", "Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService;", "fcmPushSendService", "mobilePushEncryption", "Lde/justsoftware/notificationservice/mobile/util/MobilePushEncryption;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "resourceBundle", "Lorg/springframework/context/support/ResourceBundleMessageSource;", "<init>", "(Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;Lde/justsoftware/notificationservice/business/InternalChatService;Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService;Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService;Lde/justsoftware/notificationservice/mobile/util/MobilePushEncryption;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/context/support/ResourceBundleMessageSource;)V", "sendPushNotifications", "", "notification", "Lde/justsoftware/notificationclient/model/Notification;", "resolvedReceivers", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "sendLogoutPushNotifications", "", "pushTokens", "", "Lde/justsoftware/notificationservice/mobile/model/MobilePushToken;", "getUnreadSocialNotificationCount", "", "", "mobilePushTokens", "getIosUnreadChatMessageCounts", "", "standardMobilePushNotification", "Lde/justsoftware/notificationservice/mobile/model/MobilePushNotification;", "pushToken", "unreadSocialNotifications", "iosUnreadChatMessageCounts", "logoutMobilePushNotification", "title", "locale", "Ljava/util/Locale;", "text", "destination", "toPushDestination", "Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationService$NotificationPushDestination;", "NotificationPushDestination", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushNotificationService.kt\nde/justsoftware/notificationservice/mobile/service/MobilePushNotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 CollectionUtil.kt\nde/justsoftware/notificationservice/util/CollectionUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,192:1\n774#2:193\n865#2,2:194\n1563#2:196\n1634#2,3:197\n1491#2:200\n1516#2,3:201\n1519#2,3:211\n1563#2:214\n1634#2,3:215\n1491#2:218\n1516#2,3:219\n1519#2,3:229\n1634#2,3:233\n774#2:236\n865#2,2:237\n1634#2,3:240\n384#3,7:204\n384#3,7:222\n17#4:232\n17#4:239\n1#5:243\n8#6:244\n7#6,3:245\n*S KotlinDebug\n*F\n+ 1 MobilePushNotificationService.kt\nde/justsoftware/notificationservice/mobile/service/MobilePushNotificationService\n*L\n36#1:193\n36#1:194,2\n42#1:196\n42#1:197,3\n50#1:200\n50#1:201,3\n50#1:211,3\n90#1:214\n90#1:215,3\n91#1:218\n91#1:219,3\n91#1:229,3\n110#1:233,3\n122#1:236\n122#1:237,2\n123#1:240,3\n50#1:204,7\n91#1:222,7\n110#1:232\n123#1:239\n189#1:244\n189#1:245,3\n*E\n"})
public class MobilePushNotificationService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final InternalChatService internalChatService;
    @NotNull
    private final DeliveryStatusRepository deliveryStatusRepository;
    @NotNull
    private final MobilePushNotificationSendService apnsPushSendService;
    @NotNull
    private final MobilePushNotificationSendService fcmPushSendService;
    @NotNull
    private final MobilePushEncryption mobilePushEncryption;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ResourceBundleMessageSource resourceBundle;
    @NotNull
    private static final Logger LOG;

    public MobilePushNotificationService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull InternalChatService internalChatService, @NotNull DeliveryStatusRepository deliveryStatusRepository, @NotNull MobilePushNotificationSendService apnsPushSendService, @NotNull MobilePushNotificationSendService fcmPushSendService, @NotNull MobilePushEncryption mobilePushEncryption, @NotNull ObjectMapper objectMapper, @NotNull ResourceBundleMessageSource resourceBundle) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)internalChatService, (String)"internalChatService");
        Intrinsics.checkNotNullParameter((Object)deliveryStatusRepository, (String)"deliveryStatusRepository");
        Intrinsics.checkNotNullParameter((Object)apnsPushSendService, (String)"apnsPushSendService");
        Intrinsics.checkNotNullParameter((Object)fcmPushSendService, (String)"fcmPushSendService");
        Intrinsics.checkNotNullParameter((Object)mobilePushEncryption, (String)"mobilePushEncryption");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)resourceBundle, (String)"resourceBundle");
        this.mobilePushTokenService = mobilePushTokenService;
        this.internalChatService = internalChatService;
        this.deliveryStatusRepository = deliveryStatusRepository;
        this.apnsPushSendService = apnsPushSendService;
        this.fcmPushSendService = fcmPushSendService;
        this.mobilePushEncryption = mobilePushEncryption;
        this.objectMapper = objectMapper;
        this.resourceBundle = resourceBundle;
    }

    /*
     * WARNING - void declaration
     */
    public void sendPushNotifications(@NotNull Notification notification, @NotNull Set<? extends ProfileId> resolvedReceivers) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Intrinsics.checkNotNullParameter(resolvedReceivers, (String)"resolvedReceivers");
        Iterable iterable = this.mobilePushTokenService.findByProfileIds((Iterable)resolvedReceivers);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MobilePushToken it = (MobilePushToken)element$iv$iv;
            boolean bl = false;
            if (!(it.getMobilePlatform() == MobilePlatform.ANDROID || !it.getIosSilenceAlerts())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pushTokens = (List)destination$iv$iv;
        if (pushTokens.isEmpty()) {
            return;
        }
        Map unreadSocialNotifications = this.getUnreadSocialNotificationCount(pushTokens);
        Map iosUnreadChatMessageCounts = this.getIosUnreadChatMessageCounts(pushTokens);
        destination$iv$iv = pushTokens;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pushToken;
            MobilePushToken mobilePushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.standardMobilePushNotification(notification, (MobilePushToken)pushToken, unreadSocialNotifications, iosUnreadChatMessageCounts));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MobilePushNotification p0 = (MobilePushNotification)element$iv$iv;
            boolean bl = false;
            MobilePlatform key$iv$iv = p0.getMobilePlatform();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object mobilePushNotificationsByPlatform = destination$iv$iv2;
        this.apnsPushSendService.sendAll(mobilePushNotificationsByPlatform.getOrDefault(MobilePlatform.IOS, CollectionsKt.emptyList()));
        this.fcmPushSendService.sendAll(mobilePushNotificationsByPlatform.getOrDefault(MobilePlatform.ANDROID, CollectionsKt.emptyList()));
    }

    public int sendLogoutPushNotifications() {
        int total = 0;
        String[] stringArray = new String[]{"createdAt"};
        PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort.Direction)Sort.Direction.ASC, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        Slice pushTokenSlice = this.mobilePushTokenService.findAll((Pageable)pageRequest);
        List list = pushTokenSlice.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        this.sendLogoutPushNotifications(list);
        total += pushTokenSlice.getNumberOfElements();
        while (pushTokenSlice.hasNext()) {
            Pageable pageable = pushTokenSlice.nextPageable();
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"nextPageable(...)");
            pushTokenSlice = this.mobilePushTokenService.findAll(pageable);
            List list2 = pushTokenSlice.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
            this.sendLogoutPushNotifications(list2);
            total += pushTokenSlice.getNumberOfElements();
        }
        LOG.info("Sent {} push notifications to log out mobile users.", (Object)total);
        return total;
    }

    /*
     * WARNING - void declaration
     */
    private void sendLogoutPushNotifications(List<MobilePushToken> pushTokens) {
        void $this$groupByTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = pushTokens;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushToken mobilePushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.logoutMobilePushNotification((MobilePushToken)it));
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MobilePushNotification p0 = (MobilePushNotification)element$iv$iv;
            boolean bl = false;
            MobilePlatform key$iv$iv = p0.getMobilePlatform();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object mobilePushNotificationsByPlatform = destination$iv$iv;
        this.apnsPushSendService.sendAll(mobilePushNotificationsByPlatform.getOrDefault(MobilePlatform.IOS, CollectionsKt.emptyList()));
        this.fcmPushSendService.sendAll(mobilePushNotificationsByPlatform.getOrDefault(MobilePlatform.ANDROID, CollectionsKt.emptyList()));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Integer> getUnreadSocialNotificationCount(List<MobilePushToken> mobilePushTokens) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv = mobilePushTokens;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushToken mobilePushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserId().toString());
        }
        Set profileIds = (Set)destination$iv$iv;
        boolean bl = false;
        return this.deliveryStatusRepository.countByReceiverIdsAndStatusAsMap((Iterable)profileIds, NotificationStatus.OPEN);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ProfileId, Long> getIosUnreadChatMessageCounts(List<MobilePushToken> mobilePushTokens) {
        void $this$mapTo$iv$iv;
        MobilePushToken pushToken;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = mobilePushTokens;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pushToken = (MobilePushToken)element$iv$iv;
            boolean bl = false;
            if (!(pushToken.getMobilePlatform() == MobilePlatform.IOS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapToSet$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$filterTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            pushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getUserId());
        }
        Set set = (Set)destination$iv$iv;
        InternalChatService internalChatService = this.internalChatService;
        Set p0 = set;
        boolean bl = false;
        return internalChatService.getIosUnreadChatMessageCounts(p0);
    }

    private MobilePushNotification standardMobilePushNotification(Notification notification, MobilePushToken pushToken, Map<String, Integer> unreadSocialNotifications, Map<ProfileId, Long> iosUnreadChatMessageCounts) {
        MobilePushNotification.EncryptedContent encryptedContent;
        String string = pushToken.getPublicKey();
        if (string != null) {
            String publicKey = string;
            boolean bl = false;
            encryptedContent = this.mobilePushEncryption.encryptContent(this.title(notification, pushToken.getLocale()), this.text(notification, pushToken.getLocale()), publicKey, pushToken.getUserId());
        } else {
            encryptedContent = null;
        }
        MobilePushNotification.EncryptedContent encryptedContent2 = encryptedContent;
        ProfileId profileId = pushToken.getUserId();
        String string2 = pushToken.getToken();
        MobilePlatform mobilePlatform = pushToken.getMobilePlatform();
        String string3 = this.resourceBundle.getMessage("mobile.push.defaultTitle", null, pushToken.getLocale());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMessage(...)");
        String string4 = string3;
        String string5 = this.resourceBundle.getMessage("mobile.push.defaultBody", null, pushToken.getLocale());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getMessage(...)");
        String string6 = string5;
        Integer n = unreadSocialNotifications.get(pushToken.getUserId().toString());
        int n2 = n != null ? n : 0;
        Long l = iosUnreadChatMessageCounts.get(pushToken.getUserId());
        int n3 = (int)RangesKt.coerceAtMost((long)(l != null ? l : 0L), (long)Integer.MAX_VALUE);
        String string7 = this.destination(notification);
        String string8 = notification.getAppId();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getAppId(...)");
        String string9 = string8;
        return (MobilePushNotification)new MobilePushNotification.Standard(null, profileId, string2, mobilePlatform, string4, string6, encryptedContent2, n2, n3, string9, string7, 1, null);
    }

    private MobilePushNotification logoutMobilePushNotification(MobilePushToken pushToken) {
        ProfileId profileId = pushToken.getUserId();
        String string = pushToken.getToken();
        MobilePlatform mobilePlatform = pushToken.getMobilePlatform();
        String string2 = this.resourceBundle.getMessage("mobile.push.logoutTitle", null, pushToken.getLocale());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
        String string3 = this.resourceBundle.getMessage("mobile.push.logoutBody", null, pushToken.getLocale());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMessage(...)");
        return (MobilePushNotification)new MobilePushNotification.Logout(null, profileId, string, mobilePlatform, string2, string3, 1, null);
    }

    private String title(Notification $this$title, Locale locale) {
        String string = (String)$this$title.getLocalizedTitle().get((Object)locale);
        if (string == null) {
            String string2 = $this$title.getDefaultTitle();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefaultTitle(...)");
        }
        return string;
    }

    private String text(Notification $this$text, Locale locale) {
        String string = (String)$this$text.getLocalizedText().get((Object)locale);
        if (string == null) {
            String string2 = $this$text.getDefaultText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefaultText(...)");
        }
        return string;
    }

    private String destination(Notification notification) {
        NotificationPushDestination notificationPushDestination = this.toPushDestination(notification);
        ObjectMapper objectMapper = this.objectMapper;
        NotificationPushDestination p0 = notificationPushDestination;
        boolean bl = false;
        String string = objectMapper.writeValueAsString((Object)p0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        return string;
    }

    private NotificationPushDestination toPushDestination(Notification $this$toPushDestination) {
        UUID uUID = $this$toPushDestination.getId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getId(...)");
        String string = $this$toPushDestination.getAppId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAppId(...)");
        NotificationType notificationType = $this$toPushDestination.getType();
        Intrinsics.checkNotNullExpressionValue((Object)notificationType, (String)"getType(...)");
        return new NotificationPushDestination(uUID, string, notificationType, $this$toPushDestination.getTargetId());
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

