/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.notificationclient.model.NotificationConcern;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.mobile.model.MobileNotification;
import de.justsoftware.notificationservice.mobile.persistence.DeletedDeliveryStatusForSyncRepository;
import de.justsoftware.notificationservice.mobile.service.MobileNotificationService;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.model.PageRequests;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusId;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusWithNotification;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/notificationservice/mobile/service/MobileNotificationService;", "", "deliveryStatusRepository", "Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "deletedDeliveryStatusRepository", "Lde/justsoftware/notificationservice/mobile/persistence/DeletedDeliveryStatusForSyncRepository;", "<init>", "(Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;Lde/justsoftware/notificationservice/mobile/persistence/DeletedDeliveryStatusForSyncRepository;)V", "getMobileNotifications", "", "Lde/justsoftware/notificationservice/mobile/model/MobileNotification;", "receiverId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "limit", "", "locale", "Ljava/util/Locale;", "getMobileNotificationsByStatus", "status", "Lde/justsoftware/notificationservice/model/NotificationStatus;", "before", "Ljava/time/Instant;", "getUpdatedMobileNotifications", "since", "getDeletedMobileNotificationIds", "Ljava/util/UUID;", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobileNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileNotificationService.kt\nde/justsoftware/notificationservice/mobile/service/MobileNotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1563#2:84\n1634#2,3:85\n1563#2:88\n1634#2,3:89\n*S KotlinDebug\n*F\n+ 1 MobileNotificationService.kt\nde/justsoftware/notificationservice/mobile/service/MobileNotificationService\n*L\n62#1:84\n62#1:85,3\n71#1:88\n71#1:89,3\n*E\n"})
public class MobileNotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeliveryStatusRepository deliveryStatusRepository;
    @NotNull
    private final DeletedDeliveryStatusForSyncRepository deletedDeliveryStatusRepository;
    @NotNull
    private static final ImmutableSet<NotificationType> ALL_NOTIFICATION_TYPES;

    public MobileNotificationService(@NotNull DeliveryStatusRepository deliveryStatusRepository, @NotNull DeletedDeliveryStatusForSyncRepository deletedDeliveryStatusRepository) {
        Intrinsics.checkNotNullParameter((Object)deliveryStatusRepository, (String)"deliveryStatusRepository");
        Intrinsics.checkNotNullParameter((Object)deletedDeliveryStatusRepository, (String)"deletedDeliveryStatusRepository");
        this.deliveryStatusRepository = deliveryStatusRepository;
        this.deletedDeliveryStatusRepository = deletedDeliveryStatusRepository;
    }

    @NotNull
    public List<MobileNotification> getMobileNotifications(@NotNull ProfileId receiverId, int limit, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Companion.access$toMobileNotifications((Companion)Companion, (Page)this.deliveryStatusRepository.findWithNotifications(string, (Iterable)ALL_NOTIFICATION_TYPES, (Pageable)PageRequests.recentNotifications((int)limit)), (Locale)locale);
    }

    @NotNull
    public List<MobileNotification> getMobileNotificationsByStatus(@NotNull ProfileId receiverId, @NotNull NotificationStatus status, @NotNull Instant before, int limit, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Companion.access$toMobileNotifications((Companion)Companion, (Page)this.deliveryStatusRepository.findWithNotificationsBefore(string, (Iterable)ALL_NOTIFICATION_TYPES, status, before, (Pageable)PageRequests.recentNotifications((int)limit)), (Locale)locale);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<MobileNotification> getUpdatedMobileNotifications(@NotNull ProfileId receiverId, @NotNull Instant since, @NotNull Locale locale) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable iterable = this.deliveryStatusRepository.findWithNotificationsUpdatedAfter(string, (Iterable)ALL_NOTIFICATION_TYPES, since);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbDeliveryStatusWithNotification dbDeliveryStatusWithNotification = (DbDeliveryStatusWithNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileNotification.Companion.toMobileNotification((DbDeliveryStatusWithNotification)it, locale));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UUID> getDeletedMobileNotificationIds(@NotNull ProfileId receiverId, @NotNull Instant since) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable $this$map$iv = this.deletedDeliveryStatusRepository.findByReceiverIdAndUpdatedAtGreaterThan(string, since);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DbDeliveryStatusId dbDeliveryStatusId = (DbDeliveryStatusId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getNotificationId());
        }
        return (List)destination$iv$iv;
    }

    static {
        ImmutableSet immutableSet = NotificationType.forConcern((NotificationConcern)NotificationConcern.ALL);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"forConcern(...)");
        ALL_NOTIFICATION_TYPES = immutableSet;
    }
}

