/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import de.justsoftware.notificationservice.mobile.model.ChangeQuery;
import de.justsoftware.notificationservice.mobile.model.MobileChange;
import de.justsoftware.notificationservice.mobile.model.MobileNotification;
import de.justsoftware.notificationservice.mobile.service.MobileChangesService;
import de.justsoftware.notificationservice.mobile.service.MobileNotificationService;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/notificationservice/mobile/service/MobileChangesService;", "", "mobileNotificationService", "Lde/justsoftware/notificationservice/mobile/service/MobileNotificationService;", "<init>", "(Lde/justsoftware/notificationservice/mobile/service/MobileNotificationService;)V", "getChanges", "", "Lde/justsoftware/notificationservice/mobile/model/MobileChange;", "query", "Lde/justsoftware/notificationservice/mobile/model/ChangeQuery;", "profileId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "locale", "Ljava/util/Locale;", "fullChanges", "incrementalChanges", "since", "Ljava/time/Instant;", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobileChangesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileChangesService.kt\nde/justsoftware/notificationservice/mobile/service/MobileChangesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1563#2:66\n1634#2,3:67\n1563#2:70\n1634#2,3:71\n1563#2:74\n1634#2,3:75\n*S KotlinDebug\n*F\n+ 1 MobileChangesService.kt\nde/justsoftware/notificationservice/mobile/service/MobileChangesService\n*L\n44#1:66\n44#1:67,3\n53#1:70\n53#1:71,3\n56#1:74\n56#1:75,3\n*E\n"})
public class MobileChangesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobileNotificationService mobileNotificationService;
    public static final int FULL_SYNC_MAX_NOTIFICATIONS = 100;

    public MobileChangesService(@NotNull MobileNotificationService mobileNotificationService) {
        Intrinsics.checkNotNullParameter((Object)mobileNotificationService, (String)"mobileNotificationService");
        this.mobileNotificationService = mobileNotificationService;
    }

    @NotNull
    public List<MobileChange> getChanges(@NotNull ChangeQuery query, @NotNull ProfileId profileId, @NotNull Locale locale) {
        List list;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ChangeQuery changeQuery = query;
        if (changeQuery instanceof ChangeQuery.All) {
            list = this.fullChanges(profileId, locale);
        } else if (changeQuery instanceof ChangeQuery.Changed) {
            list = this.incrementalChanges(profileId, locale, ((ChangeQuery.Changed)query).getSince());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> fullChanges(ProfileId profileId, Locale locale) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.mobileNotificationService.getMobileNotifications(profileId, 100, locale);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void notification;
            MobileNotification mobileNotification = (MobileNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange((MobileNotification)notification));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> incrementalChanges(ProfileId profileId, Locale locale, Instant since) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable iterable = this.mobileNotificationService.getUpdatedMobileNotifications(profileId, since, locale);
        boolean $i$f$map22 = false;
        void var7_7 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            MobileNotification mobileNotification = (MobileNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange((MobileNotification)it));
        }
        List updatedNotifications = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.mobileNotificationService.getDeletedMobileNotificationIds(profileId, since);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID bl = (UUID)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(MobileChange.Companion.toDeleteNotificationChange(string));
        }
        List deletedNotifications = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)updatedNotifications, (Iterable)deletedNotifications);
    }
}

