/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.controller;

import de.justsoftware.notificationservice.authorization.AuthorizationContext;
import de.justsoftware.notificationservice.mobile.model.MobileChangeList;
import de.justsoftware.notificationservice.mobile.model.MobileNotification;
import de.justsoftware.notificationservice.mobile.model.MobileSyncToken;
import de.justsoftware.notificationservice.mobile.service.MobileNotificationService;
import de.justsoftware.notificationservice.mobile.service.MobileSyncService;
import de.justsoftware.notificationservice.model.NotificationStatus;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mobile"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J4\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/notificationservice/mobile/controller/MobileController;", "", "mobileNotificationService", "Lde/justsoftware/notificationservice/mobile/service/MobileNotificationService;", "mobileSyncService", "Lde/justsoftware/notificationservice/mobile/service/MobileSyncService;", "<init>", "(Lde/justsoftware/notificationservice/mobile/service/MobileNotificationService;Lde/justsoftware/notificationservice/mobile/service/MobileSyncService;)V", "getChanges", "Lde/justsoftware/notificationservice/mobile/model/MobileChangeList;", "token", "Lde/justsoftware/notificationservice/mobile/model/MobileSyncToken;", "authContext", "Lde/justsoftware/notificationservice/authorization/AuthorizationContext;", "getNotifications", "", "Lde/justsoftware/notificationservice/mobile/model/MobileNotification;", "status", "Lde/justsoftware/notificationservice/model/NotificationStatus;", "limit", "", "before", "Ljava/time/Instant;", "notification-service"})
public class MobileController {
    @NotNull
    private final MobileNotificationService mobileNotificationService;
    @NotNull
    private final MobileSyncService mobileSyncService;

    public MobileController(@NotNull MobileNotificationService mobileNotificationService, @NotNull MobileSyncService mobileSyncService) {
        Intrinsics.checkNotNullParameter((Object)mobileNotificationService, (String)"mobileNotificationService");
        Intrinsics.checkNotNullParameter((Object)mobileSyncService, (String)"mobileSyncService");
        this.mobileNotificationService = mobileNotificationService;
        this.mobileSyncService = mobileSyncService;
    }

    @GetMapping(value={"/changes"})
    @NotNull
    public MobileChangeList getChanges(@RequestParam(value="token", required=false) @Nullable MobileSyncToken token, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileSyncService.getChanges(token, authContext);
    }

    @GetMapping(value={"/notifications"})
    @NotNull
    public List<MobileNotification> getNotifications(@RequestParam(name="status") @NotNull NotificationStatus status, @RequestParam(name="limit", defaultValue="20") int limit, @RequestParam(name="before") @NotNull Instant before, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileNotificationService.getMobileNotificationsByStatus(authContext.getProfileId(), status, before, limit, authContext.getLocale());
    }
}

