/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice;

import de.justsoftware.notificationservice.MobilePushConfiguration;
import de.justsoftware.notificationservice.business.CommonConfigProperties;
import de.justsoftware.notificationservice.mobile.service.JunoRestClientService;
import de.justsoftware.notificationservice.mobile.service.MobilePushNotificationSendService;
import de.justsoftware.notificationservice.mobile.service.MobilePushTokenService;
import de.justsoftware.notificationservice.mobile.service.ScheduledMobilePushNotificationStore;
import de.justsoftware.notificationservice.mobile.util.MobilePushEncryption;
import de.justsoftware.notificationservice.mobile.util.MobilePushEncryptionKt;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.ClientTransport;

@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\"\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0017J\"\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0017J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0017\u001a\u00020\u0015H\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/notificationservice/MobilePushConfiguration;", "", "<init>", "()V", "clock", "Ljava/time/Clock;", "junoHttpClient", "Lreactor/netty/http/client/HttpClient;", "junoApnsRestClient", "Lde/justsoftware/notificationservice/mobile/service/JunoRestClientService;", "junoBasePathApns", "", "commonConfigProperties", "Lde/justsoftware/notificationservice/business/CommonConfigProperties;", "junoFcmRestClient", "junoBasePathFcm", "apnsPushSendService", "Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationSendService;", "mobilePushTokenService", "Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;", "apnsPushTaskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "fcmPushSendService", "fcmPushTaskScheduler", "mobilePushEncryption", "Lde/justsoftware/notificationservice/mobile/util/MobilePushEncryption;", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushConfiguration.kt\nde/justsoftware/notificationservice/MobilePushConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public class MobilePushConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long TIMEOUT_SECONDS = 60L;

    @Bean
    @NotNull
    public Clock clock() {
        Clock clock = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
        return clock;
    }

    @Bean
    @NotNull
    public HttpClient junoHttpClient() {
        ClientTransport clientTransport = ((HttpClient)((HttpClient)HttpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)60000)).responseTimeout(Duration.ofSeconds(60L)).proxyWithSystemProperties()).doOnConnected(arg_0 -> MobilePushConfiguration.junoHttpClient$lambda$1(MobilePushConfiguration::junoHttpClient$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"doOnConnected(...)");
        return (HttpClient)clientTransport;
    }

    @Bean
    @NotNull
    public JunoRestClientService junoApnsRestClient(@Value(value="${just.juno.baseurl.apns}") @NotNull String junoBasePathApns, @NotNull HttpClient junoHttpClient, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathApns, (String)"junoBasePathApns");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathApns + "/v1", junoHttpClient, commonConfigProperties);
    }

    @Bean
    @NotNull
    public JunoRestClientService junoFcmRestClient(@Value(value="${just.juno.baseurl.fcm}") @NotNull String junoBasePathFcm, @NotNull HttpClient junoHttpClient, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathFcm, (String)"junoBasePathFcm");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathFcm + "/v1", junoHttpClient, commonConfigProperties);
    }

    @Bean
    @NotNull
    public MobilePushNotificationSendService apnsPushSendService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull JunoRestClientService junoApnsRestClient, @NotNull TaskScheduler apnsPushTaskScheduler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)junoApnsRestClient, (String)"junoApnsRestClient");
        Intrinsics.checkNotNullParameter((Object)apnsPushTaskScheduler, (String)"apnsPushTaskScheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new MobilePushNotificationSendService(mobilePushTokenService, new ScheduledMobilePushNotificationStore(), junoApnsRestClient, apnsPushTaskScheduler, clock);
    }

    @Bean
    @NotNull
    public MobilePushNotificationSendService fcmPushSendService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull JunoRestClientService junoFcmRestClient, @NotNull TaskScheduler fcmPushTaskScheduler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)junoFcmRestClient, (String)"junoFcmRestClient");
        Intrinsics.checkNotNullParameter((Object)fcmPushTaskScheduler, (String)"fcmPushTaskScheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new MobilePushNotificationSendService(mobilePushTokenService, new ScheduledMobilePushNotificationStore(), junoFcmRestClient, fcmPushTaskScheduler, clock);
    }

    @Bean
    @NotNull
    public TaskScheduler apnsPushTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler;
        ThreadPoolTaskScheduler $this$apnsPushTaskScheduler_u24lambda_u242 = threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        boolean bl = false;
        $this$apnsPushTaskScheduler_u24lambda_u242.setPoolSize(1);
        return (TaskScheduler)threadPoolTaskScheduler;
    }

    @Bean
    @NotNull
    public TaskScheduler fcmPushTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler;
        ThreadPoolTaskScheduler $this$fcmPushTaskScheduler_u24lambda_u243 = threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        boolean bl = false;
        $this$fcmPushTaskScheduler_u24lambda_u243.setPoolSize(1);
        return (TaskScheduler)threadPoolTaskScheduler;
    }

    @Bean
    @NotNull
    public MobilePushEncryption mobilePushEncryption() {
        return MobilePushEncryptionKt.getMobilePushEncryption();
    }

    private static final Unit junoHttpClient$lambda$0(Connection connection) {
        connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(60L, TimeUnit.SECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(60L, TimeUnit.SECONDS));
        return Unit.INSTANCE;
    }

    private static final void junoHttpClient$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

