/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.RemoveRaftVoterResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.LogHistory;
import org.apache.kafka.raft.internals.RemoveVoterHandlerState;
import org.apache.kafka.server.common.KRaftVersion;
import org.slf4j.Logger;

public final class RemoveVoterHandler {
    private final Optional<ReplicaKey> localReplicaKey;
    private final KRaftControlRecordStateMachine partitionState;
    private final Time time;
    private final long requestTimeoutMs;
    private final Logger logger;

    public RemoveVoterHandler(OptionalInt nodeId, Uuid nodeDirectoryId, KRaftControlRecordStateMachine partitionState, Time time, long requestTimeoutMs, LogContext logContext) {
        this.localReplicaKey = nodeId.isPresent() ? Optional.of(ReplicaKey.of(nodeId.getAsInt(), nodeDirectoryId)) : Optional.empty();
        this.partitionState = partitionState;
        this.time = time;
        this.requestTimeoutMs = requestTimeoutMs;
        this.logger = logContext.logger(RemoveVoterHandler.class);
    }

    public CompletableFuture<RemoveRaftVoterResponseData> handleRemoveVoterRequest(LeaderState<?> leaderState, ReplicaKey voterKey, long currentTimeMs) {
        if (leaderState.isOperationPending(currentTimeMs)) {
            return CompletableFuture.completedFuture(RaftUtil.removeVoterResponse(Errors.REQUEST_TIMED_OUT, "Request timed out waiting for leader to handle previous voter change request"));
        }
        Optional<Long> highWatermark = leaderState.highWatermark().map(LogOffsetMetadata::offset);
        if (!highWatermark.isPresent()) {
            return CompletableFuture.completedFuture(RaftUtil.removeVoterResponse(Errors.REQUEST_TIMED_OUT, "Request timed out waiting for leader to establish HWM and fence previous voter changes"));
        }
        KRaftVersion kraftVersion = this.partitionState.lastKraftVersion();
        if (!kraftVersion.isReconfigSupported()) {
            return CompletableFuture.completedFuture(RaftUtil.removeVoterResponse(Errors.UNSUPPORTED_VERSION, String.format("Cluster doesn't support removing voter because the %s feature is %s", kraftVersion.featureName(), kraftVersion.featureLevel())));
        }
        Optional<LogHistory.Entry<VoterSet>> votersEntry = this.partitionState.lastVoterSetEntry();
        if (!votersEntry.isPresent() || votersEntry.get().offset() >= highWatermark.get()) {
            return CompletableFuture.completedFuture(RaftUtil.removeVoterResponse(Errors.REQUEST_TIMED_OUT, String.format("Request timed out waiting for voters to commit the latest voter change at %s with HWM %d", votersEntry.map(LogHistory.Entry::offset), highWatermark.get())));
        }
        Optional<VoterSet> newVoters = votersEntry.get().value().removeVoter(voterKey);
        if (!newVoters.isPresent()) {
            return CompletableFuture.completedFuture(RaftUtil.removeVoterResponse(Errors.VOTER_NOT_FOUND, String.format("Cannot remove voter %s from the set of voters %s", voterKey, votersEntry.get().value().voterKeys())));
        }
        RemoveVoterHandlerState state = new RemoveVoterHandlerState(leaderState.appendVotersRecord(newVoters.get(), currentTimeMs), this.time.timer(this.requestTimeoutMs));
        leaderState.resetRemoveVoterHandlerState(Errors.UNKNOWN_SERVER_ERROR, null, Optional.of(state));
        return state.future();
    }

    public void highWatermarkUpdated(LeaderState<?> leaderState) {
        leaderState.removeVoterHandlerState().ifPresent(current -> leaderState.highWatermark().ifPresent(highWatermark -> {
            if (highWatermark.offset() > current.lastOffset()) {
                leaderState.resetRemoveVoterHandlerState(Errors.NONE, null, Optional.empty());
                VoterSet voters = this.partitionState.lastVoterSet();
                ReplicaKey localKey = this.localReplicaKey.orElseThrow(() -> new IllegalStateException(String.format("Leaders mush have an id and directory id %s", this.localReplicaKey)));
                if (!voters.isVoter(localKey)) {
                    this.logger.info("Leader is not in the committed voter set {} resign from epoch {}", voters.voterKeys(), (Object)leaderState.epoch());
                    leaderState.requestResign();
                }
            }
        }));
    }
}

