/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.translation;

import de.justsoftware.wikiservice.model.ArticleDeletedEvent;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.persistence.OriginalLanguageRepository;
import de.justsoftware.wikiservice.persistence.TranslationRepository;
import de.justsoftware.wikiservice.persistence.model.DbOriginalLanguage;
import de.justsoftware.wikiservice.translation.DeepLTranslationProvider;
import de.justsoftware.wikiservice.translation.Translatable;
import de.justsoftware.wikiservice.translation.TranslationProvider;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.translation.annotation.TranslatableField;
import de.justsoftware.wikiservice.translation.handler.TranslationHandler;
import de.justsoftware.wikiservice.translation.model.TranslationContext;
import de.justsoftware.wikiservice.translation.model.TranslationErrorCode;
import de.justsoftware.wikiservice.translation.model.TranslationException;
import de.justsoftware.wikiservice.translation.model.TranslationMetaData;
import de.justsoftware.wikiservice.translation.model.TranslationResult;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.ReflectionUtilsKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0017\u0018\u0000 (2\u00020\u0001:\u0001(B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ5\u0010\f\u001a\u0002H\r\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0011\u00a2\u0006\u0002\b\u0019J\u0016\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0012J5\u0010\u001d\u001a\u0002H\r\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012\u00a2\u0006\u0002\u0010\u0014JN\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\"\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\"j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011`#2\b\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J,\u0010%\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110'H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/wikiservice/translation/TranslationService;", "", "translationProvider", "Lde/justsoftware/wikiservice/translation/TranslationProvider;", "translationRepository", "Lde/justsoftware/wikiservice/persistence/TranslationRepository;", "originalLanguageRepository", "Lde/justsoftware/wikiservice/persistence/OriginalLanguageRepository;", "transactionManager", "Lorg/springframework/transaction/PlatformTransactionManager;", "<init>", "(Lde/justsoftware/wikiservice/translation/TranslationProvider;Lde/justsoftware/wikiservice/persistence/TranslationRepository;Lde/justsoftware/wikiservice/persistence/OriginalLanguageRepository;Lorg/springframework/transaction/PlatformTransactionManager;)V", "translate", "T", "Lde/justsoftware/wikiservice/translation/Translatable;", "model", "targetLanguage", "", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "(Lde/justsoftware/wikiservice/translation/Translatable;Ljava/lang/String;Lde/justsoftware/wikiservice/model/TenantId;)Lde/justsoftware/wikiservice/translation/Translatable;", "handleArticleVersionDeleted", "", "evt", "Lde/justsoftware/wikiservice/model/ArticleDeletedEvent;", "handleArticleVersionDeleted$wiki_service", "deleteTranslations", "ids", "", "doTranslate", "getTranslation", "Lde/justsoftware/wikiservice/translation/model/TranslationResult;", "translationItemId", "text", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "sourceLanguage", "saveTranslationIntoDB", "translatedText", "", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTranslationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationService.kt\nde/justsoftware/wikiservice/translation/TranslationService\n+ 2 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,250:1\n7#2:251\n1628#3,3:252\n1863#3,2:255\n216#4,2:257\n*S KotlinDebug\n*F\n+ 1 TranslationService.kt\nde/justsoftware/wikiservice/translation/TranslationService\n*L\n71#1:251\n71#1:252,3\n103#1:255,2\n138#1:257,2\n*E\n"})
public class TranslationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TranslationProvider translationProvider;
    @NotNull
    private final TranslationRepository translationRepository;
    @NotNull
    private final OriginalLanguageRepository originalLanguageRepository;
    @NotNull
    private final PlatformTransactionManager transactionManager;
    private static final Logger LOG = LoggerFactory.getLogger(TranslationService.class);

    public TranslationService(@NotNull TranslationProvider translationProvider, @NotNull TranslationRepository translationRepository, @NotNull OriginalLanguageRepository originalLanguageRepository, @NotNull PlatformTransactionManager transactionManager) {
        Intrinsics.checkNotNullParameter((Object)translationProvider, (String)"translationProvider");
        Intrinsics.checkNotNullParameter((Object)translationRepository, (String)"translationRepository");
        Intrinsics.checkNotNullParameter((Object)originalLanguageRepository, (String)"originalLanguageRepository");
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"transactionManager");
        this.translationProvider = translationProvider;
        this.translationRepository = translationRepository;
        this.originalLanguageRepository = originalLanguageRepository;
        this.transactionManager = transactionManager;
    }

    @NotNull
    public <T extends Translatable<T>> T translate(@NotNull T model, @NotNull String targetLanguage, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        try {
            return (T)this.doTranslate(model, targetLanguage, tenantId);
        }
        catch (TranslationException e) {
            model.setTranslationMetaData(new TranslationMetaData(targetLanguage, null, null, e.getErrorCode(), 6, null));
            return model;
        }
        catch (Throwable e) {
            LOG.error("Failed to translate model with ID {}. Returning the original instance.", (Object)model.translationId(), (Object)e);
            model.setTranslationMetaData(new TranslationMetaData(targetLanguage, null, null, TranslationErrorCode.UNKNOWN_ERROR, 6, null));
            return model;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener
    @Transactional
    public void handleArticleVersionDeleted$wiki_service(@NotNull ArticleDeletedEvent evt) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable iterable = evt.getArticleVersionIds();
        TranslationService translationService = this;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArticleVersionId articleVersionId = (ArticleVersionId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        translationService.deleteTranslations((Set)destination$iv$iv);
    }

    private void deleteTranslations(Set<String> ids) {
        LOG.info("Deleting translations in the database for item IDs: {}", ids);
        this.translationRepository.deleteByItemIdIn(ids);
    }

    private <T extends Translatable<T>> T doTranslate(T model, String targetLanguage, TenantId tenantId) {
        Object object;
        String sourceLanguage;
        if (!this.translationProvider.isTranslationEnabled(tenantId)) {
            return model;
        }
        String translationItemId = model.translationId();
        String string = DeepLTranslationProvider.Companion.standardizeLanguageCode(targetLanguage);
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        String standardizeTargetLanguage = string;
        Optional optional = this.originalLanguageRepository.findById((Object)model.translationId());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        DbOriginalLanguage dbOriginalLanguage = (DbOriginalLanguage)OptionalsKt.getOrNull((Optional)optional);
        String string3 = sourceLanguage = dbOriginalLanguage != null ? dbOriginalLanguage.getLanguage() : null;
        if (Intrinsics.areEqual((Object)standardizeTargetLanguage, (Object)sourceLanguage)) {
            LOG.debug("Target language '" + standardizeTargetLanguage + "' is the original language of " + translationItemId + ". Nothing to translate.");
            return model;
        }
        LinkedHashMap translatable = new LinkedHashMap();
        LinkedHashMap propToHandler = new LinkedHashMap();
        Iterable $this$forEach$iv = Companion.access$getTranslatableFieldProps((Companion)Companion, model);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            object = (Pair)element$iv;
            boolean bl = false;
            KProperty1 prop = (KProperty1)object.component1();
            TranslatableField translatableAnnotation = (TranslatableField)object.component2();
            KCallablesJvm.setAccessible((KCallable)((KCallable)prop), (boolean)true);
            Object[] objectArray = new Object[]{model};
            Object raw = prop.getGetter().call(objectArray);
            Object object2 = KClasses.createInstance((KClass)Reflection.getOrCreateKotlinClass((Class)translatableAnnotation.handler()));
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type de.justsoftware.wikiservice.translation.handler.TranslationHandler<kotlin.Any?>");
            TranslationHandler handler = (TranslationHandler)object2;
            TranslationContext ctx = new TranslationContext(model, translationItemId, model.getClass(), prop.getName(), translatableAnnotation.value());
            handler.init(raw, ctx);
            Map translatableData = handler.getTranslatableData();
            if (!(!translatableData.isEmpty())) continue;
            translatable.putAll(translatableData);
            ((Map)propToHandler).put(prop, handler);
        }
        if (translatable.isEmpty()) {
            return model;
        }
        TranslationResult translated = this.getTranslation(translationItemId, translatable, sourceLanguage, standardizeTargetLanguage, tenantId);
        Translatable result = model.shallowCopy();
        Map $this$forEach$iv2 = propToHandler;
        boolean $i$f$forEach2 = false;
        object = $this$forEach$iv2.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            KProperty prop = (KProperty)entry.getKey();
            TranslationHandler handler = (TranslationHandler)entry.getValue();
            Object translatedValue = handler.getTranslation(translated.getTranslatedText());
            ReflectionUtilsKt.setField((Object)result, (KProperty)prop, (Object)translatedValue);
        }
        result.setTranslationMetaData(new TranslationMetaData(standardizeTargetLanguage, translated.getDetectedSourceLanguage(), model, null, 8, null));
        return (T)result;
    }

    private TranslationResult getTranslation(String translationItemId, LinkedHashMap<String, String> text, String sourceLanguage, String targetLanguage, TenantId tenantId) throws TranslationException {
        if (text.isEmpty()) {
            return new TranslationResult(MapsKt.emptyMap(), sourceLanguage);
        }
        Map translationsFromDB = Companion.access$toMap((Companion)Companion, (List)this.translationRepository.findByItemIdAndLanguage(translationItemId, targetLanguage));
        Set set = translationsFromDB.keySet();
        Set<String> set2 = text.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        if (set.containsAll((Collection)set2)) {
            LOG.debug("Translation for '" + targetLanguage + "' of item " + translationItemId + " found in DB. Return DB Translations.");
            return new TranslationResult(translationsFromDB, sourceLanguage);
        }
        LOG.debug("Translation for '" + targetLanguage + "' of item " + translationItemId + " not in DB. Translating text...");
        TranslationResult translations = this.translationProvider.translate(text, sourceLanguage, targetLanguage, tenantId);
        String standardizeLanguageCode = DeepLTranslationProvider.Companion.standardizeLanguageCode(translations.getDetectedSourceLanguage());
        if (sourceLanguage == null && standardizeLanguageCode != null) {
            LOG.debug("Save detected source language '" + standardizeLanguageCode + "' for item " + translationItemId + " into DB.");
            this.originalLanguageRepository.save((Object)new DbOriginalLanguage(translationItemId, standardizeLanguageCode));
        }
        if (Intrinsics.areEqual((Object)targetLanguage, (Object)sourceLanguage)) {
            LOG.debug("Detected source language is the target language '" + targetLanguage + "'. Return original text.");
            return new TranslationResult((Map)text, sourceLanguage);
        }
        this.saveTranslationIntoDB(translationItemId, targetLanguage, translations.getTranslatedText());
        return translations;
    }

    private void saveTranslationIntoDB(String translationItemId, String targetLanguage, Map<String, String> translatedText) {
        new TransactionTemplate(this.transactionManager).execute(arg_0 -> TranslationService.saveTranslationIntoDB$lambda$3(targetLanguage, translationItemId, this, translatedText, arg_0));
    }

    private static final List saveTranslationIntoDB$lambda$3(String $targetLanguage, String $translationItemId, TranslationService this$0, Map $translatedText, TransactionStatus it) {
        LOG.debug("Save translations for target language '" + $targetLanguage + "' for item " + $translationItemId + " into DB.");
        this$0.translationRepository.deleteByItemIdAndLanguage($translationItemId, $targetLanguage);
        this$0.translationRepository.flush();
        return this$0.translationRepository.saveAll((Iterable)Companion.toDBTranslations$wiki_service($translatedText, $translationItemId, $targetLanguage));
    }
}

