/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.UserInfoApplicationService;
import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ArticleHeadingDto;
import de.justsoftware.wikiservice.application.model.ArticleVersionDto;
import de.justsoftware.wikiservice.application.model.PageDto;
import de.justsoftware.wikiservice.application.model.PageDtoKt;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.business.model.Article;
import de.justsoftware.wikiservice.business.model.ArticleHeading;
import de.justsoftware.wikiservice.business.model.ArticleVersion;
import de.justsoftware.wikiservice.business.model.Profile;
import de.justsoftware.wikiservice.business.model.Subscription;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.translation.Translatable;
import de.justsoftware.wikiservice.translation.TranslationService;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0001\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J8\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J8\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J \u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J.\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u0002082\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J6\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010=2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0012J3\u0010?\u001a\u0002H@\"\u0004\b\u0000\u0010@*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002H@0BH\u0012\u00a2\u0006\u0002\u0010CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lde/justsoftware/wikiservice/application/ArticleApplicationService;", "", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "userInfoApplicationService", "Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "translationService", "Lde/justsoftware/wikiservice/translation/TranslationService;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "<init>", "(Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/application/UserInfoApplicationService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/DeletionService;Lde/justsoftware/wikiservice/translation/TranslationService;Ljava/time/Clock;J)V", "read", "Lde/justsoftware/wikiservice/application/model/ArticleDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "preferDraft", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "translationLanguage", "", "create", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "title", "content", "textContent", "isDraft", "update", "move", "toParent", "delete", "readHeadingsOfArticle", "", "Lde/justsoftware/wikiservice/application/model/ArticleHeadingDto;", "updateEditingToken", "deleteEditingToken", "readArticleVersions", "Lde/justsoftware/wikiservice/application/model/PageDto;", "Lde/justsoftware/wikiservice/application/model/ArticleVersionDto;", "page", "", "pageSize", "readArticleByVersionId", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "articleToDto", "article", "Lde/justsoftware/wikiservice/business/model/Article;", "articleVersion", "Lde/justsoftware/wikiservice/business/model/ArticleVersion;", "draftVersion", "withWriteCheck", "T", "block", "Lkotlin/Function1;", "(Lde/justsoftware/wikiservice/authorization/AuthContext;Lde/justsoftware/wikiservice/model/ArticleId;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/application/ArticleApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,298:1\n1557#2:299\n1628#2,3:300\n1246#2,4:309\n126#3:303\n153#3,3:304\n462#4:307\n412#4:308\n*S KotlinDebug\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/application/ArticleApplicationService\n*L\n199#1:299\n199#1:300,3\n233#1:309,4\n229#1:303\n229#1:304,3\n233#1:307\n233#1:308\n*E\n"})
public class ArticleApplicationService {
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserInfoApplicationService userInfoApplicationService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final DeletionService deletionService;
    @NotNull
    private final TranslationService translationService;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;

    public ArticleApplicationService(@NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull ProfileService profileService, @NotNull UserInfoApplicationService userInfoApplicationService, @NotNull SubscriptionService subscriptionService, @NotNull DeletionService deletionService, @NotNull TranslationService translationService, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration) {
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userInfoApplicationService, (String)"userInfoApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        Intrinsics.checkNotNullParameter((Object)translationService, (String)"translationService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.profileService = profileService;
        this.userInfoApplicationService = userInfoApplicationService;
        this.subscriptionService = subscriptionService;
        this.deletionService = deletionService;
        this.translationService = translationService;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
    }

    @NotNull
    public ArticleDto read(@NotNull ArticleId articleId, boolean preferDraft, @NotNull AuthContext authContext, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        ArticleVersion publishedArticleVersion = this.articleService.findLatestPublishedArticleVersion(articleId);
        ArticleVersion draftArticleVersion = this.articleService.findDraftArticleVersion(articleId);
        if (draftArticleVersion != null && (preferDraft || publishedArticleVersion == null)) {
            authContext.checkWriteWiki(article.getWikiId());
            return this.articleToDto(article, draftArticleVersion, draftArticleVersion, authContext, translationLanguage);
        }
        if (publishedArticleVersion == null) {
            throw new ArticleNotFoundException(articleId);
        }
        authContext.checkReadWiki(article.getWikiId());
        return this.articleToDto(article, publishedArticleVersion, draftArticleVersion, authContext, translationLanguage);
    }

    public static /* synthetic */ ArticleDto read$default(ArticleApplicationService articleApplicationService, ArticleId articleId, boolean bl, AuthContext authContext, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return articleApplicationService.read(articleId, bl, authContext, string);
    }

    @NotNull
    public ArticleDto create(@NotNull ParentId parentId, @NotNull String title, @NotNull String content, @NotNull String textContent, boolean isDraft, @NotNull AuthContext authContext) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        Article article = this.articleService.create(parentId, wikiId, title, content, textContent, authContext.getUser(), position, isDraft);
        if (isDraft) {
            ArticleVersion draftVersion = this.articleService.getDraftArticleVersion(article.getId());
            articleDto = ArticleApplicationService.articleToDto$default((ArticleApplicationService)this, (Article)article, (ArticleVersion)draftVersion, (ArticleVersion)draftVersion, (AuthContext)authContext, null, (int)16, null);
        } else {
            ArticleVersion articleVersion = this.articleService.getLatestPublishedArticleVersion(article.getId());
            articleDto = ArticleApplicationService.articleToDto$default((ArticleApplicationService)this, (Article)article, (ArticleVersion)articleVersion, null, (AuthContext)authContext, null, (int)16, null);
        }
        return articleDto;
    }

    @Transactional
    @NotNull
    public ArticleDto update(@NotNull ArticleId articleId, @NotNull String title, @NotNull String content, @NotNull String textContent, boolean isDraft, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        authContext.checkWriteWiki(article.getWikiId());
        Article updatedArticle = this.articleService.update(article.getId(), title, content, textContent, authContext.getUser(), isDraft);
        ArticleVersion publishedOrDraftVersion = this.articleService.getLatestPublishedOrDraftArticleVersion(updatedArticle.getId());
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(updatedArticle.getId());
        return ArticleApplicationService.articleToDto$default((ArticleApplicationService)this, (Article)article, (ArticleVersion)publishedOrDraftVersion, (ArticleVersion)draftVersion, (AuthContext)authContext, null, (int)16, null);
    }

    @Transactional
    @NotNull
    public ArticleDto move(@NotNull ArticleId articleId, @NotNull ParentId toParent, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        WikiId toWikiId = this.ancestorService.getAncestorWikiId(toParent);
        authContext.checkMoveWikiContent(article.getWikiId(), toWikiId);
        this.ancestorService.moveArticle(articleId, toParent, authContext.getUser());
        Article updatedArticle = this.articleService.read(articleId);
        ArticleVersion articleVersion = this.articleService.getLatestPublishedArticleVersion(updatedArticle.getId());
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(articleVersion.getArticleId());
        return ArticleApplicationService.articleToDto$default((ArticleApplicationService)this, (Article)updatedArticle, (ArticleVersion)articleVersion, (ArticleVersion)draftVersion, (AuthContext)authContext, null, (int)16, null);
    }

    @Transactional
    @NotNull
    public ArticleDto delete(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (ArticleDto)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.delete$lambda$0(this, articleId, authContext, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ArticleHeadingDto> readHeadingsOfArticle(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        List list;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.articleService.read(articleId).getWikiId();
        authContext.checkReadWiki(wikiId);
        List list2 = (List)this.articleService.readHeadings(SetsKt.setOf((Object)articleId)).get(articleId);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeading articleHeading = (ArticleHeading)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ArticleHeadingDto.Companion.toDto((ArticleHeading)heading));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public boolean updateEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.updateEditingToken$lambda$2(this, authContext, arg_0));
    }

    public boolean deleteEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.deleteEditingToken$lambda$3(this, authContext, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PageDto<ArticleVersionDto> readArticleVersions(@NotNull ArticleId articleId, int page, int pageSize, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Map $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map $this$map$iv = this.articleService.readByIds(SetsKt.setOf((Object)articleId));
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Article)it.getValue()).getWikiId());
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadArticleVersionHistory(wikiIds);
        Page versions = this.articleService.readPublishedVersionPage(articleId, page, pageSize);
        Set set = versions.map(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$6(ArticleApplicationService::readArticleVersions$lambda$5, arg_0)).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        $this$mapTo$iv$iv = this.profileService.readByIds(set);
        boolean $i$f$mapValues = false;
        void $i$f$mapTo22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl2 = false;
            ProfileDto profileDto = ProfileDto.Companion.toDto((Profile)it.getValue());
            object.put(k, profileDto);
        }
        Map profiles = destination$iv$iv2;
        Page page2 = versions.map(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$9(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$8(profiles, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return PageDtoKt.toPageDto((Page)page2);
    }

    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleVersion articleVersion = this.articleService.getArticleVersion(versionId);
        Article article = this.articleService.read(articleVersion.getArticleId());
        if (articleVersion.isDraft()) {
            authContext.checkWriteWiki(article.getWikiId());
        } else {
            authContext.checkReadWiki(article.getWikiId());
        }
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(articleVersion.getArticleId());
        return ArticleApplicationService.articleToDto$default((ArticleApplicationService)this, (Article)article, (ArticleVersion)articleVersion, (ArticleVersion)draftVersion, (AuthContext)authContext, null, (int)16, null);
    }

    /*
     * WARNING - void declaration
     */
    private ArticleDto articleToDto(Article article, ArticleVersion articleVersion, ArticleVersion draftVersion, AuthContext authContext, String translationLanguage) {
        String string;
        Article article2;
        ArticleDto.Companion companion;
        Map profiles;
        Subscription subscription;
        block5: {
            block4: {
                void it;
                subscription = this.subscriptionService.readArticle(article.getId(), authContext.getUser());
                Object[] objectArray = new ProfileId[]{article.getEditingStartedBy(), articleVersion.getModifiedBy()};
                profiles = this.profileService.readByIds(SetsKt.setOfNotNull((Object[])objectArray));
                companion = ArticleDto.Companion;
                article2 = article;
                string = translationLanguage;
                if (string == null) break block4;
                String string2 = string;
                Article article3 = article2;
                ArticleDto.Companion companion2 = companion;
                boolean bl = false;
                ArticleVersion articleVersion2 = (ArticleVersion)this.translationService.translate((Translatable)articleVersion, (String)it, authContext.getTenantId());
                companion = companion2;
                article2 = article3;
                ArticleVersion articleVersion3 = articleVersion2;
                string = articleVersion3;
                if (articleVersion3 != null) break block5;
            }
            string = articleVersion;
        }
        ArticleVersion articleVersion4 = draftVersion;
        Object v = profiles.get(articleVersion.getModifiedBy());
        if (v == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        Profile profile = (Profile)profiles.get(article.getEditingStartedBy());
        return companion.toDto(article2, (ArticleVersion)string, (ArticleVersionId)(articleVersion4 != null ? articleVersion4.getId() : null), this.clock, this.maxEditingTokenDuration, ProfileDto.Companion.toDto((Profile)v), profile != null ? ProfileDto.Companion.toDto(profile) : null, this.userInfoApplicationService.getUserInfo(article.getWikiId(), authContext), subscription.isSubscribed());
    }

    static /* synthetic */ ArticleDto articleToDto$default(ArticleApplicationService articleApplicationService, Article article, ArticleVersion articleVersion, ArticleVersion articleVersion2, AuthContext authContext, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: articleToDto");
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        return articleApplicationService.articleToDto(article, articleVersion, articleVersion2, authContext, string);
    }

    private <T> T withWriteCheck(AuthContext $this$withWriteCheck, ArticleId articleId, Function1<? super Article, ? extends T> block) {
        Article article = this.articleService.read(articleId);
        $this$withWriteCheck.checkWriteWiki(article.getWikiId());
        return (T)block.invoke((Object)article);
    }

    private static final ArticleDto delete$lambda$0(ArticleApplicationService this$0, ArticleId $articleId, AuthContext $authContext, Article it) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ArticleVersion articleVersion = this$0.articleService.findLatestPublishedArticleVersion($articleId);
        ArticleVersion draftVersion = this$0.articleService.findDraftArticleVersion($articleId);
        if (articleVersion == null && draftVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        DeletionId deletionId = DeletionService.create$default((DeletionService)this$0.deletionService, (ItemId)((ItemId)$articleId), (ProfileId)$authContext.getUser(), null, (int)4, null);
        this$0.articleService.delete($articleId, deletionId, $authContext.getUser());
        if (articleVersion != null) {
            articleDto = ArticleApplicationService.articleToDto$default((ArticleApplicationService)this$0, (Article)it, (ArticleVersion)articleVersion, (ArticleVersion)draftVersion, (AuthContext)$authContext, null, (int)16, null);
        } else if (draftVersion != null) {
            articleDto = ArticleApplicationService.articleToDto$default((ArticleApplicationService)this$0, (Article)it, (ArticleVersion)draftVersion, (ArticleVersion)draftVersion, (AuthContext)$authContext, null, (int)16, null);
        } else {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleDto;
    }

    private static final boolean updateEditingToken$lambda$2(ArticleApplicationService this$0, AuthContext $authContext, Article article) {
        Intrinsics.checkNotNullParameter((Object)article, (String)"article");
        return this$0.articleService.updateEditingToken(article.getId(), $authContext.getUser());
    }

    private static final boolean deleteEditingToken$lambda$3(ArticleApplicationService this$0, AuthContext $authContext, Article article) {
        Intrinsics.checkNotNullParameter((Object)article, (String)"article");
        return this$0.articleService.deleteEditingToken(article.getId(), $authContext.getUser());
    }

    private static final ProfileId readArticleVersions$lambda$5(ArticleVersion it) {
        return it.getModifiedBy();
    }

    private static final ProfileId readArticleVersions$lambda$6(Function1 $tmp0, Object p0) {
        return (ProfileId)$tmp0.invoke(p0);
    }

    private static final ArticleVersionDto readArticleVersions$lambda$8(Map $profiles, ArticleVersion it) {
        Intrinsics.checkNotNull((Object)it);
        return ArticleVersionDto.Companion.toDto(it, (ProfileDto)$profiles.get(it.getModifiedBy()));
    }

    private static final ArticleVersionDto readArticleVersions$lambda$9(Function1 $tmp0, Object p0) {
        return (ArticleVersionDto)$tmp0.invoke(p0);
    }
}

