/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.upload;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.server.upload.AbstractImageUploadServlet;
import com.freiheit.toro.server.upload.JsonUploadResult;
import com.freiheit.toro.server.upload.UploadResult;
import com.google.common.base.Optional;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.container.shared.model.GlobalDesignImage;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.server.upload.EntityImageUploadServlet;
import de.justsoftware.onx.server.upload.GlobalImageToThemeAttributeVisitor;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EntityImageUploadServlet
extends AbstractImageUploadServlet {
    private static final String ENTITY_ID_PARAMS = "entityId";
    private static final String TYPE_PARAMS = "type";
    private final ThemeService _legacyThemeService;
    private final de.justsoftware.onx.tenantdesign.ThemeService _themeService;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityImageUploadServlet(Settings settings, StorageServerHelper storageServerHelper, SessionAuthorizationContextProvider authorizationContextProvider, I18nService i18nService, ThemeService legacyThemeService, @Qualifier(value="acceptableImageUploadTypes") Set<String> types, de.justsoftware.onx.tenantdesign.ThemeService themeService) {
        super(settings, storageServerHelper, authorizationContextProvider, i18nService, types);
        this._legacyThemeService = legacyThemeService;
        this._themeService = themeService;
    }

    @RequestMapping(value={"/upload/entity"})
    public ModelAndView handleRequest(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException {
        return super.handleRequest(request, response);
    }

    @Nonnull
    private String saveFileByImageType(@Nonnull MultipartFile file, @Nonnull ImageType imageType, @Nonnull Collection<ImageSize> sizes, boolean squareOfImages) {
        String originalFilename = Objects.requireNonNullElse(file.getOriginalFilename(), file.getName());
        String filename = SecureRandomUtil.randomHex() + this._storageServerHelper.getExtension(originalFilename);
        SaveImageResult saveResult = this._storageServerHelper.saveFileOnStorageServer(file, imageType.getPath(), filename, sizes, squareOfImages);
        if (!saveResult.isOk()) {
            throw new ServiceException("EntityImageUploadServlet: " + saveResult.getMessage());
        }
        return filename;
    }

    private void saveDefaultEntityDesignImages(@Nonnull List<MultipartFile> files, @Nonnull Map<String, String> parameters, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        String type = parameters.get(TYPE_PARAMS);
        GlobalDesignImage image = (GlobalDesignImage)GlobalDesignImage.VALUE_OF_MAP.get(type);
        if (image == null) {
            throw new ServiceException("EntityImageUploadServlet: image type '" + type + "' unknown");
        }
        for (MultipartFile f : files) {
            if (f == null) continue;
            String filename = (String)image.visit((GlobalDesignImage.GlobalDesignImagesVisitor)new SaveGlobalDesignImageVisitor(this, f, "default"));
            Theme defaultTheme = this._themeService.getLegacyTheme(null);
            ThemeAttributeType attributeType = (ThemeAttributeType)((Optional)image.visit((GlobalDesignImage.GlobalDesignImagesVisitor)new GlobalImageToThemeAttributeVisitor())).orNull();
            if (attributeType == null) continue;
            ThemeAttribute imageAttribute = new ThemeAttribute(defaultTheme.getId(), filename, attributeType);
            this._legacyThemeService.setDefaultThemeAttribute(imageAttribute, (AuthorizationCheckContext)authorizationContext);
        }
    }

    protected UploadResult saves(List<MultipartFile> files, AuthorizationCheckContextWithUserId authorizationContext, HashMap<String, String> parameters) {
        try {
            this.saveDefaultEntityDesignImages(files, parameters, authorizationContext);
        }
        catch (ServiceException e) {
            return JsonUploadResult.error((String)e.getMessage());
        }
        return JsonUploadResult.success();
    }

    protected UploadResult returnError(HttpServletRequest request, String message) {
        return JsonUploadResult.error((String)message);
    }
}

