/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.server;

import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.design.client.model.FrontendTheme;
import de.justsoftware.onx.design.shared.ThemeController;
import de.justsoftware.onx.design.shared.model.ITheme;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.WebResource;
import de.justsoftware.onx.tenantdesign.ThemeService;
import de.justsoftware.web.design.WebResourceHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.gwtwidgets.server.spring.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThemeControllerImpl
implements ThemeController {
    @Autowired
    private de.justsoftware.onx.design.business.ThemeService _legacyThemeService;
    @Autowired
    private ThemeService _themeService;
    @Autowired
    private SessionAuthorizationContextProvider _authContextProvider;
    @Autowired
    private WebResourceHandler _webResourceHandler;
    @Autowired
    private ConfigService _configService;

    public FrontendTheme getDefaultTheme() {
        return FrontendTheme.copyOf((ITheme)this._themeService.getLegacyTheme(null));
    }

    public FrontendTheme updateDefaultTheme(FrontendTheme newTheme) throws ServiceException {
        return FrontendTheme.copyOf((ITheme)this._legacyThemeService.updateDefaultTheme((ITheme)newTheme, (AuthorizationCheckContext)this._authContextProvider.getAuthorizationContextForCurrentUser()));
    }

    public HashMap<WebResource, String> getCurrentResourceUris(Set<WebResource> resources) {
        HttpServletRequest request = ServletUtils.getRequest();
        HttpServletResponse response = ServletUtils.getResponse();
        if (request == null || response == null) {
            return new HashMap<WebResource, String>();
        }
        return this._webResourceHandler.getCurrentResourceNames(resources, request, response);
    }

    public Set<ThemeAttributeType> getEditableThemeAttributes() {
        return this._configService.getEditableThemeAttributes().stream().filter(it -> !it.getScope().equals((Object)ThemeAttributeType.Scope.ENTITY_THEME)).filter(it -> !it.getVariableName().equals(ThemeAttributeType.HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR.getVariableName())).collect(Collectors.toSet());
    }

    public FrontendTheme getFactoryDefaultTheme() throws ServiceException {
        return FrontendTheme.copyOf((ITheme)this._legacyThemeService.getFactoryDefaultTheme());
    }
}

