/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.design;

import com.freiheit.toro.common.presentation.ui.ImageUploadDialog;
import com.freiheit.toro.util.client.WidgetUtil;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.UIHtmlPanel;
import de.justsoftware.onx.common.presentation.client.ui.upload.OnUploadHandler;
import de.justsoftware.onx.container.presentation.client.ui.design.ImageAttributeControl;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeAttributeControl;
import de.justsoftware.onx.design.shared.ImageAttributeToStorageServerUrlVisitor;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeAttributeVisitor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageAttributeControl
implements ThemeAttributeControl {
    private static final ImageAttributeControlUIBinder UI_BINDER = (ImageAttributeControlUIBinder)GWT.create(ImageAttributeControlUIBinder.class);
    @UiField
    FocusPanel _imagePickerPanel;
    @UiField
    HTMLPanel _thumbnail;
    @UiField
    InlineLabel _name;
    @UiField
    IconAnchor _deleteIcon;
    @UiField
    IconAnchor _resetIcon;
    private Image _preview = null;
    private ThemeAttributeControl.Presenter _presenter = null;
    private final UIHtmlPanel _container = (UIHtmlPanel)UI_BINDER.createAndBindUi((Object)this);
    private final ImageUploadDialog _dialog;
    private final ThemeAttributeType _type;
    private final String _defaultValue;

    public ImageAttributeControl(@Nonnull ImageUploadDialog dialog, @Nonnull ThemeAttributeType type, @Nullable String defaultValue) {
        this._defaultValue = defaultValue;
        this._dialog = dialog;
        this._type = type;
        this.addClickHandler(event -> {
            RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, URL.encode((String)"/toro/upload/csrftoken"));
            String token = ImageAttributeControl.getJustToken();
            if (token != null && !token.isEmpty()) {
                rb.setHeader("just-token", token);
            }
            try {
                rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (RequestException e) {
                WidgetUtil.showPopUp((int)1, (String)e.getMessage());
            }
        });
        dialog.setOnUploadHandler((OnUploadHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    @CheckForNull
    public static native String getJustToken();

    private void addClickHandler(@Nonnull ClickHandler handler) {
        this._imagePickerPanel.addClickHandler(handler);
        this._name.addClickHandler(handler);
    }

    public void setValue(String value) {
        this._deleteIcon.setVisible(value != null);
        this._resetIcon.setVisible(this._defaultValue != null && !this._defaultValue.equals(value));
        if (this._preview != null) {
            this._preview.removeFromParent();
            this._preview = null;
        }
        if (value != null) {
            String imagePath = (String)this._type.accept((ThemeAttributeVisitor)new ImageAttributeToStorageServerUrlVisitor(value));
            this._preview = new Image(imagePath);
            this._thumbnail.add((Widget)this._preview);
            this._dialog.setImageUrl(imagePath);
        } else {
            this._dialog.setImageUrl(null);
        }
    }

    @UiHandler(value={"_deleteIcon"})
    public void handleDeleteClick(@Nonnull ClickEvent event) {
        if (this._presenter != null) {
            this._presenter.handleAttributeChanged(null);
            this.setValue(null);
        }
    }

    @UiHandler(value={"_resetIcon"})
    public void handleResetClick(@Nonnull ClickEvent event) {
        if (this._presenter != null) {
            this._presenter.handleAttributeChanged(this._defaultValue);
            this.setValue(this._defaultValue);
        }
    }

    public String getValue() {
        return null;
    }

    public void setPresenter(ThemeAttributeControl.Presenter presenter) {
        this._presenter = presenter;
    }

    public Widget asWidget() {
        return this._container;
    }

    public void setName(String name) {
        this._name.setText(name);
        this._name.setTitle(name);
    }
}

