/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.design;

import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.container.presentation.client.ui.design.AbstractThemeEditorPresenter;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeAttributeControl;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeAttributeToThemeEditorSectionVisitor;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeEditorView;
import de.justsoftware.onx.design.client.model.FrontendTheme;
import de.justsoftware.onx.design.client.model.FrontendThemeAttribute;
import de.justsoftware.onx.design.shared.ThemeControllerAsync;
import de.justsoftware.onx.design.shared.model.ITheme;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractThemeEditorPresenter
implements ThemeEditorView.Presenter {
    protected final ThemeControllerAsync _controller;
    protected final ClientFactory _clientFactory;
    protected final ThemeEditorView _view;
    private final HashMap<ThemeAttributeType, ThemeAttributeControl> _controlMap = new HashMap();
    private final ThemeAttributeToThemeEditorSectionVisitor _themeSectionVisitor = new ThemeAttributeToThemeEditorSectionVisitor();
    private FrontendTheme _theme;

    protected AbstractThemeEditorPresenter(ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._controller = this._clientFactory.themeClientFactory().getController();
        this._view = this._clientFactory.themeClientFactory().getDefaultThemeEditorView((ThemeEditorView.Presenter)this);
    }

    @Nonnull
    protected abstract Predicate<ThemeAttributeType> visibleInEditor();

    protected void initView() {
        this._controller.getEditableThemeAttributes((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addControlsToSection(Set<ThemeAttributeType> types, ThemeEditorView.ThemeEditorSection section) {
        Set visibleAttributes = types.stream().filter(this.visibleInEditor()).collect(Collectors.toSet());
        if (visibleAttributes.isEmpty()) {
            this._view.removeControl(section);
        } else {
            List sortedAttributes = visibleAttributes.stream().sorted().collect(Collectors.toList());
            for (ThemeAttributeType type : sortedAttributes) {
                ThemeAttributeControl control = this.initControlForType(type);
                this._controlMap.put(type, control);
                this._view.addControls(section, null, List.of(control));
            }
        }
    }

    protected void init(@Nullable FrontendTheme theme) {
        this._theme = theme;
        if (theme != null) {
            for (FrontendThemeAttribute attribute : theme.getThemeAttributes()) {
                this.updateControlValue((Map)this._controlMap, attribute.getAttributeType(), attribute.getValue());
            }
        }
    }

    protected void initImages(@Nullable FrontendTheme theme) {
        this.initCopy(theme, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initCopy(@Nullable FrontendTheme theme, Predicate<? super FrontendThemeAttribute> copyPredicate) {
        if (theme == null) {
            this.init(null);
        } else {
            LinkedList<FrontendThemeAttribute> replacedAttributes = new LinkedList<FrontendThemeAttribute>();
            for (FrontendThemeAttribute a : this._theme.getThemeAttributes()) {
                if (copyPredicate.test((FrontendThemeAttribute)a)) {
                    FrontendThemeAttribute attribute = theme.getAttribute(a.getAttributeType());
                    if (attribute == null) continue;
                    replacedAttributes.add(attribute);
                    continue;
                }
                replacedAttributes.add(a);
            }
            this.init(FrontendTheme.copyOf((ITheme)this._theme, replacedAttributes));
        }
    }

    protected void initDefaulTheme(@Nullable FrontendTheme theme) {
        this.initCopy(theme, frontendThemeAttribute -> true);
    }

    private void updateControlValue(@Nullable Map<ThemeAttributeType, ThemeAttributeControl> controlMap, ThemeAttributeType type, @Nullable String value) {
        ThemeAttributeControl control;
        if (controlMap != null && (control = controlMap.get(type)) != null) {
            control.setValue(value);
        }
    }

    public void show(HasOneWidget parentWidget) {
        parentWidget.setWidget((IsWidget)this._view);
    }

    public void handleFinish() {
        LoadingDialog dialog = new LoadingDialog();
        dialog.show();
        this.saveTheme(this._theme, (AsyncCallback)new OnThemeUpdatedCallback(this, () -> {
            dialog.hide();
            History.newItem((String)this.getReturnHistoryToken());
        }));
    }

    public void handleCancel() {
        History.newItem((String)this.getReturnHistoryToken());
    }

    @Nonnull
    protected abstract String getReturnHistoryToken();

    protected abstract void saveTheme(FrontendTheme var1, AsyncCallback<FrontendTheme> var2);

    protected abstract void refresh();

    protected abstract void refreshImages();

    @Nonnull
    protected ThemeAttributeControl initControlForType(ThemeAttributeType type) {
        ThemeAttributeControl control = this.getControlForType(type);
        control.setPresenter((ThemeAttributeControl.Presenter)new /* Unavailable Anonymous Inner Class!! */);
        return control;
    }

    @Nonnull
    protected abstract ThemeAttributeControl getControlForType(ThemeAttributeType var1);
}

