/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.account.shared.model.WrongPasswordException;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.model.IllegalEmailException;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.util.client.LoggingUtil;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.i18n.dynamic.shared.model.I18nMessage;
import de.justsoftware.onx.common.shared.i18n.I18nServiceException;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.container.shared.model.ValueEmptyException;
import de.justsoftware.onx.container.shared.model.ValueTooLargeException;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PopupHelper {
    private final LocalizedMessages _localizedMessages;

    public PopupHelper(LocalizedMessages localizedMessages) {
        this._localizedMessages = localizedMessages;
    }

    public void showErrorPopup(Throwable cause) {
        Object msg;
        boolean errorType = true;
        if (cause instanceof PermissionDeniedException) {
            msg = cause.getLocalizedMessage() != null && cause.getLocalizedMessage().length() > 0 ? this._localizedMessages.basicConstants().noPermission() + " (" + cause.getLocalizedMessage() + ")" : this._localizedMessages.basicConstants().noPermission();
        } else if (cause instanceof WrongPasswordException) {
            msg = I18nMediator.EXCEPTION.wrongPasswordSupplied();
        } else if (cause instanceof IncompatibleRemoteServiceException) {
            this.logWithTrace("incompatible remote service", cause);
            msg = I18nMediator.EXCEPTION.incompatibleRemoteService();
        } else if (cause instanceof IllegalEmailException) {
            IllegalEmailException e = (IllegalEmailException)cause;
            msg = I18nMediator.EXCEPTION_MSG.illegalEmail(e.getEmail(), e.getPattern());
        } else if (cause instanceof InvalidIdServiceException) {
            msg = I18nMediator.EXCEPTION.objectDoesntExist();
        } else if (cause instanceof I18nServiceException) {
            msg = I18nMediator.resolveMessage((I18nMessage)((I18nServiceException)cause).getI18nMessage());
        } else if (cause instanceof ValueTooLargeException) {
            msg = I18nMediator.EXCEPTION.valueTooLarge();
        } else if (cause instanceof ValueEmptyException) {
            msg = I18nMediator.EXCEPTION.valueEmpty();
        } else if (cause instanceof ServiceException) {
            this.logWarn("handleFailure", cause);
            msg = I18nMediator.EXCEPTION.serviceException() + "\n" + cause.getMessage();
        } else {
            this.logWarn("handleFailure", cause);
            return;
        }
        WidgetUtil.showPopUp((int)1, (Widget)new HTML((String)msg));
    }

    private void logWarn(String string, Throwable e) {
        LoggingUtil.warn((Object)this, (String)(string + " threw a " + String.valueOf(e) + ": " + e.getMessage()));
    }

    private void logWithTrace(String s, Throwable e) {
        LoggingUtil.error((Object)this, (String)(s + " threw a " + String.valueOf(e) + ": " + e.getMessage()), (Throwable)e);
    }
}

