/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.administration.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.administration.presentation.client.ui.ImportResultWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.migration.shared.i18n.ImportMessages;
import de.justsoftware.onx.migration.shared.model.ImportResult;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ImportResultWidget
extends Composite {
    private static final ImportResultWidgetUIBinder UI_BINDER = (ImportResultWidgetUIBinder)GWT.create(ImportResultWidgetUIBinder.class);
    @UiField
    Label _successMessage;
    @UiField
    Label _processedCount;
    @UiField
    Label _insertedCount;
    @UiField
    Label _updatedCount;
    @UiField
    Label _skippedCount;
    @UiField
    Label _failedCount;
    @UiField
    Label _successfulImportsCount;
    @UiField
    Label _failedImportsCount;
    private final ImportMessages _importMessages = I18nMediator.IMPORT;

    public ImportResultWidget(ImportResult importResult, ClientFactory clientFactory) {
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        DateWithoutTimezone startDate = importResult.getStartDate();
        DateWithoutTimezone endDate = importResult.getEndDate();
        if (endDate == null) {
            this._successMessage.setText(this._importMessages.importFinished());
        } else {
            String endDateFormatted = clientFactory.dateFormatter().formatDateTime((Date)endDate);
            long duration = endDate.getTime() - startDate.getTime();
            this._successMessage.setText(this._importMessages.statisticsSuccessMessage(endDateFormatted, duration));
        }
        this._processedCount.setText("" + importResult.getProcessedCount());
        this._insertedCount.setText("" + importResult.getInsertedCount());
        this._updatedCount.setText("" + importResult.getUpdatedCount());
        this._skippedCount.setText("" + importResult.getSkippedCount());
        this._failedCount.setText("" + importResult.getFailedCount());
        this._successfulImportsCount.setText("" + importResult.getSuccessfulImports());
        this._failedImportsCount.setText("" + importResult.getFailedImports());
    }
}

