/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.requestcollect.server;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.jakarta.RPC;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.gwtwidgets.server.spring.GWTRPCServiceExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCollectorGWTRPCServiceExporter
extends GWTRPCServiceExporter {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RequestCollectorGWTRPCServiceExporter.class);
    private static final ThreadLocal<String> CONTEXT_PATH = new ThreadLocal();
    private transient SerializationPolicyProvider _serializationPolicyProvider = null;

    protected String readContent(HttpServletRequest request) throws ServletException, IOException {
        CONTEXT_PATH.set(request.getContextPath());
        return super.readContent(request);
    }

    public String processCall(String payload) throws SerializationException {
        this.checkPermutationStrongName();
        try {
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, this.getService().getClass(), (SerializationPolicyProvider)this.getOrCreateSerializationPolicy());
            this.onAfterRequestDeserialized(rpcRequest);
            return RPC.invokeAndEncodeResponse((Object)this.getService(), (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy(), (int)rpcRequest.getFlags());
        }
        catch (IncompatibleRemoteServiceException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("An IncompatibleRemoteServiceException was thrown while processing this call.", (Throwable)ex);
            }
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
        catch (RpcTokenException tokenException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("An RpcTokenException was thrown while processing this call.", (Throwable)tokenException);
            }
            return RPC.encodeResponseForFailure(null, (Throwable)tokenException);
        }
    }

    @Nonnull
    private SerializationPolicyProvider getOrCreateSerializationPolicy() {
        if (this._serializationPolicyProvider == null) {
            this._serializationPolicyProvider = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this._serializationPolicyProvider;
    }
}

