/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.requestcollect.server;

import com.google.common.collect.Maps;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.jakarta.RPC;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JucoSerializationPolicyProvider
implements SerializationPolicyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JucoSerializationPolicyProvider.class);
    private final Map<String, SerializationPolicy> _cache = Maps.newConcurrentMap();

    public SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        String cacheKey = moduleBaseURL + strongName;
        SerializationPolicy cachedSerializationPolicy = (SerializationPolicy)this._cache.get(cacheKey);
        if (cachedSerializationPolicy != null) {
            return cachedSerializationPolicy;
        }
        SerializationPolicy serializationPolicy = this.loadSerializationPolicy(moduleBaseURL, strongName);
        this._cache.put(cacheKey, serializationPolicy);
        return serializationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private SerializationPolicy loadSerializationPolicy(@Nullable String moduleBaseURL, @Nonnull String strongName) {
        String modulePath = JucoSerializationPolicyProvider.getModulePath((String)moduleBaseURL);
        String contextPath = this.getContextPath();
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            LOG.error("The module path requested, {}, is not in the same web application as this servlet, {}. Your module may not be properly configured or your client and server code maybe out of date.", (Object)modulePath, (Object)contextPath);
            return JucoSerializationPolicyProvider.defaultSerializationPolicy((String)moduleBaseURL, (String)strongName);
        }
        String contextRelativePath = modulePath.substring(contextPath.length());
        String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName((String)(contextRelativePath + strongName));
        InputStream is = this.getSerializationPolicyInputStream(serializationPolicyFilePath);
        if (is == null) {
            LOG.error("The serialization policy file '{}' was not found; did you forget to include it in this deployment?", (Object)serializationPolicyFilePath);
            return JucoSerializationPolicyProvider.defaultSerializationPolicy((String)moduleBaseURL, (String)strongName);
        }
        try {
            SerializationPolicy serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)is, null);
            if (serializationPolicy != null) {
                SerializationPolicy serializationPolicy2 = serializationPolicy;
                return serializationPolicy2;
            }
        }
        catch (ParseException e) {
            LOG.error("Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return JucoSerializationPolicyProvider.defaultSerializationPolicy((String)moduleBaseURL, (String)strongName);
    }

    @Nonnull
    protected abstract String getContextPath();

    @CheckForNull
    protected abstract InputStream getSerializationPolicyInputStream(@Nonnull String var1);

    @Nonnull
    private static SerializationPolicy defaultSerializationPolicy(@Nullable String moduleBaseURL, @Nonnull String strongName) {
        LOG.warn("Failed to get the SerializationPolicy '{}' for module '{}'; a legacy, 1.3.3 compatible, serialization policy will be used. You may experience SerializationExceptions as a result.", (Object)strongName, (Object)moduleBaseURL);
        return RPC.getDefaultSerializationPolicy();
    }

    @CheckForNull
    private static String getModulePath(@Nullable String moduleBaseURL) {
        if (moduleBaseURL == null) {
            return null;
        }
        try {
            return new URL(moduleBaseURL).getPath();
        }
        catch (MalformedURLException ex) {
            LOG.error("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            return null;
        }
    }
}

