/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.presentation.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.AbstractImageUploadHtmlWidget;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageUploadHtmlWidget
extends AbstractImageUploadHtmlWidget {
    private static final BasicConstants BASIC = I18nMediator.BASIC;
    private final HorizontalPanel _imageUploadContainer = new HorizontalPanel();
    private Image _image;
    private final Panel _imagePanel = new FlowPanel();
    private VerticalPanel _previewImageTable = new VerticalPanel();
    private final VerticalPanel _uploadPictureTable = new VerticalPanel();
    private final Label _currentPictureLabel = new Label(BASIC.currentPicture());
    private final Label _uploadPictureLabel = new Label(BASIC.uploadPictures());
    private final FlowPanel _headerPanel = new FlowPanel();
    private final JCButton _uploadButton;
    private final Panel _removePanel = new VerticalPanel();
    private final JCButton _removePictureButton = new JCButton(BASIC.removePicture());
    private final Label _bottomText = new Label();
    private final FlowPanel _legalAgreementPanel = new FlowPanel();
    private final int _fileCount;
    private final String _imageUrl;
    private boolean _previewImageWidthIsFixed = false;
    private final Integer _width;
    private final boolean _showPreviewImage;

    public ImageUploadHtmlWidget(@Nullable String imageUrl, @Nonnull String uploadService, @Nonnull Supplier<? extends Map<String, String>> uploadParameters, @Nullable String removePictureButtonText, @Nullable Integer width, int fileCount, boolean showPreviewImage) {
        super(uploadService, uploadParameters);
        if (removePictureButtonText != null) {
            this.setRemovePictureButtonText(removePictureButtonText);
        }
        this._fileCount = fileCount;
        this._width = width;
        this._imageUrl = imageUrl;
        this._uploadButton = this.newUploadButton();
        this._showPreviewImage = showPreviewImage;
        this.initGUI();
        this.initWidget((Widget)this._imageUploadContainer);
    }

    public Panel getHeaderPanel() {
        return this._headerPanel;
    }

    public void setRemovePictureButtonText(String text) {
        this._removePictureButton.setText(text);
    }

    public void setImageUrl(String url) {
        if (url != null) {
            this._imagePanel.clear();
            this._image = new Image(url);
            if (this._width != null) {
                this._image.setWidth(this._width + "px");
            }
            this._imagePanel.add((Widget)this._image);
            this._currentPictureLabel.setVisible(true);
            if (this._previewImageWidthIsFixed) {
                this._image.removeStyleName("gwt-Image");
            }
        } else {
            this._image.setVisible(false);
            this._currentPictureLabel.setVisible(false);
        }
        this._imageUploadContainer.setStyleName("no-image", url == null);
    }

    public void setImageWidget(@Nonnull Widget imageWidget) {
        this._imagePanel.clear();
        this._imagePanel.add(imageWidget);
        this._currentPictureLabel.setVisible(true);
    }

    private void initGUI() {
        if (this._showPreviewImage) {
            if (this._imageUrl != null) {
                this._image = new Image(this._imageUrl);
                this._image.setWidth(this._width + "px");
                this._currentPictureLabel.setVisible(true);
                if (this._previewImageWidthIsFixed) {
                    this._image.removeStyleName("gwt-Image");
                }
            } else {
                this._image = new Image();
                this._image.setVisible(false);
                this._currentPictureLabel.setVisible(false);
            }
            this._previewImageTable = new VerticalPanel();
            this._previewImageTable.add((Widget)this._currentPictureLabel);
            this._previewImageTable.add((Widget)this._imagePanel);
            this._imagePanel.add((Widget)this._image);
            this._previewImageTable.addStyleName("previewImageTable");
            this._imageUploadContainer.add((Widget)this._previewImageTable);
        }
        this._uploadPictureTable.add((Widget)this._uploadPictureLabel);
        this._uploadPictureTable.add((Widget)this._headerPanel);
        this._uploadPictureTable.add((Widget)this._legalAgreementPanel);
        for (int i = 0; i < this._fileCount; ++i) {
            this._uploadPictureTable.add((Widget)this.newFileUploadForm());
        }
        this._bottomText.setVisible(false);
        this._uploadPictureTable.add((Widget)this._uploadButton);
        this._uploadPictureTable.add((Widget)this._bottomText);
        Label removeHead = new Label(BASIC.removePicture());
        Label removeDescript = new Label(BASIC.removeProfilePicture());
        removeHead.setStyleName("heading");
        this._removePanel.add((Widget)new HTML("&nbsp;"));
        this._removePanel.add((Widget)removeHead);
        this._removePanel.add((Widget)removeDescript);
        this._removePanel.add((Widget)this._removePictureButton);
        this._uploadPictureTable.add((Widget)this._removePanel);
        this._imageUploadContainer.add((Widget)this._uploadPictureTable);
        this._imageUploadContainer.setStyleName("imageUploadContainer");
        this._imageUploadContainer.setStyleName("no-image", !this._showPreviewImage);
        this._currentPictureLabel.setStyleName("heading");
        this._uploadPictureLabel.setStyleName("heading");
        this._uploadPictureTable.setStyleName("uploadPanel");
        this._uploadButton.addStyleName("deactivatedInput");
        this._uploadButton.addStyleName("upload-button");
        this._bottomText.addStyleName("upload-bottom-text");
        this._removePanel.addStyleName("remove-panel");
        this._removePictureButton.addStyleName("remove-button");
    }

    public void addRemovePictureClickHandler(ClickHandler listener) {
        this._removePictureButton.addClickHandler(listener);
    }

    public void showRemoveClickButton(boolean show) {
        this._removePanel.setVisible(show);
    }

    public void setCaption(String caption, String button) {
        this._uploadPictureLabel.setText(caption);
        this._uploadButton.setText(button);
    }

    public void setOriginalImageWidth(boolean originalWidth) {
        this._previewImageWidthIsFixed = originalWidth;
    }

    public void setImageTitle(String imageTitle) {
        this._currentPictureLabel.setText(imageTitle);
    }

    public void setBottomText(String bottomText) {
        this._bottomText.setText(bottomText);
        this._bottomText.setVisible(true);
    }

    public void setAddButtonEnabled(boolean enabled) {
        this._uploadButton.setEnabled(enabled);
        this.setUploadFormHandlerEnabled(enabled);
    }

    public FlowPanel getLegalAgreementPanel() {
        return this._legalAgreementPanel;
    }

    public void addCancelClickHandler(String text, ClickHandler clickHandler) {
    }
}

