/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.presentation.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.AbstractImageUploadHtmlWidget;
import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FormPanel;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.upload.HasCancelButton;
import de.justsoftware.onx.common.presentation.client.ui.upload.OnUploadHandler;
import de.justsoftware.onx.common.shared.model.HostPropertiesBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class AbstractImageUploadHtmlWidget
extends Composite
implements OnUploadHandler.HasOnUploadHandler,
HasCancelButton {
    private static final BasicConstants BASIC = I18nMediator.BASIC;
    private static final Set<String> ALLOWED_TYPE = Set.of("jpg", "jpe", "jpeg", "jfif", "jfif-tbnl", "gif", "png");
    private final String _uploadService;
    private final List<FileUploadAndForm> _fileUploads = new ArrayList();
    private int _currentSubmitCount = 0;
    private int _status = 2;
    private String _resultMessages = "";
    private final LoadingDialog _loadingDialog = new LoadingDialog();
    private boolean _showMessagePopUpAfterUpdateComplete = true;
    private OnUploadHandler _onUploadHandler;
    private final Supplier<? extends Map<String, String>> _uploadParameters;

    public AbstractImageUploadHtmlWidget(String uploadService, Supplier<? extends Map<String, String>> uploadParameters) {
        this._uploadService = uploadService;
        this._uploadParameters = uploadParameters;
    }

    protected FormPanel newFileUploadForm() {
        FormPanel formPanel = new FormPanel();
        formPanel.setAction(this._uploadService);
        formPanel.setEncoding("multipart/form-data");
        formPanel.setMethod("post");
        FileUploadAndForm fileUploadAndForm = new FileUploadAndForm(formPanel);
        ImageUploadFormHandler imageUploadFormHandler = new ImageUploadFormHandler(this, fileUploadAndForm);
        formPanel.addSubmitHandler((FormPanel.SubmitHandler)imageUploadFormHandler);
        formPanel.addSubmitCompleteHandler((FormPanel.SubmitCompleteHandler)imageUploadFormHandler);
        this._fileUploads.add(fileUploadAndForm);
        return formPanel;
    }

    public JCButton newUploadButton() {
        JCButton b = new JCButton(BASIC.uploadPictures());
        b.addClickHandler((ClickHandler)new UploadClickHandler(this));
        return b;
    }

    private boolean validateTyp(String typ) {
        return ALLOWED_TYPE.contains(typ.toLowerCase());
    }

    private boolean isAgbSelected() {
        return true;
    }

    public void setShowMessagePopUpAfterUpdateComplete(boolean showMessagePopUpAfterUpdateComplete) {
        this._showMessagePopUpAfterUpdateComplete = showMessagePopUpAfterUpdateComplete;
    }

    public void setOnUploadHandler(OnUploadHandler onUploadHandler) {
        this._onUploadHandler = onUploadHandler;
    }

    public void setUploadFormHandlerEnabled(boolean enabled) {
        for (FileUploadAndForm fileUploadAndForm : this._fileUploads) {
            fileUploadAndForm._fileUpload.setEnabled(enabled);
        }
    }

    public static String getYouCanUploadPictureType() {
        HostPropertiesBean bean = HostPropertiesMediator.getHostPropertiesBean();
        double maxSize = bean.getMaxImageSize().doubleValue();
        int dimensions = bean.getMaxImageDimensions();
        return "JPG, PNG oder GIF Dateien werden unterst\u00fctzt. (maximal " + NumberFormat.getFormat((String)"0.#").format(maxSize / 1024.0 / 1024.0) + " MB) \nMaximale Abma\u00dfe: " + dimensions + " x " + dimensions + " px.";
    }
}

