/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.client.mediator;

import com.freiheit.toro.client.event.HistoryChangedEvent;
import com.freiheit.toro.client.event.HistoryWidgetCreatedEvent;
import com.freiheit.toro.client.mediator.HistoryHandlerForToken;
import com.freiheit.toro.client.mediator.HistoryInterceptor;
import com.freiheit.toro.client.mediator.HistoryItemHandler;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.client.mediator.HistoryTokenAndHandler;
import com.freiheit.toro.client.mediator.HistoryTokenState;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.client.ui.FourOhFourWidget;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.web.bindery.event.shared.HandlerRegistration;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.TokenUtilClient;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class HistoryManager
implements ValueChangeHandler<String> {
    private final ClientFactory _clientFactory;
    private String _currentOriginalToken;
    private final SimplePanel _panel = new SimplePanel();
    private PageTitleCallback _currentPageTitleCallback = null;
    private final HistoryHandlerForToken _historyHandlerForToken;
    private HistoryInterceptor _historyInterceptor = null;
    private HistoryTokenState _currentState = null;
    private final ArrayList<ConfirmHistoryChangeCallback> _confirmHistoryChangeCallbacks = new ArrayList();

    public HistoryManager(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._historyHandlerForToken = new HistoryHandlerForToken(clientFactory);
        this._panel.addStyleName("history-manager-panel");
        Window.addWindowClosingHandler((Window.ClosingHandler)new HistoryManagerWindowClosingHandler(this));
    }

    public SimplePanel getPanel() {
        return this._panel;
    }

    public void setWidget(IsWidget widget, @Nullable HistoryTokenState state) {
        this.getPanel().setWidget(widget);
        this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryWidgetCreatedEvent.INSTANCE);
    }

    @Nonnull
    protected String createHistoryItemInternal(@Nonnull HistoryToken tokenId, @CheckForNull Object[] params, @CheckForNull Object[] defaultParams) {
        return this.createHistoryItemInternal(tokenId, this.historyItemHandlerForToken(tokenId).getParamTypes(), params, defaultParams);
    }

    private void checkParamsType(@Nonnull HistoryToken tokenId, @Nonnull String tokenTypes, @CheckForNull Object[] params) throws IllegalArgumentException {
        if (params == null) {
            return;
        }
        if (params.length > tokenTypes.length()) {
            throw new IllegalArgumentException("Expected no more than " + tokenTypes.length() + " parameters, but got " + params.length + " while creating HistoryItem for ID " + String.valueOf(tokenId));
        }
        block5: for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null) continue;
            switch (tokenTypes.charAt(i)) {
                case 'L': {
                    if (param instanceof Long || param instanceof LongId) continue block5;
                    throw new IllegalArgumentException("Parameter at index " + i + " has to be a long");
                }
                case 'B': {
                    if (param instanceof Boolean) continue block5;
                    throw new IllegalArgumentException("Parameter at index " + i + " has to be a Boolean");
                }
                case 'S': {
                    if (param instanceof String) continue block5;
                    throw new IllegalArgumentException("Parameter at index " + i + " has to be a String");
                }
                default: {
                    throw new IllegalArgumentException("Unknown type identifier: " + tokenTypes.charAt(i));
                }
            }
        }
    }

    @Nonnull
    protected String createHistoryItemInternal(@Nonnull HistoryToken tokenId, @Nonnull String tokenTypes, @Nullable Object[] params, @Nullable Object[] defaultParams) {
        this.checkParamsType(tokenId, tokenTypes, params);
        return TokenUtilClient.createTokenWithDefaultParams((HistoryToken)tokenId, (String)tokenTypes, (Object[])params, (Object[])defaultParams);
    }

    @Nonnull
    public String createHistoryItem(@Nonnull HistoryToken token, Object ... params) {
        return this.createHistoryItemInternal(token, params);
    }

    @Nonnull
    private String createHistoryItemInternal(@Nonnull HistoryToken token, @Nonnull Object[] params) {
        return this.createHistoryItemInternal(token, params, null);
    }

    public Hyperlink createLink(@Nonnull String text, boolean asHtml, @Nonnull HistoryToken token, Object ... params) {
        return this.createLinkInternal(text, asHtml, token, params);
    }

    private Hyperlink createLinkInternal(@Nonnull String text, boolean asHtml, @Nonnull HistoryToken token, @Nonnull Object[] params) {
        return new Hyperlink(text, asHtml, this.createHistoryItemInternal(token, params));
    }

    public Hyperlink createLinkInternal(@Nonnull String text, @Nonnull HistoryToken token, @Nonnull Object[] params) {
        return this.createLinkInternal(text, false, token, params);
    }

    @Deprecated
    public ClickHandler createNewItemHandler(@Nonnull String historyItem) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Deprecated
    public ClickHandler createNewItemHandler(@Nonnull HistoryToken token, Object ... param) {
        return this.createNewItemHandler(this.createHistoryItemInternal(token, param));
    }

    private void setCurrentTitle(@Nonnull String title) {
        this._clientFactory.pageTitleService().setPageTitle(title);
    }

    public void ignoreNextHistoryChange() {
        HistoryInterceptor last = this._historyInterceptor;
        this._historyInterceptor = new /* Unavailable Anonymous Inner Class!! */;
    }

    @CheckForNull
    private String createHistoryChangeQuestion() {
        for (ConfirmHistoryChangeCallback callback : this._confirmHistoryChangeCallbacks) {
            if (!callback.confirmNeeded()) continue;
            return this._clientFactory.localizedMessages().basicConstants().confirmProceedWithUnsavedChanges();
        }
        return null;
    }

    public HandlerRegistration confirmNextHistoryChange(ConfirmHistoryChangeCallback callback) {
        this._confirmHistoryChangeCallbacks.add(callback);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void cleanupConfirmHistoryChangeListener() {
        this._confirmHistoryChangeCallbacks.clear();
    }

    private ConfirmPopup createConfirmLeavePagePopup(String historyToken, String question) {
        BasicConstants basicConstants = this._clientFactory.localizedMessages().basicConstants();
        4 onLeave = new /* Unavailable Anonymous Inner Class!! */;
        5 onStay = new /* Unavailable Anonymous Inner Class!! */;
        return ConfirmPopup.makeConfirmPopup((String)question, (ClickHandler)onLeave, (ClickHandler)onStay, (String)basicConstants.leavePage(), (String)basicConstants.stayOnPage());
    }

    public void onHistoryChanged(String historyToken) {
        boolean tokenHasNotChanged;
        String previousOriginalToken = this._currentOriginalToken;
        this._currentOriginalToken = historyToken;
        String fixedToken = HistoryManager.fixEscapedExclamationMarks((String)this._currentOriginalToken);
        History.replaceItem((String)fixedToken, (boolean)false);
        String tokenWithoutQueryParameters = HistoryManager.removeQueryParameters((String)fixedToken);
        boolean tokenHasQueryParameters = this._currentOriginalToken.indexOf(63) != -1;
        boolean previousTokenHasQueryParameters = previousOriginalToken != null && previousOriginalToken.indexOf(63) != -1;
        boolean bl = tokenHasNotChanged = this._currentState != null && tokenWithoutQueryParameters.equals(this._currentState.getHistoryItem());
        if ((tokenHasQueryParameters || previousTokenHasQueryParameters) && tokenHasNotChanged) {
            return;
        }
        try {
            this.handleNewHistoryToken(tokenWithoutQueryParameters);
        }
        catch (RuntimeException e) {
            LoggingUtil.error((Object)this, (String)"Fehler im HistoryItemHandler, zeige 404", (Throwable)e);
            try {
                this.setWidget((IsWidget)new FourOhFourWidget(this._clientFactory, (Throwable)e), null);
            }
            catch (RuntimeException e2) {
                LoggingUtil.error((Object)this, (String)"OHA! Auch das 404 wirft eine Exception. Wir machen gar nichts und verschlucken die Exception", (Throwable)e2);
            }
            this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryChangedEvent.INSTANCE);
        }
    }

    static String removeQueryParameters(String historyToken) {
        int indexOfQuestionMark = historyToken.indexOf(63);
        boolean hasQueryParameters = indexOfQuestionMark != -1;
        String tokenWithoutQueryParameters = hasQueryParameters ? historyToken.substring(0, indexOfQuestionMark) : historyToken;
        return tokenWithoutQueryParameters;
    }

    static String fixEscapedExclamationMarks(String historyToken) {
        boolean tokenStartsWithAnEscapedExclamationMark = historyToken.startsWith("%21");
        boolean tokenStartsWithAnEscapedExclamationMarkAndASlash = historyToken.startsWith("/%21");
        if (tokenStartsWithAnEscapedExclamationMark) {
            return "!" + historyToken.substring(3);
        }
        if (tokenStartsWithAnEscapedExclamationMarkAndASlash) {
            return "/!" + historyToken.substring(4);
        }
        return historyToken;
    }

    @Nonnull
    private static String removeLeadingSlash(@Nonnull String historyToken) {
        if (historyToken.startsWith("/")) {
            return historyToken.substring(1);
        }
        return historyToken;
    }

    private void handleNewHistoryToken(String historyToken) {
        boolean isLocalAnchor;
        boolean bl = isLocalAnchor = historyToken.startsWith(".") || historyToken.startsWith("/.");
        if (!isLocalAnchor) {
            this.onHistoryChangedCall(historyToken);
        } else if (this._currentState != null) {
            String historyItem = this._currentState.getHistoryItem();
            String token = HistoryManager.appendOrReplaceHash((String)historyItem, (String)HistoryManager.removeLeadingSlash((String)historyToken));
            History.replaceItem((String)token, (boolean)false);
            this.onHistoryChangedCall(token);
        } else {
            this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryChangedEvent.INSTANCE);
        }
    }

    static String appendOrReplaceHash(String historyItem, String hash) {
        int hashIndex = historyItem.indexOf(35);
        String token = hashIndex > -1 ? historyItem.substring(0, hashIndex) : historyItem;
        return token + "#" + hash;
    }

    private void onHistoryChangedCall(String historyToken) {
        String question = this.createHistoryChangeQuestion();
        if (!StringUtil.isBlank((String)question)) {
            this.createConfirmLeavePagePopup(historyToken, question).show();
            return;
        }
        this.cleanupConfirmHistoryChangeListener();
        this.newHistoryTokenState(historyToken, this._currentState, newHistoryTokenState -> {
            boolean renderPage;
            this._currentState = newHistoryTokenState;
            boolean bl = renderPage = this._historyInterceptor == null || this._historyInterceptor.onHistoryChanged(historyToken);
            if (renderPage) {
                if (newHistoryTokenState == null) {
                    this.show404Page();
                } else {
                    this.onHistoryChangedImpl(newHistoryTokenState);
                }
            }
            this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryChangedEvent.INSTANCE);
        });
    }

    public void newHistoryTokenState(@Nonnull String historyItem, @Nullable HistoryTokenState previousState, Consumer<HistoryTokenState> callback) {
        try {
            HistoryTokenAndHandler tokenAndHandler = this.getTokenAndHandlerForHistoryItem(historyItem);
            if (tokenAndHandler == null) {
                callback.accept(null);
                return;
            }
            HistoryItemHandler handler = tokenAndHandler.getHandler();
            TokenUtil.TokenIdAndParams tokenIdAndParams = tokenAndHandler.getToken();
            callback.accept(new HistoryTokenState(historyItem, tokenIdAndParams, handler, previousState));
        }
        catch (RuntimeException e) {
            callback.accept(null);
        }
    }

    @CheckForNull
    public HistoryTokenAndHandler getTokenAndHandlerForHistoryItem(@Nonnull String historyItem) {
        try {
            HistoryTokenParser parsed = TokenUtilClient.INSTANCE.parse(historyItem);
            HistoryToken tokenId = parsed.getToken();
            if (tokenId == null) {
                return null;
            }
            HistoryItemHandler handler = this.historyItemHandlerForToken(tokenId);
            TokenUtil.TokenIdAndParams tokenIdAndParams = parsed.resolveTypedParams(handler.getParamTypes(), handler.getDefaultParams());
            return new HistoryTokenAndHandler(tokenIdAndParams, handler);
        }
        catch (TokenUtil.TokenParseException | RuntimeException e) {
            return null;
        }
    }

    private void onHistoryChangedImpl(HistoryTokenState state) {
        this.fullyLoad(state);
    }

    void fullyLoad(HistoryTokenState state) {
        PutWidgetInstance callback = new PutWidgetInstance(this, state);
        try {
            6 titleCallback = new /* Unavailable Anonymous Inner Class!! */;
            this._currentPageTitleCallback = titleCallback;
            state.getHandler().createWidget(this._clientFactory, state, (HistoryItemHandler.WidgetCreatedCallback)callback, (PageTitleCallback)titleCallback);
        }
        catch (RuntimeException e) {
            callback.onCreationFailed((Throwable)e);
        }
    }

    private void show404Page() {
        this.setWidget((IsWidget)new FourOhFourWidget(this._clientFactory), null);
        String pageTitle = I18nMediator.BASIC_CONSTANTS.pageTitle404();
        this.setCurrentTitle(pageTitle);
    }

    @CheckForNull
    public IsWidget getCurrentWidget() {
        return this.getPanel().getWidget();
    }

    @Nonnull
    private HistoryItemHandler historyItemHandlerForToken(HistoryToken token) {
        return (HistoryItemHandler)this._historyHandlerForToken.get((Object)token);
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.onHistoryChanged((String)event.getValue());
    }

    @Nonnull
    private native void replaceMostRecentHashForDeprecatedLink(String var1, String var2);
}

