/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.account.presentation.server;

import com.freiheit.toro.account.presentation.client.LoginController;
import com.freiheit.toro.account.shared.model.LoginInfoBean;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginControllerImpl
implements LoginController {
    private static final ImmutableSet<Action> CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.ADMIN_MODIFY_DEFAULT_DESIGN);
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;

    public LoginInfoBean checkForSession() throws ServiceException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        PersonId userId = auth.getUserId();
        LoginInfoBean loginInfo = new LoginInfoBean();
        DBPerson person = this._personService.getPersonByIdNotNull(userId);
        loginInfo.setPerson(this._profileTeaserService.getPersonTeaserModelByDBPerson(person, (AuthorizationCheckContextWithLocale)auth));
        loginInfo.setMay(this.getCheckedActions(auth));
        return loginInfo;
    }

    private HashSet<Action> getCheckedActions(AuthorizationContext auth) {
        return new HashSet<Action>((Collection<Action>)auth.may(CHECK_ACTIONS));
    }
}

