/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.translation;

import de.justsoftware.news.id.ItemId;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/news/domain/translation/TranslationRepo;", "", "jdbcTemplate", "Lorg/springframework/jdbc/core/JdbcTemplate;", "<init>", "(Lorg/springframework/jdbc/core/JdbcTemplate;)V", "insertTranslations", "", "itemId", "Lde/justsoftware/news/id/ItemId;", "language", "", "fieldIdToText", "", "deleteTranslations", "getTranslations", "news-service"})
@SourceDebugExtension(value={"SMAP\nTranslationRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationRepo.kt\nde/justsoftware/news/domain/translation/TranslationRepo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1563#2:46\n1634#2,3:47\n1193#2,2:50\n1267#2,4:52\n*S KotlinDebug\n*F\n+ 1 TranslationRepo.kt\nde/justsoftware/news/domain/translation/TranslationRepo\n*L\n22#1:46\n22#1:47,3\n41#1:50,2\n41#1:52,4\n*E\n"})
public class TranslationRepo {
    @NotNull
    private final JdbcTemplate jdbcTemplate;

    public TranslationRepo(@NotNull JdbcTemplate jdbcTemplate) {
        Intrinsics.checkNotNullParameter((Object)jdbcTemplate, (String)"jdbcTemplate");
        this.jdbcTemplate = jdbcTemplate;
    }

    /*
     * WARNING - void declaration
     */
    public void insertTranslations(@NotNull ItemId itemId, @NotNull String language, @NotNull Map<String, String> fieldIdToText) {
        Collection<String[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(fieldIdToText, (String)"fieldIdToText");
        Iterable iterable = MapsKt.toList(fieldIdToText);
        String string = "INSERT INTO translation (item_id, field_id, language, text) VALUES (?, ?, ?, ?) ON CONFLICT DO NOTHING";
        JdbcTemplate jdbcTemplate = this.jdbcTemplate;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String fieldId = (String)pair.component1();
            String text = (String)pair.component2();
            String[] stringArray = new String[]{itemId.toTypedString(), fieldId, language, text};
            collection.add(stringArray);
        }
        collection = (List)destination$iv$iv;
        jdbcTemplate.batchUpdate(string, (List)collection);
    }

    public void deleteTranslations(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Object[] objectArray = new Object[]{itemId.toTypedString()};
        this.jdbcTemplate.update("DELETE FROM translation WHERE item_id = ?", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, String> getTranslations(@NotNull ItemId itemId, @NotNull String language) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object[] objectArray = new Object[]{itemId.toTypedString(), language};
        List list = this.jdbcTemplate.query("SELECT field_id, text FROM translation WHERE item_id = ? AND language = ?", TranslationRepo::getTranslations$lambda$1, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query(...)");
        List items = list;
        Iterable $this$associate$iv = items;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = it;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Pair getTranslations$lambda$1(ResultSet rst, int rowNumber) {
        Intrinsics.checkNotNullParameter((Object)rst, (String)"rst");
        return TuplesKt.to((Object)rst.getString("field_id"), (Object)rst.getString("text"));
    }
}

