/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.reaction;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.reaction.ItemDataLoader;
import de.justsoftware.news.domain.reaction.LikeDataLoader;
import de.justsoftware.news.domain.reaction.LikedDataLoader;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionDataFetcherKt;
import de.justsoftware.news.domain.reaction.ReactionService;
import de.justsoftware.news.domain.reaction.TotalLikeDataLoader;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.generated.types.Like;
import de.justsoftware.news.graphql.generated.types.LikeableItem;
import de.justsoftware.news.graphql.generated.types.Likes;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.id.LikeableId;
import de.justsoftware.news.id.ProfileId;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00190\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/news/domain/reaction/ReactionDataFetcher;", "", "reactionService", "Lde/justsoftware/news/domain/reaction/ReactionService;", "<init>", "(Lde/justsoftware/news/domain/reaction/ReactionService;)V", "likes", "Lgraphql/execution/DataFetcherResult;", "Lde/justsoftware/news/graphql/generated/types/Likes;", "itemId", "Lde/justsoftware/news/id/LikeableId;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "addLike", "Lde/justsoftware/news/graphql/generated/types/Like;", "removeLike", "profileOnReactions", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/news/graphql/generated/types/Profile;", "profileOnLikes", "itemOnLike", "Lde/justsoftware/news/graphql/generated/types/LikeableItem;", "total", "", "data", "", "liked", "", "news-service"})
public class ReactionDataFetcher {
    @NotNull
    private final ReactionService reactionService;

    public ReactionDataFetcher(@NotNull ReactionService reactionService) {
        Intrinsics.checkNotNullParameter((Object)reactionService, (String)"reactionService");
        this.reactionService = reactionService;
    }

    @DgsQuery(field="likes")
    @NotNull
    public DataFetcherResult<Likes> likes(@InputArgument @NotNull LikeableId itemId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        this.reactionService.likes(itemId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        DataFetcherResult dataFetcherResult = DataFetcherResult.newResult().data((Object)new Likes(null, null, null, 7, null)).localContext((Object)itemId).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherResult, (String)"build(...)");
        return dataFetcherResult;
    }

    @DgsMutation(field="addLike")
    @NotNull
    public Like addLike(@InputArgument @NotNull LikeableId itemId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ReactionDataFetcherKt.toLikeGql((Reaction)this.reactionService.addLike(itemId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="removeLike")
    @Nullable
    public Like removeLike(@InputArgument @NotNull LikeableId itemId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Reaction reaction = this.reactionService.deleteLike(itemId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return reaction != null ? ReactionDataFetcherKt.toLikeGql((Reaction)reaction) : null;
    }

    @DgsData(parentType="Reaction", field="profile")
    @NotNull
    public CompletableFuture<Profile> profileOnReactions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId profileId = ((de.justsoftware.news.graphql.generated.types.Reaction)dfe.getSourceOrThrow()).getProfileId();
        CompletableFuture completableFuture = dataLoader.load((Object)profileId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Like", field="profile")
    @NotNull
    public CompletableFuture<Profile> profileOnLikes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId profileId = ((Like)dfe.getSourceOrThrow()).getProfileId();
        CompletableFuture completableFuture = dataLoader.load((Object)profileId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Like", field="item")
    @NotNull
    public CompletableFuture<LikeableItem> itemOnLike(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ItemDataLoader.class);
        LikeableId itemId = ((Like)dfe.getSourceOrThrow()).getItemId();
        CompletableFuture completableFuture = dataLoader.load((Object)itemId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Likes", field="total")
    @NotNull
    public CompletableFuture<Integer> total(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(TotalLikeDataLoader.class);
        LikeableId itemId = (LikeableId)dfe.getLocalContext();
        CompletableFuture completableFuture = dataLoader.load((Object)itemId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Likes", field="data")
    @NotNull
    public CompletableFuture<List<Like>> data(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(LikeDataLoader.class);
        LikeableId itemId = (LikeableId)dfe.getLocalContext();
        CompletableFuture completableFuture = dataLoader.load((Object)itemId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Likes", field="liked")
    @NotNull
    public CompletableFuture<Boolean> liked(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(LikedDataLoader.class);
        LikeableId itemId = (LikeableId)dfe.getLocalContext();
        CompletableFuture completableFuture = dataLoader.load((Object)itemId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }
}

