/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.attachment.AttachmentDataLoaderKt;
import de.justsoftware.news.domain.attachment.AttachmentsInput;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostDataFetcherKt;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.graphql.generated.types.AddPollInput;
import de.justsoftware.news.graphql.generated.types.AddPostInput;
import de.justsoftware.news.graphql.generated.types.EventInput;
import de.justsoftware.news.graphql.generated.types.UpdatePostInput;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.util.DateUtilsKt;
import graphql.schema.DataFetchingEnvironment;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010\u0014\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00152\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u001a\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/news/domain/post/PostMutations;", "", "postService", "Lde/justsoftware/news/domain/post/PostService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "<init>", "(Lde/justsoftware/news/domain/post/PostService;Lde/justsoftware/news/domain/delete/DeleteService;)V", "getPostService", "()Lde/justsoftware/news/domain/post/PostService;", "getDeleteService", "()Lde/justsoftware/news/domain/delete/DeleteService;", "addPost", "Lde/justsoftware/news/graphql/generated/types/Post;", "input", "Lde/justsoftware/news/graphql/generated/types/AddPostInput;", "targetLanguage", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "updatePost", "Lde/justsoftware/news/graphql/generated/types/UpdatePostInput;", "deletePost", "Lde/justsoftware/news/id/PostId;", "id", "news-service"})
public class PostMutations {
    @NotNull
    private final PostService postService;
    @NotNull
    private final DeleteService deleteService;

    public PostMutations(@NotNull PostService postService, @NotNull DeleteService deleteService) {
        Intrinsics.checkNotNullParameter((Object)postService, (String)"postService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        this.postService = postService;
        this.deleteService = deleteService;
    }

    @NotNull
    public PostService getPostService() {
        return this.postService;
    }

    @NotNull
    public DeleteService getDeleteService() {
        return this.deleteService;
    }

    @DgsMutation(field="addPost")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Post addPost(@InputArgument @NotNull AddPostInput input, @InputArgument @Nullable String targetLanguage, @NotNull DgsDataFetchingEnvironment dfe) {
        List list;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = PostId.Companion.random();
        AddPollInput addPollInput = input.getPoll();
        Poll poll = addPollInput != null ? PostDataFetcherKt.toPollDomain((AddPollInput)addPollInput, (PostId)postId) : null;
        PostService postService = this.getPostService();
        ChannelId channelId = input.getChannelId();
        String string = input.getTitle();
        String string2 = input.getText();
        String string3 = input.getJsonContent();
        de.justsoftware.news.graphql.generated.types.AttachmentsInput attachmentsInput = input.getAttachments();
        Object object = attachmentsInput != null ? AttachmentDataLoaderKt.toDomain((de.justsoftware.news.graphql.generated.types.AttachmentsInput)attachmentsInput) : null;
        EventInput eventInput = input.getEvent();
        Object object2 = eventInput != null ? PostDataFetcherKt.toDomain((EventInput)eventInput, (PostId)postId) : null;
        Long l = input.getPinExpiration();
        Instant instant = l != null ? DateUtilsKt.toInstant((long)l) : null;
        AddPollInput addPollInput2 = input.getPoll();
        if (addPollInput2 != null) {
            Poll poll2 = poll;
            list = PostDataFetcherKt.toPollAnswerDomain((AddPollInput)addPollInput2, (PollId)(poll2 != null ? poll2.getId() : null), (AddPollInput)input.getPoll());
        } else {
            list = null;
        }
        Long l2 = input.getPublishDate();
        Long l3 = input.getDeleteDate();
        return PostDataFetcherKt.toGql((Post)PostService.create$default((PostService)postService, (ChannelId)channelId, (String)string, (String)string2, (String)string3, (PostId)postId, (AttachmentsInput)object, (Event)object2, (Instant)instant, (Poll)poll, (List)list, (Instant)(l2 != null ? DateUtilsKt.toInstant((long)l2) : null), (Instant)(l3 != null ? DateUtilsKt.toInstant((long)l3) : null), (Boolean)input.getCommentsDisabled(), (boolean)false, null, (String)targetLanguage, (AuthorizationContext)((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)), (int)24576, null));
    }

    @DgsMutation(field="updatePost")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Post updatePost(@InputArgument @NotNull UpdatePostInput input, @InputArgument @Nullable String targetLanguage, @NotNull DgsDataFetchingEnvironment dfe) {
        List list;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AddPollInput addPollInput = input.getPoll();
        Poll poll = addPollInput != null ? PostDataFetcherKt.toPollDomain((AddPollInput)addPollInput, (PostId)input.getId()) : null;
        PostService postService = this.getPostService();
        PostId postId = input.getId();
        String string = input.getTitle();
        String string2 = input.getText();
        String string3 = input.getJsonContent();
        de.justsoftware.news.graphql.generated.types.AttachmentsInput attachmentsInput = input.getAttachments();
        AttachmentsInput attachmentsInput2 = attachmentsInput != null ? AttachmentDataLoaderKt.toDomain((de.justsoftware.news.graphql.generated.types.AttachmentsInput)attachmentsInput) : null;
        EventInput eventInput = input.getEvent();
        Event event = eventInput != null ? PostDataFetcherKt.toDomain((EventInput)eventInput, (PostId)input.getId()) : null;
        Boolean bl = input.getPin();
        Long l = input.getPinExpiration();
        Instant instant = l != null ? DateUtilsKt.toInstant((long)l) : null;
        AddPollInput addPollInput2 = input.getPoll();
        if (addPollInput2 != null) {
            Poll poll2 = poll;
            list = PostDataFetcherKt.toPollAnswerDomain((AddPollInput)addPollInput2, (PollId)(poll2 != null ? poll2.getId() : null), (AddPollInput)input.getPoll());
        } else {
            list = null;
        }
        List list2 = list;
        Boolean bl2 = input.getDeletePoll();
        Long l2 = input.getPublishDate();
        Instant instant2 = l2 != null ? DateUtilsKt.toInstant((long)l2) : null;
        Boolean bl3 = input.getPublished();
        Instant instant3 = DateUtilsKt.toInstant((long)input.getLastKnownModifyDate());
        Long l3 = input.getDeleteDate();
        Instant instant4 = l3 != null ? DateUtilsKt.toInstant((long)l3) : null;
        Boolean bl4 = input.getRemoveDeleteDate();
        Boolean bl5 = input.getCommentsDisabled();
        AuthorizationContext authorizationContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return PostDataFetcherKt.toGql((Post)postService.update(postId, instant3, string, string2, string3, attachmentsInput2, event, bl, instant, poll, list2, bl2, instant2, bl3, instant4, bl4, bl5, targetLanguage, authorizationContext));
    }

    @DgsMutation(field="deletePost")
    @NotNull
    public PostId deletePost(@InputArgument @NotNull PostId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.getDeleteService().markPostForDeletion(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }
}

