/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.deepl.DeepLConnector;
import de.justsoftware.news.connector.deepl.TranslationResult;
import de.justsoftware.news.connector.superoperty.SuperopertyConnector;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollTranslationService;
import de.justsoftware.news.domain.tenant.Tenant;
import de.justsoftware.news.domain.tenant.TenantService;
import de.justsoftware.news.domain.translation.TranslationRepo;
import de.justsoftware.news.domain.translation.model.TranslationContext;
import de.justsoftware.news.domain.translation.model.TranslationContextKt;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J7\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J,\u0010\f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J7\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0012\u00a2\u0006\u0004\b\u0018\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/domain/poll/PollTranslationService;", "", "superopertyConnector", "Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;", "tenantService", "Lde/justsoftware/news/domain/tenant/TenantService;", "deepLConnector", "Lde/justsoftware/news/connector/deepl/DeepLConnector;", "translationRepo", "Lde/justsoftware/news/domain/translation/TranslationRepo;", "<init>", "(Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;Lde/justsoftware/news/domain/tenant/TenantService;Lde/justsoftware/news/connector/deepl/DeepLConnector;Lde/justsoftware/news/domain/translation/TranslationRepo;)V", "translate", "Lde/justsoftware/news/domain/poll/Poll;", "poll", "sourceLanguage", "", "targetLanguage", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "doTranslate", "Lkotlin/Result;", "tenantId", "Lde/justsoftware/news/id/TenantId;", "doTranslate-BWLJW6A", "(Lde/justsoftware/news/domain/poll/Poll;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/id/TenantId;)Ljava/lang/Object;", "Lde/justsoftware/news/domain/poll/PollAnswer;", "answer", "(Lde/justsoftware/news/domain/poll/PollAnswer;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/id/TenantId;)Ljava/lang/Object;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPollTranslationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollTranslationService.kt\nde/justsoftware/news/domain/poll/PollTranslationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public class PollTranslationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final DeepLConnector deepLConnector;
    @NotNull
    private final TranslationRepo translationRepo;
    @NotNull
    private static final Logger log;

    public PollTranslationService(@NotNull SuperopertyConnector superopertyConnector, @NotNull TenantService tenantService, @NotNull DeepLConnector deepLConnector, @NotNull TranslationRepo translationRepo) {
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)deepLConnector, (String)"deepLConnector");
        Intrinsics.checkNotNullParameter((Object)translationRepo, (String)"translationRepo");
        this.superopertyConnector = superopertyConnector;
        this.tenantService = tenantService;
        this.deepLConnector = deepLConnector;
        this.translationRepo = translationRepo;
    }

    @Transactional
    @NotNull
    public Poll translate(@NotNull Poll poll, @Nullable String sourceLanguage, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        Poll poll2;
        Intrinsics.checkNotNullParameter((Object)poll, (String)"poll");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (targetLanguage != null && !Intrinsics.areEqual((Object)targetLanguage, (Object)sourceLanguage) && this.superopertyConnector.getBackendTranslationEnabled()) {
            Object object;
            Object object2 = this.doTranslate-BWLJW6A(poll, sourceLanguage, targetLanguage, authContext.getTenantId());
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                TranslationContextKt.logTranslationException((Logger)log, (Throwable)it);
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 == null) {
                object = object2;
            } else {
                Throwable it = throwable3;
                boolean bl = false;
                object = Poll.copy$default((Poll)poll, null, null, (boolean)false, null, null, (TranslationContext)TranslationContextKt.untranslatedWithError((Object)poll, (String)sourceLanguage, (String)targetLanguage, (Throwable)it), (int)31, null);
            }
            poll2 = (Poll)object;
        } else {
            poll2 = Poll.copy$default((Poll)poll, null, null, (boolean)false, null, null, (TranslationContext)TranslationContextKt.untranslated((Object)poll, (String)sourceLanguage, (String)targetLanguage), (int)31, null);
        }
        return poll2;
    }

    private Object doTranslate-BWLJW6A(Poll poll, String sourceLanguage, String targetLanguage, TenantId tenantId) {
        Object object;
        PollTranslationService pollTranslationService = this;
        try {
            Poll poll2;
            PollTranslationService $this$doTranslate_BWLJW6A_u24lambda_u242 = pollTranslationService;
            boolean bl = false;
            Map existingTranslations = $this$doTranslate_BWLJW6A_u24lambda_u242.translationRepo.getTranslations((ItemId)poll.getId(), targetLanguage);
            if (!existingTranslations.isEmpty()) {
                String string = (String)existingTranslations.get("question");
                if (string == null) {
                    string = poll.getQuestion();
                }
                poll2 = Poll.copy$default((Poll)poll, null, (String)string, (boolean)false, null, null, (TranslationContext)TranslationContextKt.translated((Object)poll, (String)sourceLanguage, (String)targetLanguage), (int)29, null);
            } else {
                String deepLApiKey;
                Tenant tenant = $this$doTranslate_BWLJW6A_u24lambda_u242.tenantService.findById(tenantId);
                String string = deepLApiKey = tenant != null ? tenant.getDeeplKey() : null;
                if (deepLApiKey == null) {
                    poll2 = Poll.copy$default((Poll)poll, null, null, (boolean)false, null, null, (TranslationContext)TranslationContextKt.untranslated((Object)poll, (String)sourceLanguage, (String)targetLanguage), (int)31, null);
                } else {
                    TranslationResult translatedQuestionResult = $this$doTranslate_BWLJW6A_u24lambda_u242.deepLConnector.translateText(poll.getQuestion(), sourceLanguage, targetLanguage, deepLApiKey);
                    String string2 = translatedQuestionResult.getDetectedSourceLanguage().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    String detectedSourceLanguage = string2;
                    if (!Intrinsics.areEqual((Object)detectedSourceLanguage, (Object)targetLanguage)) {
                        $this$doTranslate_BWLJW6A_u24lambda_u242.translationRepo.insertTranslations((ItemId)poll.getId(), targetLanguage, MapsKt.mapOf((Pair)TuplesKt.to((Object)"question", (Object)translatedQuestionResult.getText())));
                        String string3 = translatedQuestionResult.getText();
                        String string4 = sourceLanguage;
                        if (string4 == null) {
                            string4 = detectedSourceLanguage;
                        }
                        poll2 = Poll.copy$default((Poll)poll, null, (String)string3, (boolean)false, null, null, (TranslationContext)TranslationContextKt.translated((Object)poll, (String)string4, (String)targetLanguage), (int)29, null);
                    } else {
                        String string5 = sourceLanguage;
                        if (string5 == null) {
                            string5 = detectedSourceLanguage;
                        }
                        poll2 = Poll.copy$default((Poll)poll, null, null, (boolean)false, null, null, (TranslationContext)TranslationContextKt.untranslated((Object)poll, (String)string5, (String)targetLanguage), (int)31, null);
                    }
                }
            }
            object = Result.constructor-impl((Object)poll2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @Transactional
    @NotNull
    public PollAnswer translate(@NotNull PollAnswer answer, @Nullable String sourceLanguage, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        PollAnswer pollAnswer;
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (targetLanguage != null && !Intrinsics.areEqual((Object)targetLanguage, (Object)sourceLanguage) && this.superopertyConnector.getBackendTranslationEnabled()) {
            Object object;
            Object object2 = this.doTranslate-BWLJW6A(answer, sourceLanguage, targetLanguage, authContext.getTenantId());
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                TranslationContextKt.logTranslationException((Logger)log, (Throwable)it);
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 == null) {
                object = object2;
            } else {
                Throwable it = throwable3;
                boolean bl = false;
                object = PollAnswer.copy$default((PollAnswer)answer, null, null, (int)0, null, (TranslationContext)TranslationContextKt.untranslatedWithError((Object)answer, (String)sourceLanguage, (String)targetLanguage, (Throwable)it), (int)15, null);
            }
            pollAnswer = (PollAnswer)object;
        } else {
            pollAnswer = PollAnswer.copy$default((PollAnswer)answer, null, null, (int)0, null, (TranslationContext)TranslationContextKt.untranslated((Object)answer, (String)sourceLanguage, (String)targetLanguage), (int)15, null);
        }
        return pollAnswer;
    }

    private Object doTranslate-BWLJW6A(PollAnswer answer, String sourceLanguage, String targetLanguage, TenantId tenantId) {
        Object object;
        PollTranslationService pollTranslationService = this;
        try {
            PollAnswer pollAnswer;
            PollTranslationService $this$doTranslate_BWLJW6A_u24lambda_u245 = pollTranslationService;
            boolean bl = false;
            Map existingTranslations = $this$doTranslate_BWLJW6A_u24lambda_u245.translationRepo.getTranslations((ItemId)answer.getId(), targetLanguage);
            if (!existingTranslations.isEmpty()) {
                String string = (String)existingTranslations.get("text");
                if (string == null) {
                    string = answer.getText();
                }
                pollAnswer = PollAnswer.copy$default((PollAnswer)answer, null, null, (int)0, (String)string, (TranslationContext)TranslationContextKt.translated((Object)answer, (String)sourceLanguage, (String)targetLanguage), (int)7, null);
            } else {
                String deepLApiKey;
                Tenant tenant = $this$doTranslate_BWLJW6A_u24lambda_u245.tenantService.findById(tenantId);
                String string = deepLApiKey = tenant != null ? tenant.getDeeplKey() : null;
                if (deepLApiKey == null) {
                    pollAnswer = PollAnswer.copy$default((PollAnswer)answer, null, null, (int)0, null, (TranslationContext)TranslationContextKt.untranslated((Object)answer, (String)sourceLanguage, (String)targetLanguage), (int)15, null);
                } else {
                    TranslationResult translatedTextResult = $this$doTranslate_BWLJW6A_u24lambda_u245.deepLConnector.translateText(answer.getText(), sourceLanguage, targetLanguage, deepLApiKey);
                    String string2 = translatedTextResult.getDetectedSourceLanguage().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    String detectedSourceLanguage = string2;
                    if (!Intrinsics.areEqual((Object)detectedSourceLanguage, (Object)targetLanguage)) {
                        $this$doTranslate_BWLJW6A_u24lambda_u245.translationRepo.insertTranslations((ItemId)answer.getId(), targetLanguage, MapsKt.mapOf((Pair)TuplesKt.to((Object)"text", (Object)translatedTextResult.getText())));
                        String string3 = translatedTextResult.getText();
                        String string4 = sourceLanguage;
                        if (string4 == null) {
                            string4 = detectedSourceLanguage;
                        }
                        pollAnswer = PollAnswer.copy$default((PollAnswer)answer, null, null, (int)0, (String)string3, (TranslationContext)TranslationContextKt.translated((Object)answer, (String)string4, (String)targetLanguage), (int)7, null);
                    } else {
                        String string5 = sourceLanguage;
                        if (string5 == null) {
                            string5 = detectedSourceLanguage;
                        }
                        pollAnswer = PollAnswer.copy$default((PollAnswer)answer, null, null, (int)0, null, (TranslationContext)TranslationContextKt.untranslated((Object)answer, (String)string5, (String)targetLanguage), (int)15, null);
                    }
                }
            }
            object = Result.constructor-impl((Object)pollAnswer);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    static {
        Logger logger = LoggerFactory.getLogger(PollTranslationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

