/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.event;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.event.EventRepo;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.id.EventId;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.UidGenerator;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/domain/event/EventService;", "", "eventRepo", "Lde/justsoftware/news/domain/event/EventRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "<init>", "(Lde/justsoftware/news/domain/event/EventRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "exportIcs", "", "eventId", "Lde/justsoftware/news/id/EventId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class EventService {
    @NotNull
    private final EventRepo eventRepo;
    @NotNull
    private final PostRepo postRepo;

    public EventService(@NotNull EventRepo eventRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)eventRepo, (String)"eventRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.eventRepo = eventRepo;
        this.postRepo = postRepo;
    }

    @NotNull
    public String exportIcs(@NotNull EventId eventId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Event event = this.eventRepo.getById(eventId);
        authContext.checkPostAction(event.getPostId(), PostAction.EVENT_ICS_EXPORT);
        String summary = this.postRepo.getByIdAndDeletedFalse(event.getPostId()).getTitle();
        Component component = new VEvent((Temporal)event.getStartDate(), (Temporal)event.getEndDate(), summary).withProperty((Property)((UidGenerator)() -> EventService.exportIcs$lambda$0(event)).generateUid()).getFluentTarget();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type net.fortuna.ical4j.model.component.VEvent");
        VEvent vEvent = (VEvent)component;
        Duration minutesBeforeEventToStartAlarm = Duration.ofMinutes(-15L);
        Component component2 = new VAlarm((TemporalAmount)minutesBeforeEventToStartAlarm).withProperty((Property)new Action("DISPLAY")).withProperty((Property)new Description("Reminder")).getFluentTarget();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type net.fortuna.ical4j.model.component.VAlarm");
        VAlarm vAlarm = (VAlarm)component2;
        vEvent.setComponentList(new ComponentList(CollectionsKt.listOf((Object)vAlarm)));
        String string = new Calendar().withProdId("-//Just Software AG//Just Social//EN").withDefaults().withComponent((CalendarComponent)vEvent).getFluentTarget().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final Uid exportIcs$lambda$0(Event $event) {
        return new Uid($event.getId().toTypedString());
    }
}

