/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.delete;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.drive.DriveKafkaProducer;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.connector.superoperty.SuperopertyConnector;
import de.justsoftware.news.domain.attachment.AttachmentRepo;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentAction;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.post.unreadmark.PostUnreadMarkRepo;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.events.ChannelDeletedEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.DriveFileReferenceId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Observed
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\b\u0010\"\u001a\u00020#H\u0017J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0017J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010'\u001a\u00020(H\u0017J\u0018\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u00020!2\u0006\u0010.\u001a\u00020-H\u0012J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u0010'\u001a\u00020(H\u0017J\u0018\u00103\u001a\u00020#2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020!H\u0012J\b\u00104\u001a\u00020#H\u0017J\u001e\u00104\u001a\u00020#2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010/\u001a\u00020!H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lde/justsoftware/news/domain/delete/DeleteService;", "", "attachmentRepo", "Lde/justsoftware/news/domain/attachment/AttachmentRepo;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "driveKafkaProducer", "Lde/justsoftware/news/connector/drive/DriveKafkaProducer;", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "superopertyConnector", "Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;", "postUnreadMarkRepo", "Lde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkRepo;", "<init>", "(Lde/justsoftware/news/domain/attachment/AttachmentRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/connector/drive/DriveKafkaProducer;Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/reaction/ReactionRepo;Lde/justsoftware/news/util/TransactionSupport;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;Lde/justsoftware/news/domain/post/unreadmark/PostUnreadMarkRepo;)V", "systemUser", "Lde/justsoftware/news/id/ProfileId;", "delete", "", "markCommentAsDeleted", "Lde/justsoftware/news/id/CommentId;", "commentId", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "markAllChannelsAsDeleted", "tenantId", "Lde/justsoftware/news/id/TenantId;", "markChannelAsDeleted", "Lde/justsoftware/news/id/ChannelId;", "channelId", "user", "markPostForDeletion", "Lde/justsoftware/news/id/PostId;", "postId", "markPostsForDeletionByChannel", "markPostsForDeletion", "posts", "", "Lde/justsoftware/news/domain/post/Post;", "news-service"})
@SourceDebugExtension(value={"SMAP\nDeleteService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteService.kt\nde/justsoftware/news/domain/delete/DeleteService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1563#2:199\n1634#2,3:200\n1869#2,2:204\n1563#2:206\n1634#2,3:207\n1563#2:210\n1634#2,3:211\n1563#2:214\n1634#2,3:215\n1869#2,2:218\n1#3:203\n*S KotlinDebug\n*F\n+ 1 DeleteService.kt\nde/justsoftware/news/domain/delete/DeleteService\n*L\n85#1:199\n85#1:200,3\n121#1:204,2\n138#1:206\n138#1:207,3\n178#1:210\n178#1:211,3\n183#1:214\n183#1:215,3\n191#1:218,2\n*E\n"})
public class DeleteService {
    @NotNull
    private final AttachmentRepo attachmentRepo;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final DriveKafkaProducer driveKafkaProducer;
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ReactionRepo reactionRepo;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final PostUnreadMarkRepo postUnreadMarkRepo;
    @NotNull
    private final ProfileId systemUser;

    public DeleteService(@NotNull AttachmentRepo attachmentRepo, @NotNull PostCommentRepo commentRepo, @NotNull ChannelRepo channelRepo, @NotNull DriveKafkaProducer driveKafkaProducer, @NotNull PersonalSubscriptionRepo personalSubscriptionRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PostRepo postRepo, @NotNull ReactionRepo reactionRepo, @NotNull TransactionSupport transactionSupport, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull ApplicationEventPublisher eventPublisher, @NotNull SuperopertyConnector superopertyConnector, @NotNull PostUnreadMarkRepo postUnreadMarkRepo) {
        Intrinsics.checkNotNullParameter((Object)attachmentRepo, (String)"attachmentRepo");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)driveKafkaProducer, (String)"driveKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)postUnreadMarkRepo, (String)"postUnreadMarkRepo");
        this.attachmentRepo = attachmentRepo;
        this.commentRepo = commentRepo;
        this.channelRepo = channelRepo;
        this.driveKafkaProducer = driveKafkaProducer;
        this.personalSubscriptionRepo = personalSubscriptionRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.channelPermissionRepo = channelPermissionRepo;
        this.postRepo = postRepo;
        this.reactionRepo = reactionRepo;
        this.transactionSupport = transactionSupport;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.eventPublisher = eventPublisher;
        this.superopertyConnector = superopertyConnector;
        this.postUnreadMarkRepo = postUnreadMarkRepo;
        this.systemUser = ProfileId.Companion.fromValue(-1L);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void delete() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Instant deleteOlderThan = Instant.now().minus(this.superopertyConnector.getDeletionDelay());
        Intrinsics.checkNotNull((Object)deleteOlderThan);
        Set it = this.commentRepo.getMarkedAsDeleted(deleteOlderThan);
        boolean bl = false;
        this.attachmentRepo.deleteByItemIdIn((Collection)it);
        Set postIds = this.postRepo.findMarkedAsDeleted(deleteOlderThan);
        boolean bl2 = false;
        Iterable iterable = this.commentRepo.findAllByParentIdInOrderByCreatedAtDesc((Collection)postIds);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void comment;
            PostComment postComment = (PostComment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(comment.getId());
        }
        List commentIds = (List)destination$iv$iv;
        boolean bl4 = false;
        this.attachmentRepo.deleteByItemIdIn((Collection)commentIds);
        this.attachmentRepo.deleteByItemIdIn((Collection)postIds);
        this.reactionRepo.deleteByItemIdsIn((Collection)postIds);
        this.postRepo.deleteAllById((Iterable)postIds);
        this.channelRepo.deleteMarked(deleteOlderThan);
    }

    @NotNull
    public CommentId markCommentAsDeleted(@NotNull CommentId commentId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.commentRepo.findById((Object)commentId).ifPresent(arg_0 -> DeleteService.markCommentAsDeleted$lambda$5(arg_0 -> DeleteService.markCommentAsDeleted$lambda$4(this, authContext, arg_0), arg_0));
        return commentId;
    }

    @Unauthorized
    @Transactional
    public void markAllChannelsAsDeleted(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Set channelIds = this.channelRepo.getIdsByTenant(tenantId);
        Iterable $this$forEach$iv = channelIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChannelId it = (ChannelId)element$iv;
            boolean bl = false;
            this.markChannelAsDeleted(this.systemUser, it);
        }
    }

    @Transactional
    @NotNull
    public ChannelId markChannelAsDeleted(@NotNull ChannelId channelId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(channelId, ChannelAction.DELETE);
        return this.markChannelAsDeleted(authContext.getUser(), channelId);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelId markChannelAsDeleted(ProfileId user, ChannelId channelId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.channelRepo.updateDeleted(channelId, true, user, instant);
        this.personalSubscriptionRepo.deleteByChannelId(channelId);
        this.managedSubscriptionRepo.deleteByChannelId(channelId);
        this.markPostsForDeletionByChannel(channelId, user);
        Iterable iterable = this.channelPermissionRepo.findAllByChannelId(channelId);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelPermission channelPermission = (ChannelPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PermissionItem((ItemId)it.getId(), it.getGranteeId(), it.getRole()));
        }
        List channelPermissions = (List)destination$iv$iv;
        this.transactionSupport.afterCommit(() -> DeleteService.markChannelAsDeleted$lambda$8(this, channelId, channelPermissions));
        return channelId;
    }

    @Transactional
    @NotNull
    public PostId markPostForDeletion(@NotNull PostId postId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.postRepo.findById((Object)postId).ifPresent(arg_0 -> DeleteService.markPostForDeletion$lambda$10(arg_0 -> DeleteService.markPostForDeletion$lambda$9(authContext, this, arg_0), arg_0));
        return postId;
    }

    private void markPostsForDeletionByChannel(ChannelId channelId, ProfileId user) {
        Collection collection = this.postRepo.findByChannelIdAndDeletedFalse(channelId);
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        Set posts2 = (Set)collection;
        this.markPostsForDeletion((Collection)posts2, user);
    }

    @Unauthorized
    public void markPostsForDeletion() {
        Set it = PostRepo.findByDeletedFalseAndDeleteDateLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean bl = false;
        this.markPostsForDeletion((Collection)it, this.systemUser);
    }

    /*
     * WARNING - void declaration
     */
    private void markPostsForDeletion(Collection<Post> posts2, ProfileId user) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (posts2.isEmpty()) {
            return;
        }
        Set uniquePosts = CollectionsKt.toSet((Iterable)posts2);
        Iterable $this$map$iv = uniquePosts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Post post = (Post)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set postIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.postRepo.updateDeletedByIds(postIds, true, user, instant);
        this.postUnreadMarkRepo.deleteByPostIdIn((Collection)postIds);
        Iterable $this$map$iv2 = uniquePosts;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post bl = (Post)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void it2 = it;
            boolean bl3 = false;
            collection.add(new PermissionItem((ItemId)it2.getId(), (UserId)it2.getAuthorId(), PermissionRole.MANAGER));
        }
        List postPermissions = (List)destination$iv$iv2;
        this.transactionSupport.afterCommit(() -> DeleteService.markPostsForDeletion$lambda$17(this, postIds, postPermissions));
    }

    private static final Unit markCommentAsDeleted$lambda$4(DeleteService this$0, AuthorizationContext $authContext, PostComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Post post = this$0.postRepo.getByIdAndDeletedFalse(comment.getPostId());
        $authContext.checkPostCommentAction(post.getChannelId(), comment, PostCommentAction.DELETE);
        PostCommentRepo postCommentRepo = this$0.commentRepo;
        CommentId commentId = comment.getId();
        ProfileId profileId = $authContext.getUser();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        postCommentRepo.markCommentAsDeleted(commentId, profileId, instant);
        this$0.driveKafkaProducer.deleteAllAttachments((DriveFileReferenceId)comment.getId());
        this$0.permissionKafkaProducer.deleteItem((ItemId)comment.getId());
        List permissions = CollectionsKt.listOf((Object)new PermissionItem((ItemId)comment.getId(), (UserId)comment.getAuthorId(), PermissionRole.MANAGER));
        this$0.permissionKafkaProducer.deletePermissions(permissions);
        return Unit.INSTANCE;
    }

    private static final void markCommentAsDeleted$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit markChannelAsDeleted$lambda$8(DeleteService this$0, ChannelId $channelId, List $channelPermissions) {
        KafkaPublishOperation[] kafkaPublishOperationArray = new KafkaPublishOperation[]{this$0.permissionKafkaProducer.deleteItem((ItemId)$channelId), this$0.permissionKafkaProducer.deletePermissions($channelPermissions)};
        KafkaPublishOperation.waitForCompletion$default((KafkaPublishOperation)new KafkaPublishOperation(kafkaPublishOperationArray), null, (int)1, null);
        this$0.eventPublisher.publishEvent((ApplicationEvent)new ChannelDeletedEvent($channelId, SetsKt.emptySet()));
        return Unit.INSTANCE;
    }

    private static final Unit markPostForDeletion$lambda$9(AuthorizationContext $authContext, DeleteService this$0, Post it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $authContext.checkPostAction(it.getId(), PostAction.DELETE);
        this$0.markPostsForDeletion((Collection)SetsKt.setOf((Object)it), $authContext.getUser());
        return Unit.INSTANCE;
    }

    private static final void markPostForDeletion$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit markPostsForDeletion$lambda$17(DeleteService this$0, Set $postIds, List $postPermissions) {
        KafkaPublishOperation[] kafkaPublishOperationArray = new KafkaPublishOperation[]{this$0.permissionKafkaProducer.deleteItems($postIds), this$0.permissionKafkaProducer.deletePermissions($postPermissions)};
        KafkaPublishOperation.waitForCompletion$default((KafkaPublishOperation)new KafkaPublishOperation(kafkaPublishOperationArray), null, (int)1, null);
        Iterable $this$forEach$iv = $postIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PostId it = (PostId)element$iv;
            boolean bl = false;
            this$0.driveKafkaProducer.deleteAllAttachments((DriveFileReferenceId)it);
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostDeletedEvent(it));
        }
        return Unit.INSTANCE;
    }
}

