/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel.permission;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelDataFetcherKt;
import de.justsoftware.news.domain.channel.ChannelDataLoader;
import de.justsoftware.news.domain.channel.ChannelService;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionDataFetcherKt;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionService;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionDataFetcherKt;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionService;
import de.justsoftware.news.domain.user.UserDataLoader;
import de.justsoftware.news.graphql.generated.types.ChannelPermission;
import de.justsoftware.news.graphql.generated.types.UpdateChannelPermissionsInput;
import de.justsoftware.news.graphql.generated.types.UpdateManagedSubscriptionsInput;
import de.justsoftware.news.graphql.generated.types.User;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.UserId;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.annotation.Transactional;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/news/domain/channel/permission/ChannelPermissionDataFetcher;", "", "channelService", "Lde/justsoftware/news/domain/channel/ChannelService;", "channelPermissionService", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionService;", "managedSubscriptionService", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionService;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelService;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionService;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionService;)V", "updateChannelPermissions", "Lde/justsoftware/news/graphql/generated/types/Channel;", "permissionsInput", "Lde/justsoftware/news/graphql/generated/types/UpdateChannelPermissionsInput;", "subscriptionsInput", "Lde/justsoftware/news/graphql/generated/types/UpdateManagedSubscriptionsInput;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "channel", "Ljava/util/concurrent/CompletableFuture;", "", "grantee", "Lde/justsoftware/news/graphql/generated/types/User;", "news-service"})
public class ChannelPermissionDataFetcher {
    @NotNull
    private final ChannelService channelService;
    @NotNull
    private final ChannelPermissionService channelPermissionService;
    @NotNull
    private final ManagedSubscriptionService managedSubscriptionService;

    public ChannelPermissionDataFetcher(@NotNull ChannelService channelService, @NotNull ChannelPermissionService channelPermissionService, @NotNull ManagedSubscriptionService managedSubscriptionService) {
        Intrinsics.checkNotNullParameter((Object)channelService, (String)"channelService");
        Intrinsics.checkNotNullParameter((Object)channelPermissionService, (String)"channelPermissionService");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionService, (String)"managedSubscriptionService");
        this.channelService = channelService;
        this.channelPermissionService = channelPermissionService;
        this.managedSubscriptionService = managedSubscriptionService;
    }

    @Transactional
    @DgsMutation(field="updateChannelPermissions")
    @Nullable
    public de.justsoftware.news.graphql.generated.types.Channel updateChannelPermissions(@InputArgument @NotNull UpdateChannelPermissionsInput permissionsInput, @InputArgument @Nullable UpdateManagedSubscriptionsInput subscriptionsInput, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)permissionsInput, (String)"permissionsInput");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        UpdateManagedSubscriptionsInput updateManagedSubscriptionsInput = subscriptionsInput;
        if (updateManagedSubscriptionsInput != null) {
            UpdateManagedSubscriptionsInput it = updateManagedSubscriptionsInput;
            boolean bl = false;
            this.managedSubscriptionService.update(ManagedSubscriptionDataFetcherKt.toDomain((UpdateManagedSubscriptionsInput)it), authContext);
        }
        this.channelPermissionService.update(ChannelPermissionDataFetcherKt.access$toDomain((UpdateChannelPermissionsInput)permissionsInput), authContext);
        if (!authContext.mayRead((ItemId)permissionsInput.getChannelId())) {
            return null;
        }
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(permissionsInput.getChannelId(), authContext));
    }

    @DgsData(parentType="ChannelPermission", field="channel")
    @NotNull
    public CompletableFuture<List<de.justsoftware.news.graphql.generated.types.Channel>> channel(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ChannelDataLoader.class);
        ChannelId channelId = ((ChannelPermission)dfe.getSourceOrThrow()).getChannelId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="ChannelPermission", field="grantee")
    @NotNull
    public CompletableFuture<List<User>> grantee(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(UserDataLoader.class);
        String granteeId = ((ChannelPermission)dfe.getSourceOrThrow()).getGranteeId();
        CompletableFuture completableFuture = dataLoader.load((Object)UserId.Companion.fromString(granteeId));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }
}

