/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.local.AbsenceInformation;
import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceNoteData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceStatusData;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiBirthdayList;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiBirthdayProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfileSearchResults;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfiles;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiSearchType;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroupDetails;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroups;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$disableBirthdayReminderForProfile$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$enableBirthdayReminderForProfile$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getAbsenceForProfiles$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getProfile$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getProfiles$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getUserGroup$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$updateAbsenceNote$;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010\f\u001a\u00020\u0003H\u0016J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0012J\"\u0010+\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\"\u0010,\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\u0010\u0010-\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0003H\u0012J \u0010.\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J \u0010/\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\u0010\u00100\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0012J\u0010\u00101\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0012J\u0010\u00102\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0012J\"\u00103\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "", "peopleApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "absenceForProfilesUri", "Ljava/net/URI;", "getProfile", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiProfile;", "profileId", "getProfiles", "", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiUserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "getBirthdayProfiles", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiBirthdayProfile;", "currentDate", "getAbsenceForProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/local/AbsenceInformation;", "profileIds", "", "updateAbsenceNote", "updateAbsenceNoteData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceNoteData;", "updateAbsenceStatus", "updateAbsenceStatusData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceStatusData;", "enableBirthdayReminderForProfile", "", "disableBirthdayReminderForProfile", "suggestProfiles", "profileUri", "profilesUri", "userGroupsUri", "userGroupDetailsUri", "userGroupMembersUri", "birthdayProfileUri", "updateAbsenceNoteUri", "updateAbsenceStatusUri", "updateBirthdayReminderForProfileUri", "suggestProfilesUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,210:1\n48#2:211\n48#2:212\n48#2:213\n48#2:214\n48#2:215\n48#2:216\n60#2:217\n60#2:218\n60#2:219\n57#2:220\n91#2:221\n48#2:222\n*S KotlinDebug\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n*L\n33#1:211\n41#1:212\n56#1:213\n67#1:214\n76#1:215\n91#1:216\n101#1:217\n110#1:218\n119#1:219\n125#1:220\n128#1:221\n131#1:222\n*E\n"})
public class PeopleApiGatewayService {
    @NotNull
    private final String peopleApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI absenceForProfilesUri;

    public PeopleApiGatewayService(@Value(value="${just.people.api.url}") @NotNull String peopleApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)peopleApiUrl, (String)"peopleApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.peopleApiUrl = peopleApiUrl;
        this.webClient = webClient;
        this.absenceForProfilesUri = UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/absence"), null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PeopleApiProfile getProfile(@NotNull String profileId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.profileUri(profileId);
        boolean $i$f$get = false;
        return (PeopleApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getProfile$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getProfiles(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.profilesUri(query, offset, limit);
        boolean $i$f$get = false;
        return PeopleApiProfile.Companion.toApiProfiles((PeopleApiProfileSearchResults)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getProfiles$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiUserGroup> getUserGroups(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupsUri(query, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroups)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PeopleApiUserGroup getUserGroup(@NotNull String groupId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.userGroupDetailsUri(groupId);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroupDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getUserGroup$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null)).getUserGroup();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupMembersUri(groupId, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiProfiles)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiBirthdayProfile> getBirthdayProfiles(@NotNull String currentDate, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        WebClient webClient = this.webClient;
        URI uRI = this.birthdayProfileUri(currentDate, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiBirthdayList)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, AbsenceInformation> getAbsenceForProfiles(@NotNull Set<String> profileIds) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        WebClient webClient = this.webClient;
        URI uri$iv = this.absenceForProfilesUri;
        boolean $i$f$post = false;
        return (Map)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getAbsenceForProfiles$$inlined$post$1((WebClient)$this$post$iv, uri$iv, profileIds, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AbsenceInformation updateAbsenceNote(@NotNull String profileId, @NotNull UpdateAbsenceNoteData updateAbsenceNoteData) {
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceNoteData, (String)"updateAbsenceNoteData");
        WebClient webClient = this.webClient;
        URI uRI = this.updateAbsenceNoteUri(profileId);
        boolean $i$f$post = false;
        return (AbsenceInformation)BuildersKt.runBlocking$default(null, (Function2)((Function2)new updateAbsenceNote$$inlined$post$1((WebClient)$this$post$iv, (URI)uri$iv, (Object)updateAbsenceNoteData, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AbsenceInformation updateAbsenceStatus(@NotNull String profileId, @NotNull UpdateAbsenceStatusData updateAbsenceStatusData) {
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceStatusData, (String)"updateAbsenceStatusData");
        WebClient webClient = this.webClient;
        URI uRI = this.updateAbsenceStatusUri(profileId);
        boolean $i$f$post = false;
        return (AbsenceInformation)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void enableBirthdayReminderForProfile(@NotNull String profileId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.updateBirthdayReminderForProfileUri(profileId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new enableBirthdayReminderForProfile$$inlined$post$1((WebClient)$this$post$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void disableBirthdayReminderForProfile(@NotNull String profileId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.updateBirthdayReminderForProfileUri(profileId);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new disableBirthdayReminderForProfile$$inlined$delete$1((WebClient)$this$delete$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> suggestProfiles(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.suggestProfilesUri(query, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiProfiles)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    private URI profileUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/" + profileId), null, null, (int)6, null);
    }

    private URI profilesUri(String query, int offset, int limit) {
        Map map;
        Map $this$profilesUri_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$profilesUri_u24lambda_u240.put("offset", offset);
        $this$profilesUri_u24lambda_u240.put("limit", limit);
        if (query != null) {
            $this$profilesUri_u24lambda_u240.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles"), (Map)params, null, (int)4, null);
    }

    private URI userGroupsUri(String query, int offset, int limit) {
        Map map;
        Map $this$userGroupsUri_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$userGroupsUri_u24lambda_u241.put("offset", offset);
        $this$userGroupsUri_u24lambda_u241.put("limit", limit);
        if (query != null) {
            $this$userGroupsUri_u24lambda_u241.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/usergroups"), (Map)params, null, (int)4, null);
    }

    private URI userGroupDetailsUri(String groupId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/usergroups/" + groupId), null, null, (int)6, null);
    }

    private URI userGroupMembersUri(String groupId, int offset, int limit) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"offset", (Object)offset), TuplesKt.to((Object)"limit", (Object)limit)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/usergroups/" + groupId + "/members"), (Map)params, null, (int)4, null);
    }

    private URI birthdayProfileUri(String currentDate, int offset, int limit) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"currentDate", (Object)currentDate), TuplesKt.to((Object)"offset", (Object)offset), TuplesKt.to((Object)"limit", (Object)limit)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/birthdayList"), (Map)params, null, (int)4, null);
    }

    private URI updateAbsenceNoteUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/" + profileId + "/absence/note"), null, null, (int)6, null);
    }

    private URI updateAbsenceStatusUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/" + profileId + "/absence/status"), null, null, (int)6, null);
    }

    private URI updateBirthdayReminderForProfileUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/birthdayList/reminder/" + profileId), null, null, (int)6, null);
    }

    private URI suggestProfilesUri(String query, int offset, int limit) {
        Map map;
        Map $this$suggestProfilesUri_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$suggestProfilesUri_u24lambda_u242.put("offset", offset);
        $this$suggestProfilesUri_u24lambda_u242.put("limit", limit);
        $this$suggestProfilesUri_u24lambda_u242.put("type", PeopleApiSearchType.PROFILE);
        if (query != null) {
            $this$suggestProfilesUri_u24lambda_u242.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/search/names"), (Map)params, null, (int)4, null);
    }
}

