/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.people.model.local.AbsenceInformation;
import de.justsoftware.mobile.gateway.people.model.local.BirthdayProfile;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.people.model.local.ProfileConfiguration;
import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.model.local.ProfileSection;
import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceNoteData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceStatusData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateBirthdayData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileDetailsData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileSectionData;
import de.justsoftware.mobile.gateway.people.model.local.UserGroup;
import de.justsoftware.mobile.gateway.people.service.PeopleService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/people"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u001a\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0017J$\u0010\u000e\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0017J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0017J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0017J\u0012\u0010\u0019\u001a\u00020\u00182\b\b\u0001\u0010\u001a\u001a\u00020\rH\u0017J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\b\b\u0001\u0010\u001a\u001a\u00020\r2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0017J$\u0010\u001c\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0017J\u001a\u0010\u001f\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0017J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00122\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\"\u001a\u00020#H\u0017J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020!0\u00122\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\"\u0010%\u001a\b\u0012\u0004\u0012\u00020!0\u00122\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010&\u001a\u00020\rH\u0017J\u0012\u0010'\u001a\u00020(2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J$\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020+0*2\u000e\b\u0001\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-H\u0017J\u001c\u0010.\u001a\u00020+2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010/\u001a\u000200H\u0017J\u001c\u00101\u001a\u00020+2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u00102\u001a\u000203H\u0017J$\u00104\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u00105\u001a\u0002062\u0006\u0010\b\u001a\u00020\tH\u0017J&\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00122\u0006\u00109\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0017J\u0012\u0010:\u001a\u00020;2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010<\u001a\u00020;2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J,\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\b\b\u0001\u0010\u0013\u001a\u00020\r2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lde/justsoftware/mobile/gateway/people/controller/PeopleController;", "", "peopleService", "Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "<init>", "(Lde/justsoftware/mobile/gateway/people/service/PeopleService;)V", "getCurrentUser", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "getProfileDetails", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "profileId", "", "updateProfileDetails", "updateProfileDetailsData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileDetailsData;", "getProfiles", "", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "updateAttribute", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileSection;", "updateAttributeData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileSectionData;", "getAttributes", "deleteAttributes", "sectionKey", "getConfiguration", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileConfiguration;", "getAbsenceInformation", "", "Lde/justsoftware/mobile/gateway/people/model/local/AbsenceInformation;", "profileIds", "", "updateAbsenceNote", "updateAbsenceNoteData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceNoteData;", "updateAbsenceStatus", "updateAbsenceStatusData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceStatusData;", "updateProfileBirthday", "updateBirthdayData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateBirthdayData;", "getBirthdayProfiles", "Lde/justsoftware/mobile/gateway/people/model/local/BirthdayProfile;", "currentDate", "enableBirthdayReminderForProfile", "", "disableBirthdayReminderForProfile", "suggestProfiles", "mobile-gateway"})
public class PeopleController {
    @NotNull
    private final PeopleService peopleService;

    public PeopleController(@NotNull PeopleService peopleService) {
        Intrinsics.checkNotNullParameter((Object)peopleService, (String)"peopleService");
        this.peopleService = peopleService;
    }

    @GetMapping(value={"/current"})
    @NotNull
    public Profile getCurrentUser(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfile(authContext.getProfileId());
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ProfileDetails getProfileDetails(@PathVariable(value="id") @NotNull String profileId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfileDetails(profileId, authContext.getProfileId());
    }

    @PutMapping(value={"/{id}"})
    @NotNull
    public ProfileDetails updateProfileDetails(@PathVariable(value="id") @NotNull String profileId, @RequestBody @NotNull UpdateProfileDetailsData updateProfileDetailsData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateProfileDetailsData, (String)"updateProfileDetailsData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateProfileDetails(profileId, updateProfileDetailsData, authContext.getProfileId());
    }

    @GetMapping
    @NotNull
    public List<Profile> getProfiles(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        return this.peopleService.getProfiles(query, offset, limit);
    }

    @GetMapping(value={"/groups"})
    @NotNull
    public List<UserGroup> getUserGroups(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        return this.peopleService.getUserGroups(query, offset, limit);
    }

    @GetMapping(value={"/groups/{id}"})
    @NotNull
    public UserGroup getUserGroup(@PathVariable(value="id") @NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroup(groupId);
    }

    @GetMapping(value={"/groups/{id}/members"})
    @NotNull
    public List<Profile> getUserGroupMembers(@PathVariable(value="id") @NotNull String groupId, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroupMembers(groupId, offset, limit);
    }

    @PostMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails updateUserImage(@PathVariable(value="id") @NotNull String profileId, @RequestPart(value="image") @NotNull MultipartFile image, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateUserImage(profileId, image, authContext.getProfileId());
    }

    @DeleteMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails deleteUserImage(@PathVariable(value="id") @NotNull String profileId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.deleteUserImage(profileId, authContext.getProfileId());
    }

    @PutMapping(value={"/{id}/attribute"})
    @NotNull
    public List<ProfileSection> updateAttribute(@PathVariable(value="id") @NotNull String profileId, @RequestBody @NotNull UpdateProfileSectionData updateAttributeData) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAttributeData, (String)"updateAttributeData");
        return this.peopleService.updateAttribute(profileId, updateAttributeData);
    }

    @GetMapping(value={"/{id}/attributes"})
    @NotNull
    public List<ProfileSection> getAttributes(@PathVariable(value="id") @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.peopleService.getAttributes(profileId);
    }

    @DeleteMapping(value={"/{id}/attributes/{sectionKey}"})
    @NotNull
    public List<ProfileSection> deleteAttributes(@PathVariable(value="id") @NotNull String profileId, @PathVariable(value="sectionKey") @NotNull String sectionKey) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)sectionKey, (String)"sectionKey");
        return this.peopleService.deleteAttributes(profileId, sectionKey);
    }

    @GetMapping(value={"/{id}/configuration"})
    @NotNull
    public ProfileConfiguration getConfiguration(@PathVariable(value="id") @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.peopleService.getConfiguration(profileId);
    }

    @PostMapping(value={"/absence"})
    @NotNull
    public Map<String, AbsenceInformation> getAbsenceInformation(@RequestBody @NotNull Set<String> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.peopleService.getAbsenceInformation(profileIds);
    }

    @PutMapping(value={"/{id}/absence/note"})
    @NotNull
    public AbsenceInformation updateAbsenceNote(@PathVariable(value="id") @NotNull String profileId, @RequestBody @NotNull UpdateAbsenceNoteData updateAbsenceNoteData) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceNoteData, (String)"updateAbsenceNoteData");
        return this.peopleService.updateAbsenceNote(profileId, updateAbsenceNoteData);
    }

    @PutMapping(value={"/{id}/absence/status"})
    @NotNull
    public AbsenceInformation updateAbsenceStatus(@PathVariable(value="id") @NotNull String profileId, @RequestBody @NotNull UpdateAbsenceStatusData updateAbsenceStatusData) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceStatusData, (String)"updateAbsenceStatusData");
        return this.peopleService.updateAbsenceStatus(profileId, updateAbsenceStatusData);
    }

    @PutMapping(value={"/{id}/birthday"})
    @NotNull
    public ProfileDetails updateProfileBirthday(@PathVariable(value="id") @NotNull String profileId, @RequestBody @NotNull UpdateBirthdayData updateBirthdayData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateBirthdayData, (String)"updateBirthdayData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateBirthday(profileId, updateBirthdayData, authContext.getProfileId());
    }

    @GetMapping(value={"/birthdayProfiles"})
    @NotNull
    public List<BirthdayProfile> getBirthdayProfiles(@NotNull String currentDate, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        return this.peopleService.getBirthdayProfiles(currentDate, offset, limit);
    }

    @PostMapping(value={"/birthdayProfiles/{profileId}/enableReminder"})
    public void enableBirthdayReminderForProfile(@PathVariable @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.peopleService.enableBirthdayReminderForProfile(profileId);
    }

    @PostMapping(value={"/birthdayProfiles/{profileId}/disableReminder"})
    public void disableBirthdayReminderForProfile(@PathVariable @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.peopleService.disableBirthdayReminderForProfile(profileId);
    }

    @GetMapping(value={"/suggest"})
    @NotNull
    public List<Profile> suggestProfiles(@RequestParam(name="query") @NotNull String query, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="15") int limit) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.peopleService.suggestProfiles(query, offset, limit);
    }
}

