/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/WebSecurityConfiguration;", "", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "<init>", "(Lde/justsoftware/jwtfilter/verifier/JwtVerifier;)V", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "mobile-gateway"})
public class WebSecurityConfiguration {
    @NotNull
    private final JwtVerifier jwtVerifier;

    public WebSecurityConfiguration(@NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        this.jwtVerifier = jwtVerifier;
    }

    @Bean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http) throws Exception {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Object object = http.securityMatchers(Customizer.withDefaults()).sessionManagement(WebSecurityConfiguration::filterChain$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::filterChain$lambda$1).headers(WebSecurityConfiguration::filterChain$lambda$2).authorizeHttpRequests(WebSecurityConfiguration::filterChain$lambda$3).addFilterAfter((Filter)new JwtAuthenticationProcessingFilter(this.jwtVerifier), AbstractPreAuthenticatedProcessingFilter.class).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void filterChain$lambda$0(SessionManagementConfigurer sessionManagement) {
        sessionManagement.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void filterChain$lambda$1(CsrfConfigurer csrf) {
        csrf.disable();
    }

    private static final void filterChain$lambda$2(HeadersConfigurer headers) {
        headers.cacheControl(Customizer.withDefaults());
    }

    private static final void filterChain$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizeHttpRequests) {
        String[] stringArray = new String[]{"/internal/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(stringArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.anyRequest()).fullyAuthenticated();
    }
}

