/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.auth.service;

import de.justsoftware.mobile.gateway.auth.model.remote.AuthApiTotpDevice;
import de.justsoftware.mobile.gateway.auth.model.remote.AuthApiTotpSecret;
import de.justsoftware.mobile.gateway.auth.service.AuthApiGatewayService$getTotpDevices$;
import de.justsoftware.mobile.gateway.auth.service.AuthApiGatewayService$setupNewTotpDevice$;
import de.justsoftware.mobile.gateway.auth.service.AuthApiGatewayService$verifyNewTotpDevice$;
import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.exception.TotpCodeVerificationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/mobile/gateway/auth/service/AuthApiGatewayService;", "", "authInternalUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "baseUrl", "getTotpDevices", "", "Lde/justsoftware/mobile/gateway/auth/model/remote/AuthApiTotpDevice;", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "setupNewTotpDevice", "Lde/justsoftware/mobile/gateway/auth/model/remote/AuthApiTotpSecret;", "verifyNewTotpDevice", "", "code", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nAuthApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthApiGatewayService.kt\nde/justsoftware/mobile/gateway/auth/service/AuthApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,35:1\n51#2:36\n51#2:37\n85#2:38\n*S KotlinDebug\n*F\n+ 1 AuthApiGatewayService.kt\nde/justsoftware/mobile/gateway/auth/service/AuthApiGatewayService\n*L\n23#1:36\n27#1:37\n30#1:38\n*E\n"})
public class AuthApiGatewayService {
    @NotNull
    private final String authInternalUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final String baseUrl;

    public AuthApiGatewayService(@Value(value="${just.auth.internal.url}") @NotNull String authInternalUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)authInternalUrl, (String)"authInternalUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.authInternalUrl = authInternalUrl;
        this.webClient = webClient;
        this.baseUrl = this.authInternalUrl + "/totp";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AuthApiTotpDevice> getTotpDevices(@NotNull AuthorizationContext authContext) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WebClient webClient = this.webClient;
        String string = this.baseUrl + "/{profileId}";
        Object[] objectArray = new Object[]{authContext.getProfileId()};
        Object[] uriVariables$iv = objectArray;
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getTotpDevices$$inlined$get$1((WebClient)$this$get$iv, (String)uri$iv, uriVariables$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AuthApiTotpSecret setupNewTotpDevice() {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        String string = this.baseUrl + "/setup";
        Object[] uriVariables$iv = new Object[]{};
        boolean $i$f$get = false;
        return (AuthApiTotpSecret)BuildersKt.runBlocking$default(null, (Function2)((Function2)new setupNewTotpDevice$$inlined$get$1((WebClient)$this$get$iv, (String)uri$iv, uriVariables$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyNewTotpDevice(@NotNull String code) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        WebClient webClient = this.webClient;
        String string = this.baseUrl + "/setup/{code}";
        Object[] objectArray = new Object[]{code};
        Object[] uriVariables$iv = objectArray;
        boolean $i$f$put = false;
        if (!((Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new verifyNewTotpDevice$$inlined$put$1((WebClient)$this$put$iv, (String)uri$iv, uriVariables$iv, null)), (int)1, null)).booleanValue()) {
            throw new TotpCodeVerificationException(TotpCodeVerificationException.Reason.CODE_INVALID);
        }
    }
}

