/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.google.common.base.Objects;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.rest.models.ShareDetails;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Person
implements ShareDetails.ShareRoleDetails {
    private final PersonId _id;
    private final String _fullname;
    private final String _imageUrl;
    private final String _profileHash;
    private final boolean _active;
    private final boolean _blocked;
    private final boolean _deleted;

    public Person(PersonId id, String fullname, String imageUrl, String profileHash, boolean active, boolean blocked, boolean deleted) {
        this._id = id;
        this._fullname = fullname;
        this._imageUrl = imageUrl;
        this._profileHash = profileHash;
        this._active = active;
        this._blocked = blocked;
        this._deleted = deleted;
    }

    @Nonnull
    public PersonId getId() {
        return this._id;
    }

    @Nonnull
    public String getFullname() {
        return this._fullname;
    }

    @Nonnull
    public String getImageUrl() {
        return this._imageUrl;
    }

    @Nonnull
    public String getProfileHash() {
        return this._profileHash;
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public String getRoleId() {
        return this._id.asPermissionRole().asString();
    }

    public boolean isAllUsersGroup() {
        return false;
    }

    @Nonnull
    private Object[] getHashObjects() {
        return new Object[]{this._id, this._fullname, this._imageUrl, this._profileHash, this._active, this._blocked, this._deleted};
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj instanceof Person && Arrays.equals(this.getHashObjects(), ((Person)obj).getHashObjects());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])this.getHashObjects());
    }
}

