/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.models.Folder;
import de.justsoftware.drive.rest.models.ItemInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/json"})
@Schema(description="Items")
@ParametersAreNonnullByDefault
public class ItemController {
    final DocumentFrontendService _documentFrontendService;
    final ChangeModificationService _changeModificationService;
    final FolderService _folderService;

    @Autowired
    public ItemController(DocumentFrontendService documentFrontendService, ChangeModificationService changeModificationService, FolderService folderService) {
        this._documentFrontendService = documentFrontendService;
        this._changeModificationService = changeModificationService;
        this._folderService = folderService;
    }

    @Operation(description="Returns info about the given item identified by its itemId.")
    @RequestMapping(value={"/item/{itemId}"}, method={RequestMethod.GET})
    @Nonnull
    public ItemInfo getInfo(AuthorizationContext authCtx, @PathVariable ItemId itemId) {
        this._documentFrontendService.checkRead(authCtx, (AbstractId)itemId);
        DocumentVersionId rootFolderVersionId = this._changeModificationService.getOrCreateNewestChange(itemId, authCtx.getPersonId(), null).getId();
        FolderVersionBO rootFolderVersionBo = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)rootFolderVersionId)).get((Object)rootFolderVersionId);
        if (rootFolderVersionBo == null) {
            throw new UnknownResourceException("missing folder for item " + String.valueOf(itemId));
        }
        if (!rootFolderVersionBo.isRoot()) {
            throw new IllegalStateException("found a root folder which is not marked as root, this is possibly a database problem!");
        }
        Folder rootFolder = this._documentFrontendService.documentCreator((DocumentVersionBO)rootFolderVersionBo, authCtx, null).visit(rootFolderVersionBo);
        return new ItemInfo(itemId, rootFolder);
    }
}

