/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.common.PreviewAccessTokenService;
import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.TempFileService;
import de.justsoftware.drive.business.preview.CropStrategy;
import de.justsoftware.drive.business.preview.ImagePreviewOptions;
import de.justsoftware.drive.business.preview.ImagePreviewOptionsImpl;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FilePreviewByteSource;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.TempFileBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.exceptions.BadRequestException;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/previews"})
@Schema(description="DocumentPreviews")
@ParametersAreNonnullByDefault
public class FilePreviewController {
    private static final Logger LOG = LoggerFactory.getLogger(FilePreviewController.class);
    private static final String REQUESTED_FILE_WAS_NOT_FOUND = "Requested file was not found";
    private static final String PREVIEW_NOT_AVAILABLE = "preview not available";
    private static final CacheControl CACHE_FOR_LONG_TIME = CacheControl.maxAge((long)33L, (TimeUnit)TimeUnit.HOURS).cachePrivate().noTransform();
    private static final int APP_ICON_WIDTH = 512;
    private static final int APP_ICON_HEIGHT = 512;
    private final RestTemplate _restTemplate;
    private final FilePreviewService _previewService;
    private final DocumentFrontendService _documentFrontendService;
    private final FileService _fileService;
    private final PreviewAccessTokenService _previewAccessTokenService;
    private final TempFileService _tempFileService;

    @Autowired
    public FilePreviewController(@Qualifier(value="driveFilePersistenceRestTemplate") RestTemplate restTemplate, FilePreviewService previewService, DocumentFrontendService documentFrontendService, FileService fileService, PreviewAccessTokenService previewAccessTokenService, TempFileService tempFileService) {
        this._restTemplate = restTemplate;
        this._previewService = previewService;
        this._documentFrontendService = documentFrontendService;
        this._fileService = fileService;
        this._previewAccessTokenService = previewAccessTokenService;
        this._tempFileService = tempFileService;
    }

    @Nonnull
    static ResponseEntity<Resource> wrapResource(FilePreviewByteSource documentResource) throws IOException {
        return FilePreviewController.wrapResource((FilePreviewByteSource)documentResource, null);
    }

    @Nonnull
    private static ResponseEntity<Resource> wrapResource(FilePreviewByteSource documentResource, boolean withCache) throws IOException {
        if (!withCache) {
            return FilePreviewController.wrapResource((FilePreviewByteSource)documentResource);
        }
        return FilePreviewController.wrapResource((FilePreviewByteSource)documentResource, (CacheControl)CACHE_FOR_LONG_TIME);
    }

    @Nonnull
    private static ResponseEntity<Resource> wrapResource(FilePreviewByteSource documentResource, @Nullable CacheControl cacheControl) throws IOException {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (cacheControl != null) {
            httpHeaders.setCacheControl(cacheControl);
        }
        httpHeaders.setContentLength(documentResource.getSize());
        httpHeaders.add("Content-type", documentResource.getContentType());
        return new ResponseEntity((Object)new InputStreamResource(documentResource.getByteSource().openBufferedStream()), (MultiValueMap)httpHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(description="Returns a preview for the given documentVersionId in form of a HTML page.")
    @Nonnull
    @RequestMapping(value={"/{fileVersionId}/"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> get(AuthorizationContext authCtx, @PathVariable DocumentVersionId fileVersionId) throws IOException {
        return this.getHtmlResource(authCtx, fileVersionId, "index.html");
    }

    @Hidden
    @Nonnull
    @RequestMapping(value={"/{fileVersionId}/{resource:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> getHtmlResource(AuthorizationContext authCtx, @PathVariable DocumentVersionId fileVersionId, @PathVariable(value="resource") String resourceName) throws IOException {
        this._documentFrontendService.checkRead(authCtx, fileVersionId);
        FilePreviewByteSource filePreview = this._previewService.getFilePreview(fileVersionId, resourceName);
        if (filePreview != null) {
            return FilePreviewController.wrapResource((FilePreviewByteSource)filePreview);
        }
        throw new UnknownResourceException("preview not available");
    }

    @Operation(description="Returns a thumbnail within the given size parameters.")
    @RequestMapping(value={"/thumbnail/{documentId}"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> getThumbnail(AuthorizationContext authCtx, @Nullable @RequestHeader(value="Accept", required=false) MediaType[] acceptedMimeTypes, @PathVariable DocumentId documentId, @RequestParam int width, @RequestParam int height, @RequestParam(name="cache", required=false) boolean withCache) {
        this.throwExceptionIfImageSizeExceedsLimit(width, height);
        this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        ImagePreviewOptionsImpl previewOptions = ImagePreviewOptionsImpl.Builder.withStaticGifSupport((int)width, (int)height).cropStrategy(CropStrategy.EXACT_DIMENSIONS).supportedMediaTypes(acceptedMimeTypes).build();
        try {
            return FilePreviewController.wrapResource((FilePreviewByteSource)this._previewService.getImage(documentId, (ImagePreviewOptions)previewOptions), (boolean)withCache);
        }
        catch (IOException e) {
            throw new UnknownResourceException("Thumbnail generation for the requested resource is not available.");
        }
    }

    @Operation(description="Returns the binary content of the preview image for the latest version of the requested document. Keeps aspect ratio.")
    @RequestMapping(value={"/previewImage/{documentId}/latest"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> previewForImageLatest(AuthorizationContext authCtx, @Nullable @RequestHeader(value="Accept", required=false) MediaType[] acceptedMimeTypes, @PathVariable DocumentId documentId, @RequestParam(required=false, defaultValue="1920") int width, @RequestParam(required=false, defaultValue="1080") int height) {
        this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        FileVersionBO fileVersion = this._fileService.getLastFileVersion(documentId);
        if (fileVersion == null) {
            throw new UnknownResourceException("No file version found for document id: '" + String.valueOf(documentId) + "'");
        }
        return this.previewForImage(authCtx, acceptedMimeTypes, fileVersion.getId(), width, height);
    }

    @Operation(description="Returns the binary content of the preview image for the latest version of the requested document with the fixed max size of 512 x 512 pixel.Keeps aspect ratio.")
    @RequestMapping(value={"/previewImage/{documentId}/appIcon"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> appIconImage(AuthorizationContext authCtx, @Nullable @RequestHeader(value="Accept", required=false) MediaType[] acceptedMimeTypes, @PathVariable DocumentId documentId) {
        return this.previewForImageLatest(authCtx, acceptedMimeTypes, documentId, 512, 512);
    }

    @Operation(description="Returns the binary content of the preview image for the requested document version. Keeps aspect ratio.")
    @RequestMapping(value={"/previewImage/{fileVersionId}"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> previewForImage(AuthorizationContext authCtx, @Nullable @RequestHeader(value="Accept", required=false) MediaType[] acceptedMimeTypes, @PathVariable DocumentVersionId fileVersionId, @RequestParam(required=false, defaultValue="1920") int width, @RequestParam(required=false, defaultValue="1080") int height) {
        this.throwExceptionIfImageSizeExceedsLimit(width, height);
        this._documentFrontendService.checkRead(authCtx, fileVersionId);
        ImagePreviewOptionsImpl previewOptions = ImagePreviewOptionsImpl.Builder.gifAsOriginal((int)width, (int)height).cropStrategy(CropStrategy.KEEP_ASPECT_RATIO).supportedMediaTypes(acceptedMimeTypes).build();
        try {
            return FilePreviewController.wrapResource((FilePreviewByteSource)this._previewService.getImage(fileVersionId, (ImagePreviewOptions)previewOptions));
        }
        catch (IOException e) {
            throw new UnknownResourceException("Requested file was not found");
        }
    }

    @Deprecated
    @Operation(description="Returns the binary content of the requested video.", hidden=true)
    @RequestMapping(value={"/previewVideoFile/{fileVersionId}"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<ByteArrayResource> previewForVideoFile(AuthorizationContext authCtx, @RequestHeader HttpHeaders headers, @PathVariable DocumentVersionId fileVersionId) throws IOException {
        LOG.warn("Call to deprecated route '/previewVideoFile'. User-Agent: '{}'.", (Object)headers.get((Object)"User-Agent"));
        return this.embedFile(authCtx, headers, fileVersionId);
    }

    @Operation(description="Endpoint dedicated to streaming various resources. Returns the latest version of a document. Use this when download is not intended: 1) download is not counted towards statistics 2) byte-range requests are supported 3) attempts to provide the most appropriate preview.")
    @GetMapping(value={"/embed/{documentId}/latest"})
    @Nonnull
    public ResponseEntity<ByteArrayResource> embedFileLatest(AuthorizationContext authCtx, @RequestHeader HttpHeaders requestHeaders, @PathVariable DocumentId documentId) {
        this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        FileVersionBO fileVersion = this._fileService.getLastFileVersion(documentId);
        if (fileVersion == null) {
            throw new UnknownResourceException("No file version found for document id: '" + String.valueOf(documentId) + "'");
        }
        return this.embedFile(authCtx, requestHeaders, fileVersion.getId());
    }

    @Operation(description="Endpoint dedicated to streaming various resources. Use this when download is not intended: 1) download is not counted towards statistics 2) byte-range requests are supported 3) attempts to provide the most appropriate preview.")
    @GetMapping(value={"/embed/{fileVersionId}"})
    @Nonnull
    public ResponseEntity<ByteArrayResource> embedFile(AuthorizationContext authCtx, @RequestHeader HttpHeaders requestHeaders, @PathVariable DocumentVersionId fileVersionId) {
        URI backendRequestUrl;
        this._documentFrontendService.checkRead(authCtx, fileVersionId);
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(fileVersionId);
        if (fileVersion == null) {
            throw new UnknownResourceException("No file version found for file version id: '" + String.valueOf(fileVersionId) + "'");
        }
        MimeType mimeType = MimeTypeUtils.parseMimeType((String)fileVersion.getMimeType());
        switch (mimeType.getType()) {
            case "audio": {
                backendRequestUrl = URI.create(this._fileService.getFileStorageUrl(fileVersion));
                break;
            }
            case "video": {
                backendRequestUrl = URI.create(this._previewService.getConvertedVideoUrl(fileVersionId));
                break;
            }
            default: {
                return ResponseEntity.badRequest().build();
            }
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        if (!requestHeaders.getRange().isEmpty()) {
            httpHeaders.setRange(requestHeaders.getRange());
        }
        httpHeaders = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)httpHeaders);
        RequestEntity judoRequest = RequestEntity.get((URI)backendRequestUrl).headers(httpHeaders).build();
        return this._restTemplate.exchange(judoRequest, ByteArrayResource.class);
    }

    @Operation(description="Get the JWT encoded and signed fileVersionId for downloading video previews without authentication for the latest version of the document")
    @RequestMapping(value={"/preview/{documentId}/accessToken"}, method={RequestMethod.GET}, produces={"application/json"})
    @Nonnull
    public String getPreviewAccessToken(AuthorizationContext authCtx, @PathVariable DocumentId documentId) {
        this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        FileVersionBO fileVersion = this._fileService.getLastFileVersion(documentId);
        if (fileVersion == null) {
            throw new UnknownResourceException("Requested file was not found");
        }
        this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        DocumentVersionId fileVersionId = fileVersion.getId();
        this._documentFrontendService.checkRead(authCtx, fileVersionId);
        this._previewService.checkPreviewWillBeAvailableAtOnePoint(fileVersionId);
        return JSONObject.quote((String)this._previewAccessTokenService.encodeFileVersionId(fileVersionId));
    }

    @Operation(description="Returns the binary content of the requested document,returns original image size on default and for gifs, keeps aspect ratio")
    @RequestMapping(value={"/image/{documentId}"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> getImage(AuthorizationContext authCtx, @Nullable @RequestHeader(value="Accept", required=false) MediaType[] acceptedMimeTypes, @PathVariable DocumentId documentId, @Parameter(schema=@Schema(defaultValue="0"), description="The maximum width. If set to 0, the original width of the resource is used.") @RequestParam(required=false, defaultValue="0") int width, @Parameter(schema=@Schema(defaultValue="0"), description="The maximum height. If set to 0, the original height of the resource is used.") @RequestParam(required=false, defaultValue="0") int height, @Parameter(schema=@Schema(defaultValue="0"), description="Set to true if you wish to receive a cache header (for 33 hours).") @RequestParam(required=false) boolean withCache) {
        this.throwExceptionIfImageSizeExceedsLimit(width, height);
        this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        ImagePreviewOptionsImpl previewOptions = ImagePreviewOptionsImpl.Builder.gifAsOriginal((int)width, (int)height).cropStrategy(CropStrategy.KEEP_ASPECT_RATIO).supportedMediaTypes(acceptedMimeTypes).build();
        try {
            return FilePreviewController.wrapResource((FilePreviewByteSource)this._previewService.getImage(documentId, (ImagePreviewOptions)previewOptions), (boolean)withCache);
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new UnknownResourceException("Requested file was not found");
        }
    }

    @Operation(description="Provides an endpoint to retrieve binary content of an image for specific parameters.")
    @RequestMapping(value={"/image/temporary/{id}"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> getPreviewForTemporaryUpload(AuthorizationContext authCtx, @Nullable @RequestHeader(value="Accept", required=false) MediaType[] acceptedMimeTypes, @PathVariable TempFileId id, @Parameter(schema=@Schema(defaultValue="0"), description="Set to 0 to use the original width of the resource.") @RequestParam(required=false, defaultValue="0") int width, @Parameter(schema=@Schema(defaultValue="0"), description="Set to 0 to use the original height of the resource.") @RequestParam(required=false, defaultValue="0") int height, @Parameter(schema=@Schema(defaultValue="KEEP_ASPECT_RATIO"), description="A strategy how to handle image dimensions when applying width and height. See CropStrategy enum for more information.") @RequestParam(required=false, defaultValue="KEEP_ASPECT_RATIO") CropStrategy cropStrategy) throws IOException {
        this.throwExceptionIfImageSizeExceedsLimit(width, height);
        TempFileBO tempFileBO = (TempFileBO)this._tempFileService.getTempFiles(Set.of(id)).get((Object)id);
        if (!tempFileBO.getOwner().equals((Object)authCtx.getPersonId())) {
            throw new UnknownResourceException("Person is not allowed to request a preview for this file.");
        }
        ImagePreviewOptionsImpl previewOptions = ImagePreviewOptionsImpl.Builder.withStaticGifSupport((int)width, (int)height).cropStrategy(cropStrategy).supportedMediaTypes(acceptedMimeTypes).build();
        return FilePreviewController.wrapResource((FilePreviewByteSource)this._previewService.getImage(id, (ImagePreviewOptions)previewOptions));
    }

    private void throwExceptionIfImageSizeExceedsLimit(int width, int height) {
        if (width * height >= 75000000) {
            throw new BadRequestException("The requested image exceeds the pixel limit of 75000000");
        }
        if (width < 0 || height < 0) {
            throw new BadRequestException("The requested image proportion size is less than 0.");
        }
    }
}

