/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.file.FileVersionCreateModel;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface FileVersionDAO {
    @Nonnull
    public FileVersionCreateModel fileVersionCreateModel();

    @Nonnull
    public FileVersionCreateModel fileVersionCreateModel(DocumentVersionId var1);

    public void insertFileVersions(Iterable<FileVersionCreateModel> var1);

    @Nonnull
    public ImmutableMap<DocumentVersionId, FileVersionBO> getByIds(Set<DocumentVersionId> var1);

    @Nonnull
    public ImmutableListMultimap<DocumentId, FileVersionBO> getVersionsByDocumentIds(Set<DocumentId> var1);

    @Nonnull
    public ImmutableList<FileVersionBO> getLatestVersions(DocumentId var1, int var2);

    public void deleteFileVersions(Set<DocumentVersionId> var1);

    @Nonnull
    public ImmutableListMultimap<DocumentVersionId, FileVersionBO> getFileVersionsByChangeIds(Set<DocumentVersionId> var1);

    @Nonnull
    public Set<StorageId> getReferencedStorageIds(Set<StorageId> var1);

    @Nonnull
    public List<FileVersionBO> getAllVersionsForItem(ItemId var1);

    public void deleteAllFromItem(ItemId var1);

    @Nonnull
    public Set<StorageId> getExclusiveStorageIdsForItem(ItemId var1);

    public void setVideoTeaser(DocumentVersionId var1, VideoTeaserId var2);

    public void deleteVideoTeaser(DocumentVersionId var1);
}

