/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.common.document.model.DocumentBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.document.DocumentMapper;
import io.micrometer.observation.annotation.Observed;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.cursor.Cursor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
@Observed
public class DocumentDAOImpl
implements DocumentDAO {
    private final DocumentMapper _documentMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public DocumentDAOImpl(DocumentMapper documentMapper, DAOSupport daoSupport) {
        this._documentMapper = documentMapper;
        this._daoSupport = daoSupport;
    }

    public void repairMissingLastVersionLink() {
        this._documentMapper.repairMissingLastVersionLink();
    }

    public void updateLastVersions(Set<DocumentId> documentIds) {
        this._daoSupport.partition(documentIds).noResult(arg_0 -> ((DocumentMapper)this._documentMapper).updateLastVersions(arg_0));
    }

    public ImmutableBiMap<DocumentId, DocumentVersionId> getLastVersions(Set<DocumentId> documentIds) {
        return (ImmutableBiMap)this._daoSupport.partition(documentIds).projection().asBiMap().query((arg_0, arg_1) -> ((DocumentMapper)this._documentMapper).getLastVersions(arg_0, arg_1));
    }

    public ImmutableMap<DocumentId, Integer> getLastVersionNumbers(Set<DocumentId> documentIds) {
        return this._daoSupport.partition(documentIds).asMap((arg_0, arg_1) -> ((DocumentMapper)this._documentMapper).getLastVersionNumbers(arg_0, arg_1));
    }

    public void prepareDelete(Set<DocumentId> documentIds) {
        this._daoSupport.partition(documentIds).noResult(arg_0 -> ((DocumentMapper)this._documentMapper).prepareDelete(arg_0));
    }

    public void deleteFinally(Set<DocumentId> documentIds) {
        this._daoSupport.partition(documentIds).noResult(arg_0 -> ((DocumentMapper)this._documentMapper).deleteFinally(arg_0));
    }

    public void updateMetadata(DocumentId documentId, String newDesc, String newTags) {
        if (newDesc == null && newTags == null) {
            return;
        }
        this._documentMapper.updateDescription(documentId, newDesc, newTags);
    }

    public ImmutableMap<DocumentId, DocumentBO> getDocumentsById(Set<DocumentId> ids) {
        return (ImmutableMap)this._daoSupport.partition(ids).index(DocumentBO::getId).asMap().query((arg_0, arg_1) -> ((DocumentMapper)this._documentMapper).getDocumentsById(arg_0, arg_1));
    }

    public ImmutableSetMultimap<ItemId, DocumentId> getDocumentIdsPerItems(Set<ItemId> items) {
        return this._daoSupport.partition(items).asSetMultimap((arg_0, arg_1) -> ((DocumentMapper)this._documentMapper).getDocumentIdsPerItems(arg_0, arg_1));
    }

    public void unlinkLastVersionUpdatedByChanges(Set<DocumentVersionId> changeIds) {
        this._daoSupport.partition(changeIds).noResult(arg_0 -> ((DocumentMapper)this._documentMapper).unlinkLastVersionUpdatedByChanges(arg_0));
    }

    public void deleteAllWithoutVersions() {
        this._documentMapper.deleteAllWithoutVersion();
    }

    public void prepareDeleteItem(ItemId itemId) {
        this._documentMapper.prepareDeleteItem(itemId);
    }

    public Cursor<DocumentId> streamAllSearchableDocumentIds() {
        return this._documentMapper.streamAllSearchableDocumentIds();
    }
}

