/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.google.common.base.Optional;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionDAO;
import io.micrometer.observation.annotation.Observed;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Observed
@ParametersAreNonnullByDefault
@Service
public class ItemWriteServiceImpl
implements ItemWriteService {
    private final ItemDAO _itemDao;
    private final SharePermissionDAO _sharePermissionDAO;

    @Autowired
    public ItemWriteServiceImpl(ItemDAO itemDao, SharePermissionDAO sharePermissionDAO) {
        this._itemDao = itemDao;
        this._sharePermissionDAO = sharePermissionDAO;
    }

    public void setParents(Map<ItemId, Optional<ItemId>> parents) {
        this._itemDao.setParents(parents);
    }

    public void setNames(Map<ItemId, String> names) {
        this._itemDao.setNames(names);
    }

    public void setTenantIdIfNotExists(ItemId itemId, TenantId tenantId) {
        this._itemDao.setTenantIdIfNotExists(itemId, tenantId);
    }

    public void markAsDeleted(Set<ItemId> itemIds) {
        this._itemDao.markAsDeleted(itemIds);
        this._sharePermissionDAO.deleteShares(itemIds);
    }

    public void storeItem(Map<ItemId, ItemCreateModel> items) {
        this._itemDao.storeItems(items);
    }
}

