/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.event.ItemVisibilitiesChangedEvent;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@Service
public class ItemKafkaConsumer
extends AbstractKafkaConsumer<String, String> {
    static final String TOPIC = "just.items";
    private final ItemWriteService _itemWriteService;
    private final EventBus _eventBus;
    private final ChangeModificationService _changeModificationService;

    @Autowired
    public ItemKafkaConsumer(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionSupport transactionSupport, ItemWriteService itemWriteService, EventBus eventBus, ChangeModificationService changeModificationService) {
        this(kafkaConfigurationProvider.stringConsumer("just.drive.ItemConsumer"), transactionSupport, itemWriteService, eventBus, changeModificationService);
    }

    @VisibleForTesting
    ItemKafkaConsumer(@Nullable Consumer<String, String> consumer, TransactionSupport transactionSupport, ItemWriteService itemWriteService, EventBus eventBus, ChangeModificationService changeModificationService) {
        super(consumer, transactionSupport, "just.items");
        this._itemWriteService = itemWriteService;
        this._eventBus = eventBus;
        this._changeModificationService = changeModificationService;
    }

    protected void process(ConsumerRecords<String, String> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        HashSet deletes = new HashSet();
        HashMap items = new HashMap();
        HashMap admins = new HashMap();
        records.forEach(record -> this.processRecord(record, deletes, items, admins));
        this._itemWriteService.markAsDeleted(deletes);
        this._itemWriteService.storeItem(items);
        this._changeModificationService.createRootFoldersIfNecessary(admins);
        this._eventBus.post((Object)new ItemVisibilitiesChangedEvent((Iterable)Sets.union(deletes, items.keySet())));
    }

    private void processRecord(ConsumerRecord<String, String> record, HashSet<ItemId> deleteBuilder, HashMap<ItemId, ItemCreateModel> items, HashMap<ItemId, PersonId> admins) {
        ItemId itemId = ItemId.valueOf((String)((String)record.key()));
        if (itemId == null) {
            return;
        }
        String value = (String)record.value();
        if (value == null) {
            deleteBuilder.add(itemId);
            items.remove(itemId);
            admins.remove(itemId);
            return;
        }
        JsonNode json = this.parseJson(value);
        if (json == null) {
            return;
        }
        String name = (String)ItemKafkaConsumer.parseString((JsonNode)json, (String)"name").or((Object)"");
        ItemId parentId = ItemKafkaConsumer.parseItemId((JsonNode)json, (String)"parent").orElse(null);
        TenantId tenantId = ItemKafkaConsumer.parseTenantId((JsonNode)json, (String)"tenantId").orElse(null);
        items.put(itemId, new ItemCreateModel(itemId, name, parentId, tenantId));
        deleteBuilder.remove(itemId);
        Optional admin = PersonId.parse((String)((String)ItemKafkaConsumer.parseString((JsonNode)json, (String)"admin").orNull()));
        admin.ifPresent(personId -> admins.put(itemId, (PersonId)personId));
    }
}

