/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.drive.business.authorization.AuthorizationService;
import de.justsoftware.drive.business.authorization.item.DependentItem;
import de.justsoftware.drive.business.authorization.item.ItemTypePredicates;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.ornot.BoolExpr;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Function<? super StaticAction, BoolExpr<de.justsoftware.drive.common.authorization.model.Role>> ALL_FALSE = Functions.constant(null);
    @VisibleForTesting
    final ItemDAO _itemDAO;
    @VisibleForTesting
    final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public AuthorizationServiceImpl(ItemDAO itemDAO, PermissionRequestConnector permissionRequestConnector) {
        this._itemDAO = itemDAO;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public ImmutableSetMultimap<PersonId, de.justsoftware.drive.common.authorization.model.Role> filterRoles(SetMultimap<PersonId, de.justsoftware.drive.common.authorization.model.Role> rolesPerPerson) {
        ImmutableSetMultimap fromPermission = this._permissionRequestConnector.filterRoles((SetMultimap)AuthorizationServiceImpl.permissionRolesPerProfileRole(rolesPerPerson));
        return (ImmutableSetMultimap)rolesPerPerson.entries().stream().filter(e -> (Boolean)((de.justsoftware.drive.common.authorization.model.Role)e.getValue()).accept((Role.Visitor)new /* Unavailable Anonymous Inner Class!! */)).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    private static ImmutableSetMultimap<Role, Role> permissionRolesPerProfileRole(SetMultimap<PersonId, de.justsoftware.drive.common.authorization.model.Role> rolesPerPerson) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        rolesPerPerson.forEach((person, role) -> ((Optional)role.accept((Role.Visitor)new /* Unavailable Anonymous Inner Class!! */)).ifPresent(permissionRole -> result.put((Object)person.asPermissionRole(), permissionRole)));
        return result.build();
    }

    @Nonnull
    private ImmutableMap<ItemId, DependentItem> loadDependentItems(SetMultimap<ItemId, StaticAction> itemsPerAction) {
        Set dependentItemIds = Sets.filter((Set)itemsPerAction.keySet(), (Predicate)ItemTypePredicates.DEPENDENT_ITEM.forIds());
        ImmutableMap items = this._itemDAO.getItems(dependentItemIds);
        return FluentIterable.from((Iterable)dependentItemIds).toMap(input -> new DependentItem(input, (ItemBO)items.get(input)));
    }
}

