/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.business.authorization.AuthorizationItem;
import de.justsoftware.drive.business.authorization.AuthorizationKey;
import de.justsoftware.drive.business.authorization.AuthorizationResolver;
import de.justsoftware.drive.business.authorization.AuthorizationResult;
import de.justsoftware.drive.business.authorization.AuthorizationService;
import de.justsoftware.drive.business.authorization.ItemService;
import de.justsoftware.drive.business.authorization.impl.AuthorizationResolverImpl;
import de.justsoftware.drive.business.authorization.item.FileItem;
import de.justsoftware.drive.business.change.ChangeService;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.authorization.model.StaticRole;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.ornot.BoolExpr;
import de.justsoftware.ornot.BoolExprs;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.shaded.com.google.common.base.Predicates;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class AuthorizationResolverImpl
implements AuthorizationResolver {
    private final AuthorizationService _authorizationService;
    private final ItemService _itemService;
    private final ChangeService _changeService;
    private final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public AuthorizationResolverImpl(AuthorizationService authorizationService, ItemService itemService, ChangeService changeService, PermissionRequestConnector permissionRequestConnector) {
        this._authorizationService = authorizationService;
        this._itemService = itemService;
        this._changeService = changeService;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public <I extends AbstractId<?>> ImmutableMap<AuthorizationKey<I>, AuthorizationResult> resolveAllowedActions(Set<AuthorizationKey<I>> authorizationKeys) {
        ImmutableSet ids = FluentIterable.from(authorizationKeys).transformAndConcat(input -> input.getId().asSet()).toSet();
        ImmutableListMultimap items = this._itemService.loadItems((Set)ids);
        ImmutableSetMultimap.Builder shareActions = ImmutableSetMultimap.builder();
        for (AuthorizationKey authorizationKey : authorizationKeys) {
            ImmutableList path = items.get((Object)((AbstractId)authorizationKey.getId().orNull()));
            path.stream().map(AuthorizationItem::getId).filter(ItemId.class::isInstance).map(ItemId.class::cast).forEach(itemId -> shareActions.put((Object)authorizationKey.getPersonId().asPermissionRole(), (Object)AuthorizationResolverImpl.roleForPermission((AuthorizationKey)authorizationKey, (ItemId)itemId)));
        }
        ImmutableSetMultimap sharePermissions = this._permissionRequestConnector.filterRoles((SetMultimap)shareActions.build());
        return (ImmutableMap)authorizationKeys.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), authKey -> AuthorizationResolverImpl.getAuthorizationResult((ImmutableListMultimap)items, (ImmutableSetMultimap)sharePermissions, (AuthorizationKey)authKey)));
    }

    @Nonnull
    private static <I extends AbstractId<?>> AuthorizationResult getAuthorizationResult(ImmutableListMultimap<AbstractId<?>, AuthorizationItem<?>> items, ImmutableSetMultimap<Role, Role> sharePermissions, AuthorizationKey<I> authKey) {
        AbstractId id = (AbstractId)authKey.getId().orNull();
        ImmutableList path = items.get((Object)id);
        if (authKey.getId().isPresent() && (path.isEmpty() || Iterables.tryFind((Iterable)path, AuthorizationItem::isDeleted).isPresent())) {
            return AuthorizationResult.RESOURCE_NOT_FOUND;
        }
        BoolExpr expr = BoolExprs.or(path.stream().map(pathItem -> (BoolExpr)pathItem.accept((AuthorizationItem.Visitor)new /* Unavailable Anonymous Inner Class!! */)));
        PersonId personId = authKey.getPersonId();
        BoolExpr evaluatedExpr = expr.eval(varExpr -> {
            de.justsoftware.drive.common.authorization.model.Role r = (de.justsoftware.drive.common.authorization.model.Role)varExpr.getValue();
            if (StaticRole.DOCUMENT_OWNER.equals((Object)r)) {
                return BoolExprs.valueOf((boolean)path.stream().filter(Predicates.instanceOf(FileItem.class)).anyMatch(d -> ((FileVersionBO)((FileItem)d).getCurrentVersion()).getOwner().equals((Object)personId)));
            }
            return varExpr;
        });
        return BoolExprs.trueExpr().equals(evaluatedExpr) ? AuthorizationResult.OK : AuthorizationResult.NOT_ALLOWED;
    }

    @Nonnull
    private static Role roleForPermission(AuthorizationKey<?> authorizationKey, ItemId itemId) {
        String actionName = AuthorizationResolverImpl.permissionActionName(authorizationKey);
        return Role.itemRole((String)actionName, (String)((String)itemId.getId()));
    }

    @Nonnull
    private static String permissionActionName(AuthorizationKey<?> authorizationKey) {
        return switch (2.$SwitchMap$de$justsoftware$drive$common$authorization$model$StaticAction[authorizationKey.getAction().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "READ";
            case 2 -> "WRITE";
            case 3 -> "DOCUMENT_DELETE";
            case 4 -> "DOCUMENT_DELETE_BY_OWNER";
            case 5 -> "MANAGE";
        };
    }

    @Nonnull
    private ImmutableSetMultimap<PersonId, de.justsoftware.drive.common.authorization.model.Role> loadRoles(ImmutableListMultimap<AbstractId<?>, AuthorizationItem<?>> items, Set<? extends AuthorizationKey<?>> actions, ImmutableTable<ItemId, StaticAction, BoolExpr<de.justsoftware.drive.common.authorization.model.Role>> visibilities) {
        ImmutableSetMultimap.Builder rolesToLoad = ImmutableSetMultimap.builder();
        for (AuthorizationKey<?> authKey : actions) {
            ImmutableList path = items.get((Object)((AbstractId)authKey.getId().orNull()));
            for (AuthorizationItem item : path) {
                BoolExpr result = (BoolExpr)visibilities.get((Object)item.getId(), (Object)authKey.getAction());
                if (result == null) continue;
                result.eval(expr -> {
                    rolesToLoad.put((Object)authKey.getPersonId(), (Object)((de.justsoftware.drive.common.authorization.model.Role)expr.getValue()));
                    return expr;
                });
            }
        }
        return this._authorizationService.filterRoles((SetMultimap)rolesToLoad.build());
    }
}

