/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.persistence.impl;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.jdoc.configuration.JustDocumentsEnvironment;
import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.exceptions.DirectoryCreateFailedException;
import de.justsoftware.jdoc.services.exceptions.DocumentNotFoundException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.services.exceptions.DocumentResourceNotFoundException;
import de.justsoftware.jdoc.services.exceptions.InvalidDocumentIdException;
import de.justsoftware.jdoc.services.exceptions.MissingRequiredDirectoryException;
import de.justsoftware.jdoc.services.monitoring.MonitoredService;
import de.justsoftware.jdoc.services.monitoring.model.HeartbeatStatus;
import de.justsoftware.jdoc.util.JustDocUtil;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FilesystemDAO
implements InitializingBean,
MonitoredService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemDAO.class);
    private static final String STATUS_FOLDER_NAME = "STATUS";
    private static final String TRASH_FOLDER_NAME = "TRASH";
    private static final String QUEUE_FOLDER_NAME = "QUEUE";
    private static final String PROCESSING_FOLDER_NAME = "PROCESSING";
    private static final ImmutableSet<String> RESERVED_FOLDER_NAMES = ImmutableSet.builder().add((Object)"STATUS").add((Object)"TRASH").add((Object)"QUEUE").add((Object)"PROCESSING").build();
    private final JustDocumentsEnvironment _env;
    private HeartbeatStatus _serviceStatus;

    @Autowired
    public FilesystemDAO(JustDocumentsEnvironment env) {
        this._env = env;
        this._serviceStatus = HeartbeatStatus.OK;
    }

    @CheckForNull
    private static DocumentId fileToDocumentId(@Nullable File documentDirectory) {
        if (documentDirectory == null || !documentDirectory.exists() || !documentDirectory.isDirectory()) {
            return null;
        }
        try {
            return DocumentId.fromString((String)documentDirectory.getName());
        }
        catch (InvalidDocumentIdException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no document folder (invalid document id) : {}", (Object)documentDirectory.getAbsolutePath());
            }
            return null;
        }
    }

    private static boolean isDocumentFolder(File f) {
        return f.exists() && f.isDirectory() && !RESERVED_FOLDER_NAMES.contains((Object)f.getName());
    }

    public HeartbeatStatus getStatus() {
        return this._serviceStatus;
    }

    public String getName() {
        return "Basic Storage";
    }

    public void afterPropertiesSet() {
        this.emptyTrash();
    }

    @Nonnull
    public File createFolder(File folder) throws DirectoryCreateFailedException {
        if (!folder.exists()) {
            if (folder.mkdirs()) {
                this._serviceStatus = HeartbeatStatus.OK;
            } else if (!folder.exists()) {
                this._serviceStatus = HeartbeatStatus.ERROR;
                throw new DirectoryCreateFailedException("Folder " + folder.getAbsolutePath() + " can't be created!");
            }
        }
        if (!folder.isDirectory()) {
            throw new DirectoryCreateFailedException("A file by name " + folder.getAbsolutePath() + " already exists, can't create folder!");
        }
        return folder;
    }

    @Nonnull
    public File getFile(File folder, String filename) {
        return new File(folder, filename);
    }

    @Nonnull
    private File getFolder(File root, String name) {
        return new File(root, name);
    }

    @Nonnull
    private File getDocumentRootPath() {
        return new File(this._env.getStorageRepositoryPath());
    }

    @Nonnull
    private File getOrCreateInDocumentRootPath(String folderName) {
        File folder = this.getFolder(this.getDocumentRootPath(), folderName);
        try {
            return this.createFolder(folder);
        }
        catch (DirectoryCreateFailedException e) {
            if (this.checkFolderExists(folder)) {
                return folder;
            }
            throw new MissingRequiredDirectoryException("persistence is missing required folder: " + folder.getAbsolutePath(), (Throwable)e);
        }
    }

    @Nonnull
    private File getStatusFolder() {
        return this.getOrCreateInDocumentRootPath(STATUS_FOLDER_NAME);
    }

    @Nonnull
    private File getTrashFolder() {
        return this.getOrCreateInDocumentRootPath(TRASH_FOLDER_NAME);
    }

    @Nonnull
    public File getQueueFolder() {
        return this.getOrCreateInDocumentRootPath(QUEUE_FOLDER_NAME);
    }

    @Nonnull
    public File getProcessingFolder() {
        return this.getOrCreateInDocumentRootPath(PROCESSING_FOLDER_NAME);
    }

    @Nonnull
    public File getDocumentFolder(DocumentId documentId) {
        return this.getFolder(this.getDocumentRootPath(), documentId.toUniqueId().toString());
    }

    @Nonnull
    public File getStatusFolder(DocumentId documentId) {
        return this.getFolder(this.getStatusFolder(), documentId.toUniqueId().toString());
    }

    @Nonnull
    public File getStatusFolder(DocumentId documentId, DocumentType type) {
        return this.getFolder(this.getStatusFolder(documentId), type.name());
    }

    boolean checkFileExists(File file) {
        return file.exists() && file.isFile();
    }

    @Nonnull
    public File withFileExists(File file) throws DocumentResourceNotFoundException {
        if (!this.checkFileExists(file)) {
            throw new DocumentResourceNotFoundException("no file by path :" + file.getAbsolutePath());
        }
        return file;
    }

    private boolean checkFolderExists(File folder) {
        return folder.exists() && folder.isDirectory();
    }

    private void emptyTrash() {
        File[] trashFiles = this.getTrashFolder().listFiles();
        if (trashFiles != null) {
            for (File trashFile : trashFiles) {
                FileUtils.deleteQuietly((File)trashFile);
            }
        }
    }

    void deleteIfExists(File fileOrFolder) {
        if (fileOrFolder.exists()) {
            File trashFolder = this.getFolder(this.getTrashFolder(), UUID.randomUUID().toString());
            try {
                FileUtils.moveToDirectory((File)fileOrFolder, (File)trashFolder, (boolean)true);
                FileUtils.deleteQuietly((File)trashFolder);
            }
            catch (IOException e) {
                FileUtils.deleteQuietly((File)fileOrFolder);
            }
        }
    }

    @Nonnull
    public File getFolder(DocumentId documentId, DocumentType type) {
        return this.getFolder(this.getDocumentFolder(documentId), type.name());
    }

    @Nonnull
    public File getFile(DocumentId documentId, DocumentType type) {
        return this.getFile(this.getFolder(documentId, type), type.toFilename(documentId));
    }

    @Nonnull
    public Iterable<DocumentId> getAllDocumentIds() {
        return FluentIterable.from((Iterable)JustDocUtil.listFiles((File)this.getDocumentRootPath(), FilesystemDAO::isDocumentFolder)).transform(FilesystemDAO::fileToDocumentId).filter(Predicates.notNull());
    }

    public void deleteStatusFolder(DocumentId documentId, DocumentType type) {
        this.deleteIfExists(this.getStatusFolder(documentId, type));
    }

    @Nonnull
    public File getOrCreateStatusFolder(DocumentId documentId) throws DirectoryCreateFailedException {
        return this.createFolder(this.getStatusFolder(documentId));
    }

    public void deleteQueueFolder() {
        this.deleteIfExists(this.getQueueFolder());
    }

    public void deleteDocument(DocumentId documentId) throws DocumentNotFoundException, DocumentReadWriteException {
        this.deleteIfExists(this.getDocumentFolder(documentId));
        this.deleteIfExists(this.getStatusFolder(documentId));
        this.deleteIfExists(this.getFile(this.getQueueFolder(), documentId.toString()));
    }

    public void deleteDocument(DocumentType type, DocumentId documentId) throws DocumentReadWriteException {
        this.deleteIfExists(this.getFolder(documentId, type));
        this.deleteIfExists(this.getStatusFolder(documentId, type));
    }

    public void deleteProcessingFolder() {
        this.deleteIfExists(this.getProcessingFolder());
    }
}

